package com.xunlei.niux.data.league.bo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.xunlei.niux.data.league.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.signature.SignMd5;
import com.xunlei.niux.data.league.facade.FacadeFactory;

@Service
public class NiuxCashGenerateRecordBoImpl implements NiuxCashGenerateRecordBo {
	static String[] digitletters = new String[] { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C",
			"D", "E", "F", "G", "H", "I", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U",
			"V", "W", "X", "Y", "Z" };
	private static SimpleDateFormat yyMMddHHmmss = new SimpleDateFormat("yyMMddHHmmss");
	private static SimpleDateFormat yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat yyyy_MM_dd_HHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Autowired
	private PromoterBo promoterBo;
	@Autowired
	private NiuxCashBo niuxCashBo;

	@Resource(name = "BaseDao")
	private BaseDao baseDao;

	public NiuxCashBo getNiuxCashBo() {
		return niuxCashBo;
	}

	public void setNiuxCashBo(NiuxCashBo niuxCashBo) {
		this.niuxCashBo = niuxCashBo;
	}

	public PromoterBo getPromoterBo() {
		return promoterBo;
	}

	public void setPromoterBo(PromoterBo promoterBo) {
		this.promoterBo = promoterBo;
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public List<NiuxCashGenerateRecord> finds(NiuxCashGenerateRecord record, Page page) {
		return baseDao.findByObject(NiuxCashGenerateRecord.class, record, page);
	}

	public int count(NiuxCashGenerateRecord record) {
		return baseDao.count(record);
	}

	/**
	 * 生成激活码
	 * 
	 * @param record
	 */
	public void insert(NiuxCashGenerateRecord record) {
		// 判断推官员是否存在
		Promoter promoter = promoterBo.findOne(record.getPromoterAccount());
		if (promoter == null) {
			// 推广账号不存在
			throw new RuntimeException("推广账号[" + record.getPromoterAccount() + "]不存在");
		}
		// 插入代金券生成记录
		record.setGenerateNo(buildGenerateNo());
		record.setGenerateTime(yyyy_MM_dd_HHmmss.format(new Date()));
		if(record.getIsDynamicGenerate()){
			record.setGenerateNum(0);
		}else{
			record.setGenerateNum(record.getGenerateSum());
		}
		baseDao.insert(record);
		// 生成代金券
		generateCashs(record);
	}

	/**
	 * 生成生成编号
	 * 
	 * @return
	 */
	private String buildGenerateNo() {
		return yyMMddHHmmss.format(new Date());
	}

	/**
	 * 生成一批代金券
	 * 
	 * @param record
	 */
	private void generateCashs(final NiuxCashGenerateRecord record) {
		List<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
		CashNoRule rule=getAndLockCashNoRule(record.getCashNoLength());
		for (int i = 0; i < record.getGenerateNum(); i++) {
			niuxCashList.add(generateCash(record,rule));
		}
		if(niuxCashList.size()>0){
			niuxCashBo.insertBatch(niuxCashList);
		}
		baseDao.updateById(rule);
	}

	/**
	 * 生成一个代金券
	 * 
	 * @param record
	 */
	private NiuxCash generateCash(final NiuxCashGenerateRecord record,CashNoRule rule) {
		NiuxCash niuxCash = new NiuxCash();
		niuxCash.setCashNo(getCashNo(rule));
		niuxCash.setCashStatus("0");
		niuxCash.setExpireDate(getCashExpireDate(record));
		niuxCash.setParValue(record.getParValue());
		niuxCash.setUserId("");
		niuxCash.setUseTime("");
		niuxCash.setGenerateNo(record.getGenerateNo());
		niuxCash.setMinPayMoney(record.getMinPayMoney());
		niuxCash.setLimitedgameid(record.getLimitedgameid());
		return niuxCash;
	}
	private CashNoRule getAndLockCashNoRule(int len){
		StringBuilder sb=new StringBuilder("select * from cashnorule where cashNoLength=?");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(len);
		List<CashNoRule> ruleList=baseDao.executeQuery(CashNoRule.class, sb.toString(), paramList);
		return ruleList==null||ruleList.size()==0?null:ruleList.get(0);
	}

	public NiuxCashGenerateRecord findOneByGenerateNo(String generateNo) {
		if (generateNo == null || "".equals(generateNo)) {
			return null;
		}
		NiuxCashGenerateRecord query = new NiuxCashGenerateRecord();
		query.setGenerateNo(generateNo);
		List<NiuxCashGenerateRecord> list = finds(query, new Page());
		return (list == null || list.size() == 0) ? null : list.get(0);
	}
	public  String getCashNo(CashNoRule cashNoRule){
		long nextNum=cashNoRule.getCurNum()<0?0:cashNoRule.getCurNum()+cashNoRule.getStepNum();
		if(nextNum>cashNoRule.getMaxNum()){
			nextNum=nextNum%cashNoRule.getStepNum()+1;
			if(nextNum==cashNoRule.getStepNum()){
				throw new RuntimeException(cashNoRule.getMaxNum()+"已经用完");
			}
		}
		//将数字转化为34进制的表述
		String code="";
		long tempNum=nextNum;
		while(tempNum/digitletters.length>0){
			code=digitletters[(int)(tempNum%digitletters.length)]+code;
			tempNum=tempNum/digitletters.length;
		}
		code=digitletters[(int)(tempNum%digitletters.length)]+code;
		cashNoRule.setCurNum(nextNum);
		if(code.length()>(cashNoRule.getCashNoLength()-cashNoRule.getVerificationCodeLength())){
			throw new RuntimeException("超过生成的长度");
		}
		code="0000000000".substring(0,cashNoRule.getCashNoLength()-cashNoRule.getVerificationCodeLength()-code.length())+code;
		String signCode=SignMd5.tomd5(code+"wnfwefsdbk").substring(0,cashNoRule.getVerificationCodeLength()).toUpperCase();
		signCode=signCode.replaceAll("L", "1");
		signCode=signCode.replaceAll("O", "0");
		code=code+signCode;
		return code;
	}
	
	public NiuxCash addOneCash(String receiveUserId,String generateNo,String orderId){
		NiuxCashGenerateRecord genRecord=findOneByGenerateNo(generateNo);
		
		if(genRecord.getGenerateSum()<=genRecord.getGenerateNum()){
			throw new RuntimeException("牛X代金券批号："+generateNo+"已达到最大生成数量");
		}
		if(genRecord.getIsValid()==false){
			throw new RuntimeException("牛X代金券批号："+generateNo+"接口生成已关闭");
		}
		CashNoRule rule=getAndLockCashNoRule(genRecord.getCashNoLength());
		
		NiuxCash niuxCash=generateCash(genRecord,rule);
		niuxCash.setReceiveUserId(receiveUserId);
		niuxCash.setReceiveTime(yyyy_MM_dd_HHmmss.format(new Date()));
		niuxCash.setReceiveOrderNo(orderId);
		
		List<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
		niuxCashList.add(niuxCash);
		
		niuxCashBo.insertBatch(niuxCashList);
		try{
			baseDao.updateById(rule);
			genRecord.setGenerateNum(genRecord.getGenerateNum()+1);
			baseDao.updateById(genRecord);
		}catch(Exception e){
			e.printStackTrace();
		}

		return niuxCash;
	}
	public NiuxCash addOneCash(String receiveUserId,String generateNo,String orderId,String gameid){
		NiuxCashGenerateRecord genRecord=findOneByGenerateNo(generateNo);

        //如果generateSum字段为0，则不限制生成数量
        if(genRecord.getGenerateSum() != 0){
            if(genRecord.getGenerateSum()<=genRecord.getGenerateNum()){
                throw new RuntimeException("牛X代金券批号："+generateNo+"已达到最大生成数量");
            }
        }
		if(genRecord.getIsValid()==false){
			throw new RuntimeException("牛X代金券批号："+generateNo+"接口生成已关闭");
		}
		CashNoRule rule=getAndLockCashNoRule(genRecord.getCashNoLength());

        NiuxCash niuxCash = new NiuxCash();
        niuxCash.setCashNo(getCashNo(rule));
        niuxCash.setCashStatus("0");
        niuxCash.setExpireDate(getCashExpireDate(genRecord));
        niuxCash.setParValue(genRecord.getParValue());
        niuxCash.setUserId("");
        niuxCash.setUseTime("");
        niuxCash.setGenerateNo(genRecord.getGenerateNo());
        niuxCash.setMinPayMoney(genRecord.getMinPayMoney());
        niuxCash.setLimitedgameid(gameid);
		niuxCash.setReceiveUserId(receiveUserId);
		niuxCash.setReceiveTime(yyyy_MM_dd_HHmmss.format(new Date()));
		niuxCash.setReceiveOrderNo(orderId);

		List<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
		niuxCashList.add(niuxCash);

		niuxCashBo.insertBatch(niuxCashList);
		try{
			baseDao.updateById(rule);
			genRecord.setGenerateNum(genRecord.getGenerateNum()+1);
			baseDao.updateById(genRecord);
		}catch(Exception e){
			e.printStackTrace();
		}

		return niuxCash;
	}
	private String getCashExpireDate(NiuxCashGenerateRecord genRecord){
		if("fix".equals(genRecord.getExpireType())){
			return genRecord.getExpireDate();
		}
		long now=System.currentTimeMillis();
		long expirelong=now+24L*60*60*1000*genRecord.getExpireDays();
		Date expireDate=new Date(expirelong);
		return yyyy_MM_dd.format(expireDate);
	}

	@Override
	public boolean checkReceiver(String receiveUserId, String generateNo) {
		NiuxCash query = new NiuxCash();
		query.setReceiveUserId(receiveUserId);
		query.setGenerateNo(generateNo);
		NiuxCash cash = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(cash != null)return true;
		return false;
	}

    @Override
    public void handoutNiuxCash(String[] uids, String[] generateNos, String handoutBy, String reason) {
        Long handoutid = System.currentTimeMillis();
        String now = yyyy_MM_dd_HHmmss.format(new Date());
        for(String gen:generateNos){
            for(String uid:uids){
                NiuxCash niuxCash = addOneCash(uid,gen,"HANG"+System.currentTimeMillis());
                NiuxCashHandout ncHand = new NiuxCashHandout();
                ncHand.setHandoutid(handoutid);
                ncHand.setUserid(uid);
                ncHand.setGenerateNo(gen);
                ncHand.setCashNo(niuxCash.getCashNo());
                ncHand.setParValue(niuxCash.getParValue());
                ncHand.setHandoutTime(now);
                ncHand.setHandoutBy(handoutBy);
                ncHand.setReason(reason);
                baseDao.insert(ncHand);
            }
        }
    }
}
