package com.xunlei.niux.data.league.bo;

import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.dto.NiuxCashInfoDTO;
import com.xunlei.niux.data.league.vo.NiuxCash;

public interface NiuxCashBo {
	void insertBatch(List<NiuxCash> cashList);
	NiuxCash findOne(String cashNo);
	int count(NiuxCash cash);
	List<NiuxCash> finds(NiuxCash cash,Page page);
	void updateUseCash(NiuxCash cash);
	void updateEmailStat();
	void updateUnfreeze(String cashNo,String userId);
	double findExpireWarnMoney(String userId,int days);

    /**
     * 查询该uid持有代金券数据
     * 范围：代金券过期时间一个月以内
     */
    List<NiuxCashInfoDTO> getNiuxCashInfo(String userid);
    /**
     * 查询该uid持有代金券数据
     * 范围：指定游戏id，代金券过期时间一个月以内
     */
    List<NiuxCashInfoDTO> getNiuxCashInfo(String userid, String gameid);

    /**
     * 查询某用户当月领取过的代金券总和
     * @param userId
     * @param generateNo
     * @return
     */
    int getCashReceivedTimesCurMonth(String userId, String generateNo);
}
