/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.league.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.league.bo.NiuxCashBo;
import com.xunlei.niux.data.league.dto.NiuxCashInfoDTO;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxCashWarnStat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NiuxCashBoImpl
implements NiuxCashBo {
    private static SimpleDateFormat yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat yyyy_MM_ddLong = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<NiuxCash> finds(NiuxCash cash, Page page) {
        return this.baseDao.findByObject(NiuxCash.class, (Object)cash, page);
    }

    @Override
    public int count(NiuxCash cash) {
        return this.baseDao.count((Object)cash);
    }

    @Override
    public NiuxCash findOne(String cashNo) {
        if (cashNo == null || "".equals(cashNo)) {
            return null;
        }
        return (NiuxCash)this.baseDao.findById(NiuxCash.class, cashNo);
    }

    @Override
    public void updateUnfreeze(String cashNo, String userId) {
        if (cashNo == null || "".equals(cashNo)) {
            throw new RuntimeException("cashNo\u4e3a\u7a7a");
        }
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        NiuxCash niuxCash = this.queryAndLock(cashNo);
        if (niuxCash == null) {
            throw new RuntimeException("cashNo[" + cashNo + "]\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(niuxCash.getCashStatus())) {
            throw new NiuRuntimeException("1074", "cashNo[" + cashNo + "]\u672a\u51bb\u7ed3");
        }
        if (niuxCash.getUserId() == null) {
            throw new RuntimeException("cashNo[" + cashNo + "]\u4e0d\u662fuserId[" + userId + "]\u4f7f\u7528");
        }
        if (!userId.equals(niuxCash.getUserId())) {
            throw new RuntimeException("cashNo[" + cashNo + "]\u4e0d\u662fuserId[" + userId + "]\u4f7f\u7528");
        }
        niuxCash.setCashStatus("0");
        niuxCash.setUserId("");
        niuxCash.setUseTime("");
        this.baseDao.updateById((Object)niuxCash);
    }

    private void updateAffirmUseCash(NiuxCash cash) {
        if (cash.getCashNo() == null || cash.getCashNo().equals("")) {
            throw new NiuRuntimeException("13", "cashNo\u4e3a\u7a7a");
        }
        NiuxCash niuxCash = this.queryAndLock(cash.getCashNo());
        if (niuxCash == null) {
            throw new NiuRuntimeException("1070", "\u725bX\u4ee3\u91d1\u5238\u4e0d\u5b58\u5728\u6216\u8005\u5931\u6548");
        }
        if ("2".equals(niuxCash.getCashStatus())) {
            throw new NiuRuntimeException("1073", "\u5df2\u4f7f\u7528");
        }
        if (!"1".equals(niuxCash.getCashStatus())) {
            throw new NiuRuntimeException("1074", "\u672a\u51bb\u7ed3");
        }
        niuxCash.setCashStatus("2");
        this.baseDao.updateById((Object)niuxCash);
        NiuxCashWarnStat warnStat = this.queryAndLockCashWarnStat();
        warnStat.setMoney(warnStat.getMoney() + niuxCash.getParValue());
        this.baseDao.updateById((Object)warnStat);
    }

    @Override
    public void updateUseCash(NiuxCash cash) {
        if ("1".equals(cash.getCashStatus())) {
            this.updateFreezeCash(cash);
            return;
        }
        if ("2".equals(cash.getCashStatus())) {
            this.updateAffirmUseCash(cash);
            return;
        }
        throw new NiuRuntimeException("99", "\u975e\u6cd5\u4f7f\u7528\u72b6\u6001");
    }

    private void updateFreezeCash(NiuxCash cash) {
        if (cash.getCashNo() == null || cash.getCashNo().equals("")) {
            throw new NiuRuntimeException("13", "cashNo\u4e3a\u7a7a");
        }
        NiuxCash niuxCash = this.queryAndLock(cash.getCashNo());
        if (niuxCash == null) {
            throw new NiuRuntimeException("1070", "\u725bX\u4ee3\u91d1\u5238\u4e0d\u5b58\u5728\u6216\u8005\u5931\u6548");
        }
        if ("1".equals(niuxCash.getCashStatus())) {
            throw new NiuRuntimeException("1072", "\u5df2\u51bb\u7ed3");
        }
        if ("2".equals(niuxCash.getCashStatus())) {
            throw new NiuRuntimeException("1073", "\u5df2\u4f7f\u7528");
        }
        String tempExpiredDate = yyyy_MM_dd.format(new Date());
        if (tempExpiredDate.compareTo(niuxCash.getExpireDate()) > 0) {
            throw new NiuRuntimeException("1071", "\u5df2\u8fc7\u671f");
        }
        if (niuxCash.getMinPayMoney() > cash.getMinPayMoney()) {
            throw new NiuRuntimeException("1075", "\u672a\u8fbe\u5230\u6700\u4f4e\u4f7f\u7528\u9650\u989d");
        }
        niuxCash.setCashStatus("1");
        niuxCash.setUserId(cash.getUserId());
        niuxCash.setUseTime(yyyy_MM_ddLong.format(new Date()));
        this.baseDao.updateById((Object)niuxCash);
    }

    public NiuxCashWarnStat queryAndLockCashWarnStat() {
        String sql = "select * from niuxcashwarnstat where seqId=1 for update";
        ArrayList paramList = new ArrayList();
        List cashWaranList = this.baseDao.executeQuery(NiuxCashWarnStat.class, sql, paramList);
        return cashWaranList == null || cashWaranList.size() == 0 ? null : (NiuxCashWarnStat)cashWaranList.get(0);
    }

    public NiuxCash queryAndLock(String cashNo) {
        String sql = "select * from niuxcash where cashNo=? for update";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(cashNo);
        List cashList = this.baseDao.executeQuery(NiuxCash.class, sql, paramList);
        return cashList == null || cashList.size() == 0 ? null : (NiuxCash)cashList.get(0);
    }

    @Override
    public void insertBatch(List<NiuxCash> cashList) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into niuxcash(cashNo,expireDate,parValue,cashStatus,useTime,userId,generateNo,minPayMoney,receiveUserId,receiveTime,receiveOrderNo) value ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < cashList.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("(?,?,?,?,?,?,?,?,?,?,?)");
            NiuxCash cash = cashList.get(i);
            paramList.add(cash.getCashNo());
            paramList.add(cash.getExpireDate());
            paramList.add(cash.getParValue());
            paramList.add(cash.getCashStatus());
            paramList.add(cash.getUseTime());
            paramList.add(cash.getUserId());
            paramList.add(cash.getGenerateNo());
            paramList.add(cash.getMinPayMoney());
            paramList.add(cash.getReceiveUserId() == null ? "" : cash.getReceiveUserId());
            paramList.add(cash.getReceiveTime() == null ? "" : cash.getReceiveTime());
            paramList.add(cash.getReceiveOrderNo() == null ? "" : cash.getReceiveOrderNo());
        }
        this.baseDao.execute(sb.toString(), paramList);
    }

    @Override
    public void updateEmailStat() {
        NiuxCashWarnStat niuxCashWarnStat = this.queryAndLockCashWarnStat();
        niuxCashWarnStat.setIsSendWarnEmail(true);
        this.baseDao.updateById((Object)niuxCashWarnStat);
    }

    @Override
    public double findExpireWarnMoney(String userId, int days) {
        long now = System.currentTimeMillis();
        long toexpire = now + 86400000L * (long)days;
        String nowDate = yyyy_MM_dd.format(new Date(now));
        String toexpiredate = yyyy_MM_dd.format(new Date(toexpire));
        String sql = "select sum(parValue) parValue from niuxcash where receiveUserId=? and cashStatus='0' and expireDate>=? and expireDate<=?";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        paramList.add(nowDate);
        paramList.add(toexpiredate);
        Map resultMap = this.baseDao.findForMap(sql, paramList);
        return Double.valueOf(resultMap.get("parValue").toString());
    }

    @Override
    public List<NiuxCashInfoDTO> getNiuxCashInfo(String userid) {
        String sql1 = "SELECT a.*,b.limitedgameid,b.description,c.lotGroupId,oneUserUseCashMaxTimes FROM niuxcash a \n LEFT JOIN niuxcashgeneraterecord b ON a.generateNo=b.generateNo \n LEFT JOIN niuxCashLotGroup c ON b.lotGroupId = c.lotGroupId\n  WHERE a.receiveUserId=? AND CURRENT_DATE()<= a.expireDate\n  ORDER BY a.cashStatus, a.expireDate ";
        String sql2 = "SELECT a.*,b.limitedgameid,b.description,c.lotGroupId,oneUserUseCashMaxTimes FROM niuxcash a \n LEFT JOIN niuxcashgeneraterecord b ON a.generateNo=b.generateNo \n  LEFT JOIN niuxCashLotGroup c ON b.lotGroupId = c.lotGroupId \n  WHERE a.receiveUserId=? AND DATE_SUB(CURRENT_DATE(),INTERVAL 1 MONTH) <= a.expireDate AND a.expireDate < CURRENT_DATE() \n  ORDER BY a.expireDate DESC ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(userid);
        List list1 = this.baseDao.executeQuery(NiuxCashInfoDTO.class, sql1, params);
        List list2 = this.baseDao.executeQuery(NiuxCashInfoDTO.class, sql2, params);
        list1.addAll(list2);
        return list1;
    }

    @Override
    public List<NiuxCashInfoDTO> getNiuxCashInfo(String userid, String gameid) {
        String sql1 = "SELECT a.*,b.limitedgameid,b.description,c.lotGroupId,oneUserUseCashMaxTimes FROM niuxcash a \n LEFT JOIN niuxcashgeneraterecord b ON a.generateNo=b.generateNo \n LEFT JOIN niuxCashLotGroup c ON b.lotGroupId = c.lotGroupId\n  WHERE a.receiveUserId=? AND CURRENT_DATE()<= a.expireDate AND b.limitedgameid=? \n  ORDER BY a.cashStatus, a.expireDate ";
        String sql2 = "SELECT a.*,b.limitedgameid,b.description,c.lotGroupId,oneUserUseCashMaxTimes FROM niuxcash a \n LEFT JOIN niuxcashgeneraterecord b ON a.generateNo=b.generateNo \n  LEFT JOIN niuxCashLotGroup c ON b.lotGroupId = c.lotGroupId \n  WHERE a.receiveUserId=? AND DATE_SUB(CURRENT_DATE(),INTERVAL 1 MONTH) <= a.expireDate AND a.expireDate < CURRENT_DATE() AND b.limitedgameid=? \n  ORDER BY a.expireDate DESC ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(userid);
        params.add(gameid);
        List list1 = this.baseDao.executeQuery(NiuxCashInfoDTO.class, sql1, params);
        List list2 = this.baseDao.executeQuery(NiuxCashInfoDTO.class, sql2, params);
        list1.addAll(list2);
        return list1;
    }
}

