package com.xunlei.niux.data.league.bo;


import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.GenerateCash;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxcashOrderok;
import com.xunlei.niux.data.league.vo.NiuxcashPaydetailok;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by admin on 2017/2/27.
 */
@Service
public class NiuxcashPaydetailokBoImpl implements NiuxcashPaydetailokBo  {

    @Override
    public void doOrderSuccess(NiuxcashPaydetailok paydetailok, GenerateCash generateCash) {
        String orderId = paydetailok.getOrderid();
        if(StringUtils.isNotEmpty(generateCash.getCashNo())){
            paydetailok.setSuccesstime(DatetimeUtil.now());
            paydetailok.setOrderidstatus("S");// 获取现金券成功
            paydetailok.setEdittime(DatetimeUtil.now());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(paydetailok);

            NiuxcashOrderok niuxcashOrderok = new NiuxcashOrderok();
            niuxcashOrderok.setCashNo(generateCash.getCashNo());
            niuxcashOrderok.setOrderid(orderId);
            niuxcashOrderok.setSuccesstime(DatetimeUtil.now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(niuxcashOrderok);
        }else{
            paydetailok.setEdittime(DatetimeUtil.now());
            paydetailok.setPaycode(generateCash.getErrorCode());
            paydetailok.setPaycodeMsg(generateCash.getErrorMessage());
            paydetailok.setSuccesstime("");
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(paydetailok);
        }

    }

    @Override
    public NiuxcashPaydetailok querySum(NiuxcashPaydetailok paydetailok,Page page) {
        NiuxcashPaydetailok result= new NiuxcashPaydetailok();
        List<Object> paramsList = new ArrayList();
        String tableName = DaoUtil.getTableName(paydetailok.getClass());
        String where = DaoUtil.createWhere(paydetailok, paramsList);
        String column = "sum(TotalMoney) as totalmoney,sum(payMondey) as payprice";
        String sql = "select "+column+" from " + tableName + where ;
        Map<String,Object> resultMap = FacadeFactory.INSTANCE.getBaseSo().findForMap(sql,paramsList);
        if(resultMap != null) {
            String price = resultMap.get("totalmoney") == null?"0.0":resultMap.get("totalmoney").toString();
            String payprice = resultMap.get("payprice") == null?"0.0":resultMap.get("payprice").toString();
            result.setTotalmoney(price);
            result.setPayMondey(payprice == null?"0":payprice);
        } else {
            result.setPayMondey("0.0");
            result.setPayMondey("0.0");
        }
        return result;
    }

    @Override
    public List<String> getSuccessUsedCashNoList(String startTime, String endTime) {
        List<Object> paramsList = new ArrayList();
        List<String> cList = new ArrayList<String>();
        String sql =" SELECT c.* FROM niuxcashpaydetailok ok left join niuxcash c on ok.OrderId=c.receiveOrderNo where ok.OrderIdStatus='S' and c.useTime>='"+startTime+"' and c.useTime<='"+endTime+"' and  c.cashStatus=2";
        List<NiuxCash> cashNoList = FacadeFactory.INSTANCE.getBaseSo().executeQuery(NiuxCash.class,sql,paramsList);
        if(cashNoList!=null&&cashNoList.size()>0){
            for(NiuxCash niuxCash :cashNoList){
                cList.add(niuxCash.getCashNo());
            }
        }
        return cList;
    }
}
