package com.xunlei.niux.data.league.bo;


import com.ferret.common.dao.BaseDao;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxcashPaydetail;
import com.xunlei.niux.data.league.vo.NiuxcashPaydetailok;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * Created by admin on 2017/2/27.
 */
@Service
public class NiuxcashPaydetailBoImpl implements NiuxcashPaydetailBo  {
    private static final Object moveLock = new Object();
    public static final String CHARGE_FAIL = "N";// 支付失败
    public static final String CHARGE_SUCCESS = "Y";// 支付成功
    public static final String PAY_SUCCESS = "S";// 充值成功
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
    @Override
    public NiuxcashPaydetailok doMovePaydetailtoOk(String orderId) throws InvocationTargetException, IllegalAccessException {
        // 是否已经存在在成功表
        NiuxcashPaydetailok paydetailok = new  NiuxcashPaydetailok();
        paydetailok.setOrderid(orderId);
        paydetailok = FacadeFactory.INSTANCE.getBaseSo().findObject(paydetailok);
        if (paydetailok != null) {// 已经移动了，直接返回
            return paydetailok;
        }

        synchronized (moveLock) {
            NiuxcashPaydetail paydetail = new NiuxcashPaydetail();
            paydetail.setOrderid(orderId);
            paydetail = FacadeFactory.INSTANCE.getBaseSo().findObject(paydetail);


            NiuxcashPaydetailok newpaydetailok = new NiuxcashPaydetailok();
            BeanUtils.copyProperties(newpaydetailok, paydetail);
            // newpaydetailok.setSuccesstime(DatetimeUtil.now());
            newpaydetailok.setOrderidstatus(CHARGE_SUCCESS);// 支付成功
            newpaydetailok.setChargeSuccessTime(DatetimeUtil.now());// 支付成功时间
            newpaydetailok.setEdittime(DatetimeUtil.now());

            newpaydetailok.setOriginalOrderId(orderId);
            newpaydetailok.setPaycode("");
            newpaydetailok.setPaycodeMsg("");
            FacadeFactory.INSTANCE.getBaseSo().addObject(newpaydetailok);

            paydetailok = newpaydetailok;
            long seqId= paydetail.getSeqid();
            FacadeFactory.INSTANCE.getBaseSo().deleteById(NiuxcashPaydetail.class,seqId);
        }
        return paydetailok;
    }
}
