package com.xunlei.niux.data.league.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.dto.NiuxCashInfoDTO;
import com.xunlei.niux.data.league.vo.NiuxCash;

import java.util.List;

public interface NiuxCashBo {
	void insertBatch(List<NiuxCash> cashList);
	NiuxCash findOne(String cashNo);
	int count(NiuxCash cash);
	List<NiuxCash> finds(NiuxCash cash,Page page);
	void updateUseCash(NiuxCash cash);
	void updateEmailStat();
	void updateUnfreeze(String cashNo,String userId);
	double findExpireWarnMoney(String userId,int days);

    /**
     * 查询该uid持有代金券数据
     * 范围：代金券过期时间一个月以内
     */
    List<NiuxCashInfoDTO> getNiuxCashInfo(String userid);

    /**
     * 查询该uid持有代金券数据
     * 过滤是否金钻，手游，游戏
     *
     */
    List<NiuxCashInfoDTO> getNiuxCashInfo(String userid,String isJinZuan,String isShouYou,String clientType);


    /**
     * 查询该uid持有仅限手游代金券数据
     * 范围：代金券过期时间一个月以内
     */
    List<NiuxCashInfoDTO> getNiuxCashInfoLmitShouyou(String userid);
    /**
     * 查询该uid持有代金券数据
     * 范围：指定游戏id，代金券过期时间一个月以内
     */
    List<NiuxCashInfoDTO> getNiuxCashInfo(String userid, String gameid);
    List<NiuxCashInfoDTO> getJinzuanNiuxCashInfo(String userid,String jinzuanok,Integer pageNo,Integer pageSize);
    int countJinzuanNiuxCashInfo(String userid,String jinzuanok);

    /**
     * 查询某用户当月领取过的代金券总和
     * @param userId
     * @param generateNo
     * @return
     */
    int getCashReceivedTimesCurMonth(String userId, String generateNo);

    /**
     * 批量获取niuxcash的状态
     * @param cashNos
     * @return
     */
    List<NiuxCash> getNiuxCashStatus(String[] cashNos);

    /**
     * 获取用户当前可用的现金券数量
     * @param userId
     * @return
     */
    int countCashCoupon(String userId);

    /**
     * 获取用户当前可用的代金券数量
     * @param userId
     * @return
     */
    int countVoucher(String userId);


    /**
     * 获取用户的现金券
     * @param userid
     * @return
     */
    List<NiuxCashInfoDTO> getNiuxCashCoupon(String userid);


    /**
     * 获取用户的现金券
     * 过滤是否金钻，手游，游戏
     * @param userid
     * @return
     */
    List<NiuxCashInfoDTO> getNiuxCashCoupon(String userid,String isJinZuan,String isShouYou,String clientType);


    /**
     * 获取用户的代金券/现金券
     * 过滤是否金钻，手游，游戏
     * @return
     */
    List<NiuxCashInfoDTO> getUserAllNiuxCash(NiuxCash niuxCash,String clientType);


    /**
     * 获取当前时间现金券使用总额
     * @param startTime
     * @param endTime
     * @return
     */
    double sumUsedCashCoupon(String startTime,String endTime,String userid);
}
