package com.xunlei.niux.data.league.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.vo.LeagueDayStat;
import com.xunlei.niux.data.league.vo.LeagueMonthStat;
import com.xunlei.niux.data.league.vo.LeagueWeekStat;
@Service
public class LeagueStatSoImpl implements LeagueStatSo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public List<LeagueDayStat> finds(LeagueDayStat query, Page page) {
		return baseDao.findByObject(LeagueDayStat.class, query, page);
	}
	public int count(LeagueDayStat query) {
		return baseDao.count(query);
	}

	@Override
	public List<LeagueMonthStat> finds(LeagueMonthStat query, Page page) {
		return baseDao.findByObject(LeagueMonthStat.class, query, page);
	}

	@Override
	public int count(LeagueMonthStat query) {
		return baseDao.count(query);
	}

	@Override
	public List<LeagueWeekStat> finds(LeagueWeekStat query, Page page) {
		return baseDao.findByObject(LeagueWeekStat.class, query, page);
	}

	@Override
	public int count(LeagueWeekStat query) {
		return baseDao.count(query);
	}

}
