package com.xunlei.niux.data.league.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	private static ClassPathXmlApplicationContext context;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			context=new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/league/xml/tomcatjndi.xml","com/xunlei/niux/data/league/xml/applicationContext.xml"});
			INSTANCE=(IFacade)context.getBean("LeagueFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/league/xml/jdbc.xml","com/xunlei/niux/data/league/xml/applicationContext.xml"}).getBean("LeagueFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/league/xml/springjndi.xml","com/xunlei/niux/data/league/xml/applicationContext.xml"}).getBean("LeagueFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_league_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
