package com.xunlei.niux.data.league.bo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.vo.PromoterProfitRate;
@Service
public class PromoterProfitSoImpl implements PromoterProfitSo{
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	public List<PromoterProfitRate> finds(PromoterProfitRate query,Page page){
		return baseDao.findByObject(PromoterProfitRate.class, query, page);
	}
	/**
	 * 添加
	 * @param list
	 */
	public void add(List<PromoterProfitRate> list){
		checkPromoterProfitRateValid(list);
		PromoterProfitRate p1=list.get(0);
		PromoterProfitRate query=new PromoterProfitRate();
		query.setPromoterAccount(p1.getPromoterAccount());
		query.setRateType(p1.getRateType());
		List<PromoterProfitRate> oldList=finds(query, new Page());
		if(oldList!=null){
			delete(oldList);
		}
		for(PromoterProfitRate ppr:list){
			baseDao.insert(ppr);
		}
	}
	
	public void delete(List<PromoterProfitRate> list){
		for(PromoterProfitRate ppr:list){
			delete(ppr.getSeqId());
		}
	}
	public void delete(long seqId){
		baseDao.deleteById(PromoterProfitRate.class, seqId);
	}
	/**
	 * 验证比率是否合法
	 * @param list
	 */
	private void checkPromoterProfitRateValid(List<PromoterProfitRate> list){
		PromoterProfitRate p1=list.get(0);
		if(p1.getPromoterAccount()==null||p1.getPromoterAccount().equals("")){
			throw new RuntimeException("推广员账号为空");
		}
		if(p1.getRateType()==null||"".equals(p1.getRateType())){
			throw new RuntimeException("推广员账号");
		}
		boolean isIncrementArea=p1.getIsIncrementArea();
		Set<Integer> max_set=new HashSet<Integer>();
		Map<Integer,Integer> min_max_map=new HashMap<Integer,Integer>();
		for(PromoterProfitRate ppr:list){
			if(ppr.getMaxMoney()!=null&&ppr.getMaxMoney().intValue()<=ppr.getMinMoney()){
				throw new RuntimeException("存在起始金额大于等于结束金额的区间");
			}
			if(isIncrementArea!=ppr.getIsIncrementArea()){
				throw new RuntimeException("存在多种区间情况");
			}
			if(!p1.getPromoterAccount().equals(ppr.getPromoterAccount())){
				throw new RuntimeException("一次定义多个推广员");
			}
			if(ppr.getRate()>=1){
				throw new RuntimeException("非法比率");
			}
			min_max_map.put(ppr.getMinMoney(), ppr.getMaxMoney());
			max_set.add(ppr.getMaxMoney());
		}
		if(!min_max_map.containsKey(0)){
			throw new RuntimeException("未设置起始金额为0的区间");
		}
		if(!max_set.contains(null)){
			//没有设置无穷大
			throw new RuntimeException("未设置结束金额为无穷大的区间");
		}
		if(max_set.size()!=list.size()){
			throw new RuntimeException("存在结束金额相同的区间");
		}
		if(isIncrementArea==false){
			if(min_max_map.size()>1){
				throw new RuntimeException("存在起始金额不为0的区间");
			}
			return;
		}
		if(min_max_map.size()<max_set.size()){
			throw new RuntimeException("存在起始金额重复的区间");
		}
		
		Set<Integer> keySet=min_max_map.keySet();
		Iterator<Integer> it=keySet.iterator();
		while(it.hasNext()){
			Integer minKey=it.next();
			Integer max=min_max_map.get(minKey);
			if(max==null){
				break;
			}
			if(!min_max_map.containsKey(max)){
				throw new RuntimeException("区间设置不连贯");
			}
		}
	}
	public static void main(String[] args){
		List<PromoterProfitRate> list=new ArrayList<PromoterProfitRate>();
		PromoterProfitRate pp1=new PromoterProfitRate();
		pp1.setIsIncrementArea(true);
		pp1.setMinMoney(0);
		pp1.setMaxMoney(100);
		list.add(pp1);
		PromoterProfitRate pp2=new PromoterProfitRate();
		pp2.setIsIncrementArea(true);
		pp2.setMinMoney(100);
		pp2.setMaxMoney(10000);
		list.add(pp2);
		PromoterProfitRate pp3=new PromoterProfitRate();
		pp3.setIsIncrementArea(true);
		pp3.setMinMoney(10000);
		pp3.setMaxMoney(100000);
		list.add(pp3);
		PromoterProfitSoImpl t=new PromoterProfitSoImpl();
		t.checkPromoterProfitRateValid(list);
	}
}
