package com.xunlei.niux.data.league.bo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxCashWarnStat;

@Service
public class NiuxCashBoImpl implements NiuxCashBo {
	private static SimpleDateFormat yyyy_MM_dd =new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat yyyy_MM_ddLong =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public List<NiuxCash> finds(NiuxCash cash,Page page){
		return baseDao.findByObject(NiuxCash.class, cash, page);
	}
	public int count(NiuxCash cash){
		return baseDao.count(cash);
	}
	public NiuxCash findOne(String cashNo){
		if(cashNo==null||"".equals(cashNo)){
			return null;
		}
		return baseDao.findById(NiuxCash.class, cashNo);
	}
	public void updateUnfreeze(String cashNo,String userId){
		if(cashNo==null||"".equals(cashNo)){
			throw new RuntimeException("cashNo为空");
		}
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		NiuxCash niuxCash=queryAndLock(cashNo);
		if(niuxCash==null){
			throw new RuntimeException("cashNo["+cashNo+"]不存在");
		}
		//判断是否可用
		if(!"1".equals(niuxCash.getCashStatus())){
			throw new NiuRuntimeException("1074", "cashNo["+cashNo+"]未冻结");
		}
		if(niuxCash.getUserId()==null){
			throw new RuntimeException("cashNo["+cashNo+"]不是userId["+userId+"]使用");
		}
		if(!userId.equals(niuxCash.getUserId())){
			throw new RuntimeException("cashNo["+cashNo+"]不是userId["+userId+"]使用");
		}
		niuxCash.setCashStatus("0");
		niuxCash.setUserId("");
		niuxCash.setUseTime("");
		baseDao.updateById(niuxCash);
	}
	/**
	 * 使用代金券
	 * @param cash
	 */
	private void updateAffirmUseCash(NiuxCash cash){
		if(cash.getCashNo()==null||cash.getCashNo().equals("")){
			throw new NiuRuntimeException("13", "cashNo为空");
		}
		NiuxCash niuxCash=queryAndLock(cash.getCashNo());
		if(niuxCash==null){
			throw new NiuRuntimeException("1070", "牛X代金券不存在或者失效");
		}
		if("2".equals(niuxCash.getCashStatus())){
			throw new NiuRuntimeException("1073", "已使用");
		}
		//判断是否可用
		if(!"1".equals(niuxCash.getCashStatus())){
			throw new NiuRuntimeException("1074", "未冻结");
		}
		
		niuxCash.setCashStatus("2");
		baseDao.updateById(niuxCash);
		//增加统计功能
		NiuxCashWarnStat warnStat=queryAndLockCashWarnStat();
		warnStat.setMoney(warnStat.getMoney()+niuxCash.getParValue());
		baseDao.updateById(warnStat);
	}

	public void updateUseCash(NiuxCash cash){
		if("1".equals(cash.getCashStatus())){
			updateFreezeCash(cash);
			return;
		}
		if("2".equals(cash.getCashStatus())){
			updateAffirmUseCash(cash);
			return;
		}
		throw new NiuRuntimeException("99", "非法使用状态");
	}
	/**
	 * 冻结代金券
	 * @param cash
	 */
	private void updateFreezeCash(NiuxCash cash){
		if(cash.getCashNo()==null||cash.getCashNo().equals("")){
			throw new NiuRuntimeException("13", "cashNo为空");
		}
		NiuxCash niuxCash=queryAndLock(cash.getCashNo());
		if(niuxCash==null){
			throw new NiuRuntimeException("1070", "牛X代金券不存在或者失效");
		}
		//判断是否可用
		if("1".equals(niuxCash.getCashStatus())){
			throw new NiuRuntimeException("1072", "已冻结");
		}
		if("2".equals(niuxCash.getCashStatus())){
			throw new NiuRuntimeException("1073", "已使用");
		}
		//判断是否已经过期
		String tempExpiredDate=yyyy_MM_dd.format(new Date());
		if(tempExpiredDate.compareTo(niuxCash.getExpireDate())>0){
			throw new NiuRuntimeException("1071", "已过期");
		}
		if(niuxCash.getMinPayMoney()>cash.getMinPayMoney()){
			throw new NiuRuntimeException("1075", "未达到最低使用限额");
		}
		niuxCash.setCashStatus("1");
		niuxCash.setUserId(cash.getUserId());
		niuxCash.setUseTime(yyyy_MM_ddLong.format(new Date()));
		baseDao.updateById(niuxCash);
	}
	public NiuxCashWarnStat queryAndLockCashWarnStat(){
		String sql="select * from niuxcashwarnstat where seqId=1 for update";
		List<Object> paramList=new ArrayList<Object>();
		List<NiuxCashWarnStat> cashWaranList=baseDao.executeQuery(NiuxCashWarnStat.class, sql, paramList);
		return cashWaranList==null||cashWaranList.size()==0?null:cashWaranList.get(0);
	}
	public NiuxCash queryAndLock(String cashNo){
		String sql="select * from niuxcash where cashNo=? for update";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(cashNo);
		List<NiuxCash> cashList=baseDao.executeQuery(NiuxCash.class, sql, paramList);
		return cashList==null||cashList.size()==0?null:cashList.get(0);
	}
	public void insertBatch(List<NiuxCash> cashList){
		StringBuilder sb=new StringBuilder();
		sb.append("insert into niuxcash(cashNo,expireDate,parValue,cashStatus,useTime,userId,generateNo,minPayMoney,receiveUserId,receiveTime,receiveOrderNo) value ");
		List<Object> paramList=new ArrayList<Object>();
		
		for(int i=0;i<cashList.size();i++){
			if(i>0){
				sb.append(",");
			}
			sb.append("(?,?,?,?,?,?,?,?,?,?,?)");
			NiuxCash cash=cashList.get(i);
			paramList.add(cash.getCashNo());
			paramList.add(cash.getExpireDate());
			paramList.add(cash.getParValue());
			paramList.add(cash.getCashStatus());
			paramList.add(cash.getUseTime());
			paramList.add(cash.getUserId());
			paramList.add(cash.getGenerateNo());
			paramList.add(cash.getMinPayMoney());
			paramList.add(cash.getReceiveUserId()==null?"":cash.getReceiveUserId());
			paramList.add(cash.getReceiveTime()==null?"":cash.getReceiveTime());
			paramList.add(cash.getReceiveOrderNo()==null?"":cash.getReceiveOrderNo());
		}
		baseDao.execute(sb.toString(), paramList);
	}
	public void updateEmailStat(){
		NiuxCashWarnStat niuxCashWarnStat=queryAndLockCashWarnStat();
		niuxCashWarnStat.setIsSendWarnEmail(true);
		baseDao.updateById(niuxCashWarnStat);
	}
	public double findExpireWarnMoney(String userId,int days){
		long now=System.currentTimeMillis();
		long toexpire=now+24L*60*60*1000*days;
		String nowDate=yyyy_MM_dd.format(new Date(now));
		String toexpiredate=yyyy_MM_dd.format(new Date(toexpire));
		String sql="select sum(parValue) parValue from niuxcash where receiveUserId=? and cashStatus='0' and expireDate>=? and expireDate<=?";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		paramList.add(nowDate);
		paramList.add(toexpiredate);
		Map<String,Object> resultMap=baseDao.findForMap(sql, paramList);
		return Double.valueOf(resultMap.get("parValue").toString());
	}
}
