/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.league.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.signature.SignMd5;
import com.xunlei.niux.data.league.bo.NiuxCashBo;
import com.xunlei.niux.data.league.bo.NiuxCashGenerateRecordBo;
import com.xunlei.niux.data.league.bo.PromoterBo;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.CashNoRule;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxCashGenerateRecord;
import com.xunlei.niux.data.league.vo.NiuxCashHandout;
import com.xunlei.niux.data.league.vo.Promoter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NiuxCashGenerateRecordBoImpl
implements NiuxCashGenerateRecordBo {
    static String[] digitletters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static SimpleDateFormat yyMMddHHmmss = new SimpleDateFormat("yyMMddHHmmss");
    private static SimpleDateFormat yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat yyyy_MM_dd_HHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private PromoterBo promoterBo;
    @Autowired
    private NiuxCashBo niuxCashBo;
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public NiuxCashBo getNiuxCashBo() {
        return this.niuxCashBo;
    }

    public void setNiuxCashBo(NiuxCashBo niuxCashBo) {
        this.niuxCashBo = niuxCashBo;
    }

    public PromoterBo getPromoterBo() {
        return this.promoterBo;
    }

    public void setPromoterBo(PromoterBo promoterBo) {
        this.promoterBo = promoterBo;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<NiuxCashGenerateRecord> finds(NiuxCashGenerateRecord record, Page page) {
        return this.baseDao.findByObject(NiuxCashGenerateRecord.class, (Object)record, page);
    }

    @Override
    public int count(NiuxCashGenerateRecord record) {
        return this.baseDao.count((Object)record);
    }

    @Override
    public void insert(NiuxCashGenerateRecord record) {
        Promoter promoter = this.promoterBo.findOne(record.getPromoterAccount());
        if (promoter == null) {
            throw new RuntimeException("\u63a8\u5e7f\u8d26\u53f7[" + record.getPromoterAccount() + "]\u4e0d\u5b58\u5728");
        }
        record.setGenerateNo(this.buildGenerateNo());
        record.setGenerateTime(yyyy_MM_dd_HHmmss.format(new Date()));
        if (record.getIsDynamicGenerate().booleanValue()) {
            record.setGenerateNum(0);
        } else {
            record.setGenerateNum(record.getGenerateSum());
        }
        this.baseDao.insert((Object)record);
        this.generateCashs(record);
    }

    private String buildGenerateNo() {
        return yyMMddHHmmss.format(new Date());
    }

    private void generateCashs(NiuxCashGenerateRecord record) {
        ArrayList<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
        CashNoRule rule = this.getAndLockCashNoRule(record.getCashNoLength());
        for (int i = 0; i < record.getGenerateNum(); ++i) {
            niuxCashList.add(this.generateCash(record, rule));
        }
        if (niuxCashList.size() > 0) {
            this.niuxCashBo.insertBatch(niuxCashList);
        }
        this.baseDao.updateById((Object)rule);
    }

    private NiuxCash generateCash(NiuxCashGenerateRecord record, CashNoRule rule) {
        NiuxCash niuxCash = new NiuxCash();
        niuxCash.setCashNo(this.getCashNo(rule));
        niuxCash.setCashStatus("0");
        niuxCash.setExpireDate(this.getCashExpireDate(record));
        niuxCash.setParValue(record.getParValue());
        niuxCash.setUserId("");
        niuxCash.setUseTime("");
        niuxCash.setGenerateNo(record.getGenerateNo());
        niuxCash.setMinPayMoney(record.getMinPayMoney());
        niuxCash.setLimitedgameid(record.getLimitedgameid());
        niuxCash.setLimitedJinzuan(record.getLimitedJinzuan());
        niuxCash.setLimitedShouyou(record.getLimitedShouyou());
        return niuxCash;
    }

    private CashNoRule getAndLockCashNoRule(int len) {
        StringBuilder sb = new StringBuilder("select * from cashnorule where cashNoLength=?");
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        paramList.add(len);
        List ruleList = this.baseDao.executeQuery(CashNoRule.class, sb.toString(), paramList);
        return ruleList == null || ruleList.size() == 0 ? null : (CashNoRule)ruleList.get(0);
    }

    @Override
    public NiuxCashGenerateRecord findOneByGenerateNo(String generateNo) {
        if (generateNo == null || "".equals(generateNo)) {
            return null;
        }
        NiuxCashGenerateRecord query = new NiuxCashGenerateRecord();
        query.setGenerateNo(generateNo);
        List<NiuxCashGenerateRecord> list = this.finds(query, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public String getCashNo(CashNoRule cashNoRule) {
        long nextNum;
        long l = nextNum = cashNoRule.getCurNum() < 0L ? 0L : cashNoRule.getCurNum() + (long)cashNoRule.getStepNum().intValue();
        if (nextNum > cashNoRule.getMaxNum() && (nextNum = nextNum % (long)cashNoRule.getStepNum().intValue() + 1L) == (long)cashNoRule.getStepNum().intValue()) {
            throw new RuntimeException(cashNoRule.getMaxNum() + "\u5df2\u7ecf\u7528\u5b8c");
        }
        String code = "";
        long tempNum = nextNum;
        while (tempNum / (long)digitletters.length > 0L) {
            code = digitletters[(int)(tempNum % (long)digitletters.length)] + code;
            tempNum /= (long)digitletters.length;
        }
        code = digitletters[(int)(tempNum % (long)digitletters.length)] + code;
        cashNoRule.setCurNum(nextNum);
        if (code.length() > cashNoRule.getCashNoLength() - cashNoRule.getVerificationCodeLength()) {
            throw new RuntimeException("\u8d85\u8fc7\u751f\u6210\u7684\u957f\u5ea6");
        }
        code = "0000000000".substring(0, cashNoRule.getCashNoLength() - cashNoRule.getVerificationCodeLength() - code.length()) + code;
        String signCode = SignMd5.tomd5((String)(code + "wnfwefsdbk")).substring(0, cashNoRule.getVerificationCodeLength()).toUpperCase();
        signCode = signCode.replaceAll("L", "1");
        signCode = signCode.replaceAll("O", "0");
        code = code + signCode;
        return code;
    }

    @Override
    public NiuxCash addOneCash(String receiveUserId, String generateNo, String orderId) {
        NiuxCashGenerateRecord genRecord = this.findOneByGenerateNo(generateNo);
        if (genRecord.getGenerateSum() <= genRecord.getGenerateNum()) {
            throw new RuntimeException("\u725bX\u4ee3\u91d1\u5238\u6279\u53f7\uff1a" + generateNo + "\u5df2\u8fbe\u5230\u6700\u5927\u751f\u6210\u6570\u91cf");
        }
        if (!genRecord.getIsValid().booleanValue()) {
            throw new RuntimeException("\u725bX\u4ee3\u91d1\u5238\u6279\u53f7\uff1a" + generateNo + "\u63a5\u53e3\u751f\u6210\u5df2\u5173\u95ed");
        }
        CashNoRule rule = this.getAndLockCashNoRule(genRecord.getCashNoLength());
        NiuxCash niuxCash = this.generateCash(genRecord, rule);
        niuxCash.setReceiveUserId(receiveUserId);
        niuxCash.setReceiveTime(yyyy_MM_dd_HHmmss.format(new Date()));
        niuxCash.setReceiveOrderNo(orderId);
        ArrayList<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
        niuxCashList.add(niuxCash);
        this.niuxCashBo.insertBatch(niuxCashList);
        try {
            this.baseDao.updateById((Object)rule);
            genRecord.setGenerateNum(genRecord.getGenerateNum() + 1);
            this.baseDao.updateById((Object)genRecord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return niuxCash;
    }

    @Override
    public NiuxCash addOneCash(String receiveUserId, String generateNo, String orderId, String gameid) {
        NiuxCashGenerateRecord genRecord = this.findOneByGenerateNo(generateNo);
        if (genRecord.getGenerateSum() != 0 && genRecord.getGenerateSum() <= genRecord.getGenerateNum()) {
            throw new RuntimeException("\u725bX\u4ee3\u91d1\u5238\u6279\u53f7\uff1a" + generateNo + "\u5df2\u8fbe\u5230\u6700\u5927\u751f\u6210\u6570\u91cf");
        }
        if (!genRecord.getIsValid().booleanValue()) {
            throw new RuntimeException("\u725bX\u4ee3\u91d1\u5238\u6279\u53f7\uff1a" + generateNo + "\u63a5\u53e3\u751f\u6210\u5df2\u5173\u95ed");
        }
        CashNoRule rule = this.getAndLockCashNoRule(genRecord.getCashNoLength());
        NiuxCash niuxCash = new NiuxCash();
        niuxCash.setCashNo(this.getCashNo(rule));
        niuxCash.setCashStatus("0");
        niuxCash.setExpireDate(this.getCashExpireDate(genRecord));
        niuxCash.setParValue(genRecord.getParValue());
        niuxCash.setUserId("");
        niuxCash.setUseTime("");
        niuxCash.setGenerateNo(genRecord.getGenerateNo());
        niuxCash.setMinPayMoney(genRecord.getMinPayMoney());
        niuxCash.setLimitedgameid(gameid);
        niuxCash.setReceiveUserId(receiveUserId);
        niuxCash.setReceiveTime(yyyy_MM_dd_HHmmss.format(new Date()));
        niuxCash.setReceiveOrderNo(orderId);
        ArrayList<NiuxCash> niuxCashList = new ArrayList<NiuxCash>();
        niuxCashList.add(niuxCash);
        this.niuxCashBo.insertBatch(niuxCashList);
        try {
            this.baseDao.updateById((Object)rule);
            genRecord.setGenerateNum(genRecord.getGenerateNum() + 1);
            this.baseDao.updateById((Object)genRecord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return niuxCash;
    }

    private String getCashExpireDate(NiuxCashGenerateRecord genRecord) {
        if ("fix".equals(genRecord.getExpireType())) {
            return genRecord.getExpireDate();
        }
        long now = System.currentTimeMillis();
        long expirelong = now + 86400000L * (long)genRecord.getExpireDays().intValue();
        Date expireDate = new Date(expirelong);
        return yyyy_MM_dd.format(expireDate);
    }

    @Override
    public boolean checkReceiver(String receiveUserId, String generateNo) {
        NiuxCash query = new NiuxCash();
        query.setReceiveUserId(receiveUserId);
        query.setGenerateNo(generateNo);
        NiuxCash cash = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return cash != null;
    }

    @Override
    public void handoutNiuxCash(String[] uids, String[] generateNos, String handoutBy, String reason) {
        Long handoutid = System.currentTimeMillis();
        String now = yyyy_MM_dd_HHmmss.format(new Date());
        for (String gen : generateNos) {
            for (String uid : uids) {
                NiuxCash niuxCash = this.addOneCash(uid, gen, "HANG" + System.currentTimeMillis());
                NiuxCashHandout ncHand = new NiuxCashHandout();
                ncHand.setHandoutid(handoutid);
                ncHand.setUserid(uid);
                ncHand.setGenerateNo(gen);
                ncHand.setCashNo(niuxCash.getCashNo());
                ncHand.setParValue(niuxCash.getParValue());
                ncHand.setHandoutTime(now);
                ncHand.setHandoutBy(handoutBy);
                ncHand.setReason(reason);
                this.baseDao.insert((Object)ncHand);
            }
        }
    }
}

