package com.xunlei.niux.data.league.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.vo.Promoter;

@Service
public class PromoterBoImpl implements PromoterBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public List<Promoter> findPromoter(Promoter promoter,Page page){
		return baseDao.findByObject(Promoter.class, promoter, page);
	}
	public int count(Promoter promoter){
		return baseDao.count(promoter);
	}
	public void update(Promoter promoter){
		 baseDao.updateById(promoter);
	}
	public void insert(Promoter promoter) {
		baseDao.insert(promoter);
	}
	public void delete(Long seqId) {
		baseDao.deleteById(Promoter.class, seqId);
	}
	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);
	}
	public Promoter findOne(String promoterAccount){
		if(promoterAccount==null||"".equals(promoterAccount)){
			throw new RuntimeException("推广员查询推广账号为空");
		}
		Promoter promoter=new Promoter();
		promoter.setPromoterAccount(promoterAccount);
		List<Promoter> promoterList=findPromoter(promoter, new Page());
		return promoterList==null||promoterList.size()==0?null:promoterList.get(0);
	}
}
