package com.xunlei.niux.data.jinzuan.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.xunlei.common.util.StringTools;

public class DateUtil {


	public static String getOrderTime(){
		SimpleDateFormat OrderDaysdf = new SimpleDateFormat("yyyyMMddHHmmss");
		return OrderDaysdf.format(new Date());
	}
	
	/**
	 * 获得当前日期
	 * @return
	 * @throws ParseException
	 */
	public static String getNowDay()
			throws ParseException {
		SimpleDateFormat Daysdf = new SimpleDateFormat(
				"yyyy-MM-dd");	
		Calendar cal = Calendar.getInstance();		
		return Daysdf.format(cal.getTime());
	}
	
	public static String getNowTime() throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar cal = Calendar.getInstance();		
		return sdf.format(cal.getTime());
	}
	
	/**
	 * 获得当前日期之前或之后numValue天的日期
	 * @param daytime
	 * @param numValue
	 * @param flag
	 * @return
	 * @throws ParseException
	 */
	public static String getNewDay(String daytime, int numValue,boolean flag)
			throws ParseException {
		SimpleDateFormat Daysdf = new SimpleDateFormat(
				"yyyy-MM-dd");	
		Date date = Daysdf.parse(daytime);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_YEAR, flag?numValue:-numValue);
		return Daysdf.format(cal.getTime());
	}
	
	/**
	 * 获得beginTime和endTime之间覆盖的天数
	 * @param beginTime
	 * @param endTime
	 * @param Daysdf
	 * @return 天数
	 * @throws ParseException
	 */
	public static int getSpanDay(String beginTime,String endTime, SimpleDateFormat Daysdf)
			throws ParseException {
		Date beginTimedate = Daysdf.parse(beginTime);
		Date endTimedate = Daysdf.parse(endTime);
		Calendar beginTimecal = Calendar.getInstance();
		beginTimecal.setTime(beginTimedate);
		Calendar endTimecal = Calendar.getInstance();
		endTimecal.setTime(endTimedate);
		return endTimecal.compareTo(beginTimecal);
	}
	
	
	public static String getYesterayDay()
			throws ParseException {
		SimpleDateFormat Daysdf = new SimpleDateFormat(
				"yyyy-MM-dd");	
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_YEAR, -1);
		return Daysdf.format(cal.getTime());
	}
	
	/**
	 * 判断time1是否大于等于time2
	 * 
	 * @param time1
	 * @param time2
	 * @return
	 * @throws ParseException
	 */
	public static long compareTime(String time1, String time2) throws Exception {
		SimpleDateFormat myDaysdf = new SimpleDateFormat("yyyy-MM-dd");	
		if (StringTools.isEmpty(time1))
			return -1;
		Date date1 = myDaysdf.parse(time1);
		Date date2 = myDaysdf.parse(time2);
		long data1 = date1.getTime();
		long data2 = date2.getTime();
		return (data1 - data2) / 1000;
	}
}
