package com.xunlei.niux.data.jinzuan.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/jinzuan/xml/tomcatjndi.xml","com/xunlei/niux/data/jinzuan/xml/applicationContext.xml"}).getBean("JinZuanFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/jinzuan/xml/jdbc.xml","com/xunlei/niux/data/jinzuan/xml/applicationContext.xml"}).getBean("JinZuanFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/jinzuan/xml/springjndi.xml","com/xunlei/niux/data/jinzuan/xml/applicationContext.xml"}).getBean("JinZuanFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_jinzuan_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
