package com.xunlei.niux.data.jinzuan.bo;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.common.signature.SignMd5;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.CodeBat;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomerProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeRule;
import com.xunlei.niux.data.jinzuan.vo.CodeUseError;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;

public class CodeCodeBoImpl implements CodeCodeBo{

	static String[] digitletters = new String[] { "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C",
		"D", "E", "F", "G", "H",  "J", "K", "M", "N", "P", "Q", "R", "S", "T",
	    "W", "X", "Y", "Z" };
	static String[] invalidletters = new String[] {"U","V","I","L","O","0","1"};//不好辨认需要屏蔽的字母
	private static final int MAX_CODE_USE_ERROR_COUNT = 30;
	
	private BaseDao baseDao;
	private PayOrderBo payOrderBo;
	private static final Page page =  new Page();
	
	private static Logger logger = LoggerFactory.getLogger(CodeCodeBoImpl.class.getName());
	
	public PayOrderBo getPayOrderBo() {
		return payOrderBo;
	}
	public void setPayOrderBo(PayOrderBo payOrderBo) {
		this.payOrderBo = payOrderBo;
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	/**
	 * 批量生成激活码
	 */
    public void addBatCode(CodeBat bat) throws Exception{  	
    	int codeLen = bat.getCodeLength();
    	CodeRule rule = getCodeRule(codeLen);
    	if(rule == null){
    		throw new XLRuntimeException("长度为:"+codeLen+"的激活码生成规则不存在");
    	}    	
    	CodeCustomerProduct ccp = baseDao.findById(CodeCustomerProduct.class, bat.getCustomerProductId());
    	if(ccp == null){
    		throw new XLRuntimeException("商户商品编号："+bat.getCustomerProductId()+"不存在");
    	}
    	CodeProduct queryproduct = new CodeProduct();
    	queryproduct.setProductId(ccp.getProductId());
    	
    	List<CodeProduct> cplist = baseDao.findByObject(CodeProduct.class, queryproduct, page);
    	if(cplist == null||cplist.size()==0){
    		throw new XLRuntimeException("商品编号："+ccp.getProductId()+"不存在");
    	}    	
    	CodeProduct cp = cplist.get(0);
    	List<CodeCode> cclist = new ArrayList<CodeCode>();    	
    	for(int i=0;i<bat.getAmount();i++){
    		cclist.add(generateCode(bat,cp,rule));
    	}
    	if(cclist.size()>0){
    		insertBatch(cclist);
    	}
    	baseDao.updateById(rule);//更新激活码生成规则中的当前值
    }
    
    private void insertBatch(List<CodeCode> cclist){
    	StringBuffer sb = new StringBuffer("insert into jinzuan_code_code(batId,acode,seqId,expireDay,amount,timeType,createTime,flag,usedTime,userId,isPay) value ");
    	List<Object> paramList=new ArrayList<Object>();
    	for(int i=0;i<cclist.size();i++){
    		if(i>0){
    			sb.append(",");
    		}    		
    		sb.append("(?,?,?,?,?,?,?,?,?,?,?)");
    		CodeCode code = cclist.get(i);
    		paramList.add(code.getBatId());
    		paramList.add(code.getAcode());
    		paramList.add(null);
    		paramList.add(code.getExpireDay());
    		paramList.add(code.getAmount());
    		paramList.add(code.getTimeType());
    		paramList.add(code.getCreateTime());
    		paramList.add(code.getFlag());
    		paramList.add("");
    		paramList.add("");
    		paramList.add(code.getIsPay());
    	}   	
    	baseDao.execute(sb.toString(), paramList);
    }
    
    private CodeCode generateCode(final CodeBat bat,final CodeProduct product,CodeRule rule) throws Exception{
    	CodeCode  code = new CodeCode();
    	code.setAmount(product.getAmount());
    	code.setTimeType(product.getTimeType());
    	code.setBatId(bat.getBatId());
    	code.setIsPay(bat.getIsPay());
    	code.setExpireDay(bat.getExpireDay());
    	code.setCreateTime(DateUtil.getNowTime());
    	code.setFlag(1);
    	code.setAcode(getCode(rule));
    	return code;
    }
    
    /**
     * 生成激活码
     * @param rule
     * @return
     */
    private String getCode(CodeRule rule){
    	long curNum = rule.getCurNum()+rule.getStepNum();
    	String code="";
		long tempNum=curNum;
		while(tempNum/digitletters.length>0){
			code=digitletters[(int)(tempNum%digitletters.length)]+code;
			tempNum=tempNum/digitletters.length;
		}
		code=digitletters[(int)(tempNum%digitletters.length)]+code;
		rule.setCurNum(curNum);
		int randomLen = rule.getCashNoLength()-rule.getVerificationCodeLength()-code.length();//需要生成随机数的位数
		String randomCode = getRandomCode(randomLen);
		code=randomCode+code;		
		String signCode=SignMd5.tomd5(code+"wewetjsdf@sd*sdf_fdg").substring(0,rule.getVerificationCodeLength()).toUpperCase();
//		signCode=signCode.replaceAll("L", "1");
//		signCode=signCode.replaceAll("O", "0");
		signCode = codeFilter(codeFilter(signCode));
		code=code+signCode;
		return code;
    }
    
    /**
     *  过滤识别码中需要屏蔽的字母
     * @param signCode
     * @return
     */
    private String codeFilter(String signCode){
    	  boolean flag = false;
    	  for(String fcode:invalidletters){
    		  if(signCode.indexOf(fcode)!=-1){
    			  signCode.replace(fcode, getRandomCode(1));
    			  flag = true;
    		  }
    	  }
    	  if(!flag)return signCode;      	
    	return signCode;    	
    }
    
    
    
    /**
     * 获得随机码
     * @param randomLen
     * @return
     */
    private String  getRandomCode(int randomLen){
    	Random rand = new Random();        
    	String code = "";
    	for(int i=0;i<randomLen;i++){
    		int index = rand.nextInt(28);
    		code+=digitletters[index];
    	}
    	return code;
    }
    
    /**
     * 获得激活码生成规则
     * @param codeLen
     * @return
     * @throws Exception
     */
    private CodeRule getCodeRule(int codeLen) throws Exception{
    	CodeRule query = new CodeRule();
    	query.setCashNoLength(codeLen);
    	List<CodeRule> crlist = baseDao.findByObject(CodeRule.class, query, page);
    	return crlist==null||crlist.size()==0? null:crlist.get(0);
    }
    
    
	
	/**
	 * 查询激活码接口
	 */
	@Override
	public CodeCode queryCodeCode(String acode) {
		String querysql = "select * from jinzuan_code_code where acode=?";
		List<Object> params = new ArrayList<Object>();
		params.add(acode);
		List<CodeCode> list = baseDao.findBySql(CodeCode.class, querysql,params);
		if(list == null||list.size()==0)return null;		
		return list.get(0);
	}

	
	private void addCodeErrorRecord(List<CodeUseError> cuelist,long userid,String acode) throws Exception{
		try{
			if(cuelist == null||cuelist.size()==0){
				CodeUseError cue = new CodeUseError();
				cue.setUserId(userid);
				cue.setDaytime(DateUtil.getNowDay());
				cue.setErrorCount(1);
				cue.setLastErrorCode(acode);
				baseDao.insert(cue);
			}else{
				CodeUseError cue = cuelist.get(0);
				if(cue.getErrorCount().intValue()>=MAX_CODE_USE_ERROR_COUNT){
					throw new XLRuntimeException("您输入激活码错误的次数达到今日上限，请明天再试");
				}
				cue.setErrorCount(cue.getErrorCount()+1);
				cue.setLastErrorCode(acode);
				baseDao.updateById(cue);
			}
		}catch(Exception e){
			logger.error("addCodeErrorRecord error! userid={} Exception: ", userid, e);
		}
		
	}
	
	/**
	 * 使用激活码接口
	 */
	@Override
	public void use(String acode,String orderid,String account,long userid,String ip,String bizNo) throws XLRuntimeException,Exception {		
		CodeUseError query = new CodeUseError();
		query.setUserId(userid);
		query.setDaytime(DateUtil.getNowDay());
		List<CodeUseError> cuelist = baseDao.findByObject(CodeUseError.class, query, page);
		if(cuelist!=null&&cuelist.size()>0){
			CodeUseError cue = cuelist.get(0);
			if(cue.getErrorCount().intValue() >= MAX_CODE_USE_ERROR_COUNT){
				throw new XLRuntimeException("您输入激活码错误的次数达到今日上限，请明天再试");
			}
		}
		
		String querysql = "select * from jinzuan_code_code where acode=?";
		List<Object> params = new ArrayList<Object>();
		params.add(acode);
		List<CodeCode> list = baseDao.findBySql(CodeCode.class, querysql,params);
		if(list == null||list.size()==0){
			addCodeErrorRecord(cuelist,userid,acode);
			throw new XLRuntimeException("该激活码不存在");
		}
		CodeCode code = list.get(0);
		int flag = code.getFlag().intValue();
		if(flag==2){
			throw new XLRuntimeException("该激活码已经使用");
		}else if(flag ==3){
			throw new XLRuntimeException("该激活码已经被冻结");
		}
		String nowDay = DateUtil.getNowDay();
		String expireDay = code.getExpireDay();
		if(DateUtil.compareTime(nowDay, expireDay)>0){
			throw new XLRuntimeException("该激活码已经过期");
		}
		code.setUserId(userid+"");
		code.setUsedTime(DateUtil.getNowTime());
		code.setFlag(2);
		baseDao.updateById(code);//更新激活码使用状态
		
		//修改会员状态
		 PayOrder porder = savePayOrder(code,orderid,account,userid,ip,bizNo);
		//更新会员状态
		 payOrderBo.addPayOrder(porder, false,false);
		 
	}

	/**
	 * 保存支付订单
	 * @param code
	 * @param orderid
	 * @param account
	 * @param userid
	 * @param bizNo
	 * @throws ParseException
	 */
	private PayOrder savePayOrder(CodeCode code,String orderid,String account,long userid,String ip,String bizNo) throws ParseException{
		  PayOrder porder = new PayOrder();
		  porder.setBankNo("");
          porder.setBizNo(bizNo);  
          porder.setChargeType("CC");
          porder.setPayBizNo("0");            
          if(code.getIsPay()){//如果是支付
        	  porder.setOrderType(new Integer(1));//充值
          }else{
        	  porder.setOrderType(new Integer(2));//赠送
          }
          porder.setMemberStatus(1);//正式会员
          porder.setAcode(code.getAcode());//保存使用的激活码
          porder.setTimeType(code.getTimeType());
          porder.setNumValue(code.getAmount());
          porder.setPayMoney(new Double(0));
          porder.setOrderMoney(new Double(0));
		  porder.setUserId(Long.parseLong(code.getUserId()));
		  porder.setNoticeActivity(false);//是否通知活动订单
		  porder.setUserName(account);			  	
		  porder.setOrderId(orderid);//订单号
		  porder.setIp(ip);
		  String nowtime = DateUtil.getNowTime();
		  porder.setOrderTime(nowtime);//订单时间
		  porder.setFinishTime(nowtime);
		  porder.setOrderStatus(new Integer(3));//订单生成成功 
		  baseDao.insert(porder);
		  return porder;
	}
	
	public void freeze(String acode,int type) throws XLRuntimeException,Exception{
		String sql = "select * from jinzuan_code_code where acode=?  for update";
		List<Object> params = new ArrayList<Object>();
		params.add(acode);
		List<CodeCode> cclist = baseDao.findBySql(CodeCode.class, sql,params);
		if(cclist == null||cclist.size()==0){
			throw new XLRuntimeException("激活码不存在");
		}
		CodeCode code = cclist.get(0);
		int status = code.getFlag().intValue();		
		if(type == 1){//如果是冻结操作
			if(status != 1){//如果已经使用 或 冻结 
				throw new XLRuntimeException("该激活码已经使用或冻结");
			}
			code.setFlag(3);
		}else if(type == 2){//如果是解冻操作
			if(status == 1){//如果已经已经解冻
				throw new XLRuntimeException("该激活码未冻结");
			}else if(status == 2){
				throw new XLRuntimeException("该激活码已经使用");
			}
			code.setFlag(1);
		}
		
		baseDao.updateById(code);
	}
}
