/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuan.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.common.signature.SignMd5;
import com.xunlei.niux.data.jinzuan.bo.CodeCodeBo;
import com.xunlei.niux.data.jinzuan.bo.PayOrderBo;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.CodeBat;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomerProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeRule;
import com.xunlei.niux.data.jinzuan.vo.CodeUseError;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCodeBoImpl
implements CodeCodeBo {
    static String[] digitletters = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "W", "X", "Y", "Z"};
    static String[] invalidletters = new String[]{"U", "V", "I", "L", "O", "0", "1"};
    private static final int MAX_CODE_USE_ERROR_COUNT = 30;
    private BaseDao baseDao;
    private PayOrderBo payOrderBo;
    private static final Page page = new Page();
    private static Logger logger = LoggerFactory.getLogger((String)CodeCodeBoImpl.class.getName());

    public PayOrderBo getPayOrderBo() {
        return this.payOrderBo;
    }

    public void setPayOrderBo(PayOrderBo payOrderBo) {
        this.payOrderBo = payOrderBo;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void addBatCode(CodeBat bat) throws Exception {
        int codeLen = bat.getCodeLength();
        CodeRule rule = this.getCodeRule(codeLen);
        if (rule == null) {
            throw new XLRuntimeException("\u957f\u5ea6\u4e3a:" + codeLen + "\u7684\u6fc0\u6d3b\u7801\u751f\u6210\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        CodeCustomerProduct ccp = (CodeCustomerProduct)this.baseDao.findById(CodeCustomerProduct.class, bat.getCustomerProductId());
        if (ccp == null) {
            throw new XLRuntimeException("\u5546\u6237\u5546\u54c1\u7f16\u53f7\uff1a" + bat.getCustomerProductId() + "\u4e0d\u5b58\u5728");
        }
        CodeProduct queryproduct = new CodeProduct();
        queryproduct.setProductId(ccp.getProductId());
        List cplist = this.baseDao.findByObject(CodeProduct.class, (Object)queryproduct, page);
        if (cplist == null || cplist.size() == 0) {
            throw new XLRuntimeException("\u5546\u54c1\u7f16\u53f7\uff1a" + ccp.getProductId() + "\u4e0d\u5b58\u5728");
        }
        CodeProduct cp = (CodeProduct)cplist.get(0);
        ArrayList<CodeCode> cclist = new ArrayList<CodeCode>();
        int i = 0;
        while ((long)i < bat.getAmount()) {
            cclist.add(this.generateCode(bat, cp, rule));
            ++i;
        }
        if (cclist.size() > 0) {
            this.insertBatch(cclist);
        }
        this.baseDao.updateById((Object)rule);
    }

    private void insertBatch(List<CodeCode> cclist) {
        StringBuffer sb = new StringBuffer("insert into jinzuan_code_code(batId,acode,seqId,expireDay,amount,timeType,createTime,flag,usedTime,userId,isPay) value ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < cclist.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("(?,?,?,?,?,?,?,?,?,?,?)");
            CodeCode code = cclist.get(i);
            paramList.add(code.getBatId());
            paramList.add(code.getAcode());
            paramList.add(null);
            paramList.add(code.getExpireDay());
            paramList.add(code.getAmount());
            paramList.add(code.getTimeType());
            paramList.add(code.getCreateTime());
            paramList.add(code.getFlag());
            paramList.add("");
            paramList.add("");
            paramList.add(code.getIsPay());
        }
        this.baseDao.execute(sb.toString(), paramList);
    }

    private CodeCode generateCode(CodeBat bat, CodeProduct product, CodeRule rule) throws Exception {
        CodeCode code = new CodeCode();
        code.setAmount(product.getAmount());
        code.setTimeType(product.getTimeType());
        code.setBatId(bat.getBatId());
        code.setIsPay(bat.getIsPay());
        code.setExpireDay(bat.getExpireDay());
        code.setCreateTime(DateUtil.getNowTime());
        code.setFlag(1);
        code.setAcode(this.getCode(rule));
        return code;
    }

    private String getCode(CodeRule rule) {
        long curNum = rule.getCurNum() + (long)rule.getStepNum().intValue();
        String code = "";
        long tempNum = curNum;
        while (tempNum / (long)digitletters.length > 0L) {
            code = digitletters[(int)(tempNum % (long)digitletters.length)] + code;
            tempNum /= (long)digitletters.length;
        }
        code = digitletters[(int)(tempNum % (long)digitletters.length)] + code;
        rule.setCurNum(curNum);
        int randomLen = rule.getCashNoLength() - rule.getVerificationCodeLength() - code.length();
        String randomCode = this.getRandomCode(randomLen);
        code = randomCode + code;
        String signCode = SignMd5.tomd5((String)(code + "wewetjsdf@sd*sdf_fdg")).substring(0, rule.getVerificationCodeLength()).toUpperCase();
        signCode = this.codeFilter(this.codeFilter(signCode));
        code = code + signCode;
        return code;
    }

    private String codeFilter(String signCode) {
        boolean flag = false;
        for (String fcode : invalidletters) {
            if (signCode.indexOf(fcode) == -1) continue;
            signCode.replace(fcode, this.getRandomCode(1));
            flag = true;
        }
        if (!flag) {
            return signCode;
        }
        return signCode;
    }

    private String getRandomCode(int randomLen) {
        Random rand = new Random();
        String code = "";
        for (int i = 0; i < randomLen; ++i) {
            int index = rand.nextInt(28);
            code = code + digitletters[index];
        }
        return code;
    }

    private CodeRule getCodeRule(int codeLen) throws Exception {
        CodeRule query = new CodeRule();
        query.setCashNoLength(codeLen);
        List crlist = this.baseDao.findByObject(CodeRule.class, (Object)query, page);
        return crlist == null || crlist.size() == 0 ? null : (CodeRule)crlist.get(0);
    }

    @Override
    public CodeCode queryCodeCode(String acode) {
        String querysql = "select * from jinzuan_code_code where acode=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(acode);
        List list = this.baseDao.findBySql(CodeCode.class, querysql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (CodeCode)list.get(0);
    }

    private void addCodeErrorRecord(List<CodeUseError> cuelist, long userid, String acode) throws Exception {
        try {
            if (cuelist == null || cuelist.size() == 0) {
                CodeUseError cue = new CodeUseError();
                cue.setUserId(userid);
                cue.setDaytime(DateUtil.getNowDay());
                cue.setErrorCount(1);
                cue.setLastErrorCode(acode);
                this.baseDao.insert((Object)cue);
            } else {
                CodeUseError cue = cuelist.get(0);
                if (cue.getErrorCount() >= 30) {
                    throw new XLRuntimeException("\u60a8\u8f93\u5165\u6fc0\u6d3b\u7801\u9519\u8bef\u7684\u6b21\u6570\u8fbe\u5230\u4eca\u65e5\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
                }
                cue.setErrorCount(cue.getErrorCount() + 1);
                cue.setLastErrorCode(acode);
                this.baseDao.updateById((Object)cue);
            }
        }
        catch (Exception e) {
            logger.error("addCodeErrorRecord error! userid={} Exception: ", (Object)userid, (Object)e);
        }
    }

    @Override
    public void use(String acode, String orderid, String account, long userid, String ip, String bizNo) throws XLRuntimeException, Exception {
        String expireDay;
        CodeUseError cue;
        CodeUseError query = new CodeUseError();
        query.setUserId(userid);
        query.setDaytime(DateUtil.getNowDay());
        List cuelist = this.baseDao.findByObject(CodeUseError.class, (Object)query, page);
        if (cuelist != null && cuelist.size() > 0 && (cue = (CodeUseError)cuelist.get(0)).getErrorCount() >= 30) {
            throw new XLRuntimeException("\u60a8\u8f93\u5165\u6fc0\u6d3b\u7801\u9519\u8bef\u7684\u6b21\u6570\u8fbe\u5230\u4eca\u65e5\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
        }
        String querysql = "select * from jinzuan_code_code where acode=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(acode);
        List list = this.baseDao.findBySql(CodeCode.class, querysql, params);
        if (list == null || list.size() == 0) {
            this.addCodeErrorRecord(cuelist, userid, acode);
            throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728");
        }
        CodeCode code = (CodeCode)list.get(0);
        int flag = code.getFlag();
        if (flag == 2) {
            throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u5df2\u7ecf\u4f7f\u7528");
        }
        if (flag == 3) {
            throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u5df2\u7ecf\u88ab\u51bb\u7ed3");
        }
        String nowDay = DateUtil.getNowDay();
        if (DateUtil.compareTime(nowDay, expireDay = code.getExpireDay()) > 0L) {
            throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u5df2\u7ecf\u8fc7\u671f");
        }
        code.setUserId(userid + "");
        code.setUsedTime(DateUtil.getNowTime());
        code.setFlag(2);
        this.baseDao.updateById((Object)code);
        PayOrder porder = this.savePayOrder(code, orderid, account, userid, ip, bizNo);
        this.payOrderBo.addPayOrder(porder, false, false);
    }

    private PayOrder savePayOrder(CodeCode code, String orderid, String account, long userid, String ip, String bizNo) throws ParseException {
        PayOrder porder = new PayOrder();
        porder.setBankNo("");
        porder.setBizNo(bizNo);
        porder.setChargeType("CC");
        porder.setPayBizNo("0");
        if (code.getIsPay().booleanValue()) {
            porder.setOrderType(new Integer(1));
        } else {
            porder.setOrderType(new Integer(2));
        }
        porder.setMemberStatus(1);
        porder.setAcode(code.getAcode());
        porder.setTimeType(code.getTimeType());
        porder.setNumValue(code.getAmount());
        porder.setPayMoney(new Double(0.0));
        porder.setOrderMoney(new Double(0.0));
        porder.setUserId(Long.parseLong(code.getUserId()));
        porder.setNoticeActivity(false);
        porder.setUserName(account);
        porder.setOrderId(orderid);
        porder.setIp(ip);
        String nowtime = DateUtil.getNowTime();
        porder.setOrderTime(nowtime);
        porder.setFinishTime(nowtime);
        porder.setOrderStatus(new Integer(3));
        this.baseDao.insert((Object)porder);
        return porder;
    }

    @Override
    public void freeze(String acode, int type) throws XLRuntimeException, Exception {
        String sql = "select * from jinzuan_code_code where acode=?  for update";
        ArrayList<String> params = new ArrayList<String>();
        params.add(acode);
        List cclist = this.baseDao.findBySql(CodeCode.class, sql, params);
        if (cclist == null || cclist.size() == 0) {
            throw new XLRuntimeException("\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728");
        }
        CodeCode code = (CodeCode)cclist.get(0);
        int status = code.getFlag();
        if (type == 1) {
            if (status != 1) {
                throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u5df2\u7ecf\u4f7f\u7528\u6216\u51bb\u7ed3");
            }
            code.setFlag(3);
        } else if (type == 2) {
            if (status == 1) {
                throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u672a\u51bb\u7ed3");
            }
            if (status == 2) {
                throw new XLRuntimeException("\u8be5\u6fc0\u6d3b\u7801\u5df2\u7ecf\u4f7f\u7528");
            }
            code.setFlag(1);
        }
        this.baseDao.updateById((Object)code);
    }
}

