/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuan.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.MemberShipBo;
import com.xunlei.niux.data.jinzuan.dao.MemberShipDao;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.MemberDetail;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import java.util.List;

public class MemberShipBoImpl
implements MemberShipBo {
    private BaseDao baseDao;
    private MemberShipDao memberShipDao;
    private static final Page page = new Page();

    public MemberShipDao getMemberShipDao() {
        return this.memberShipDao;
    }

    public void setMemberShipDao(MemberShipDao memberShipDao) {
        this.memberShipDao = memberShipDao;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void delete(boolean isForce, long userId) throws XLRuntimeException, Exception {
        this.deleteMemberShip(userId);
        this.deleteMemberDetail(isForce, userId);
        this.deletePrivilege(userId);
    }

    @Override
    public void deleteSilently(boolean isForce, long userId) throws Exception {
        try {
            this.deleteMemberShip(userId);
        }
        catch (XLRuntimeException e) {
            // empty catch block
        }
        try {
            this.deleteMemberDetail(isForce, userId);
        }
        catch (XLRuntimeException e) {
            // empty catch block
        }
        try {
            this.deletePrivilege(userId);
        }
        catch (XLRuntimeException e) {
            // empty catch block
        }
    }

    private void deleteMemberShip(long userId) throws XLRuntimeException, Exception {
        MemberShip query = new MemberShip();
        query.setUserId(userId);
        List shiplist = this.baseDao.findByObject(MemberShip.class, (Object)query, page);
        if (shiplist == null || shiplist.size() == 0) {
            throw new XLRuntimeException("\u91d1\u94bb\u4f1a\u5458\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
        }
        MemberShip memberShip = (MemberShip)shiplist.get(0);
        this.baseDao.deleteById(MemberShip.class, (Number)memberShip.getSeqId());
    }

    private void deleteMemberDetail(boolean isForce, long userId) throws XLRuntimeException, Exception {
        MemberDetail query = new MemberDetail();
        query.setUserId(userId);
        List shiplist = this.baseDao.findByObject(MemberDetail.class, (Object)query, page);
        if (shiplist == null || shiplist.size() == 0) {
            throw new XLRuntimeException("\u91d1\u94bb\u4f1a\u5458\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!isForce && shiplist.size() >= 2) {
            throw new XLRuntimeException("\u91d1\u94bb\u4f1a\u5458\u8be6\u60c5\u8d85\u8fc71\u6761\u8bb0\u5f55");
        }
        for (MemberDetail memberDetail : shiplist) {
            this.baseDao.deleteById(MemberDetail.class, (Number)memberDetail.getSeqId());
        }
    }

    private void deletePrivilege(long userId) throws XLRuntimeException, Exception {
        PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
        query.setUserId(userId);
        String yearMonth = DateUtil.getNowDay().substring(0, 7);
        query.setYearMonth(yearMonth);
        List shiplist = this.baseDao.findByObject(PrivilegeReceiveInfo.class, (Object)query, page);
        if (shiplist == null || shiplist.size() == 0) {
            throw new XLRuntimeException("\u7279\u6743\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (PrivilegeReceiveInfo pri : shiplist) {
            this.baseDao.deleteById(PrivilegeReceiveInfo.class, (Number)pri.getSeqId());
        }
    }

    @Override
    public List<MemberShip> queryMemberShip(long userid) {
        return this.memberShipDao.queryMemberShip(userid);
    }
}

