/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuan.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.GrowHistoryBo;
import com.xunlei.niux.data.jinzuan.proxy.BonusCache;
import com.xunlei.niux.data.jinzuan.proxy.VipGradeProxy;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.BuQian;
import com.xunlei.niux.data.jinzuan.vo.CommonData;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.data.jinzuan.vo.Signin;
import com.xunlei.niux.data.jinzuan.vo.SigninHistory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GrowHistoryBoImpl
implements GrowHistoryBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void update(GrowHistory history) {
        this.baseDao.updateById((Object)history);
    }

    @Override
    public void insert(GrowHistory history) {
        this.baseDao.insert((Object)history);
    }

    public int getVipGrade(List<Integer> vipGradeList, List<Long> growValueList, MemberShip ship) {
        long growthValue = ship.getGrowthValue();
        int vipGrade = 1;
        for (int i = 0; i < growValueList.size(); ++i) {
            Long value = growValueList.get(i);
            if (growthValue < value) continue;
            vipGrade = vipGradeList.get(i);
            break;
        }
        return vipGrade;
    }

    @Override
    public void addGrowHistory(GrowHistory gh, MemberShip ship) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String nowDay = sdf.format(new Date());
        ArrayList<Integer> vipgradelist = VipGradeProxy.getInstance().getVipGradeList();
        ArrayList<Long> growvaluelist = VipGradeProxy.getInstance().getGrowValueList();
        this.insert(gh);
        ship.setGrowthValue((ship.getGrowthValue() == null ? 0L : ship.getGrowthValue()) + (gh.getGrowValue() == null ? 0L : gh.getGrowValue()));
        ship.setLevelNum(this.getVipGrade(vipgradelist, growvaluelist, ship));
        String sql = "update jinzuan_membership set growthValue=" + ship.getGrowthValue() + ",levelNum=" + ship.getLevelNum() + "  where  userId=" + ship.getUserId();
        this.baseDao.execute(sql, new ArrayList());
        String annualMemberExpireDate = ship.getAnnualMemberExpireDate();
        long data = DateUtil.compareTime(annualMemberExpireDate, nowDay);
        boolean realYear = false;
        if (data >= 0L) {
            realYear = true;
        }
        this.addPrivilege(realYear, ship.getUserId(), ship.getLevelNum(), nowDay);
    }

    @Override
    public void signGrowHistory(GrowHistory gh, MemberShip ship, String ip, String daytime) throws XLRuntimeException, Exception {
        String experienceDate;
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = sdfhms.format(new Date());
        String nowDay = nowTime.split(" ")[0];
        String sql = "select * from jinzuan_signin where userid=? for update";
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ship.getUserId());
        List signlist = this.baseDao.findBySql(Signin.class, sql, list);
        if (signlist == null || signlist.size() == 0) {
            Signin signin = new Signin();
            signin.setUserId(ship.getUserId());
            signin.setRecordTime(nowTime);
            signin.setLastSignInDate(nowDay);
            signin.setTotalSignInCount(new Long(1L));
            this.baseDao.insert((Object)signin);
        } else {
            Signin mysign = (Signin)signlist.get(0);
            mysign.setLastSignInDate(nowDay);
            mysign.setTotalSignInCount(mysign.getTotalSignInCount() + 1L);
            this.baseDao.updateById((Object)mysign);
        }
        SigninHistory history = new SigninHistory();
        history.setDayTime(nowDay);
        long count = this.baseDao.count((Object)history);
        this.updateSignPeopleCount(count);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        history.setDayTime(sdfhms.format(cal.getTime()).split(" ")[0]);
        history.setUserId(ship.getUserId());
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List bhlist = this.baseDao.findByObject(SigninHistory.class, (Object)history, page);
        SigninHistory newhistory = new SigninHistory();
        newhistory.setUserId(ship.getUserId());
        newhistory.setDayTime(daytime);
        newhistory.setSignInTime(nowTime);
        newhistory.setIp(ip);
        boolean isReplenish = DateUtil.compareTime(nowDay, daytime) > 0L;
        newhistory.setIsReplenish(isReplenish);
        newhistory.setSignIndex(new Long(count + 1L));
        if (bhlist == null || bhlist.size() == 0) {
            newhistory.setIsContinue(true);
            newhistory.setContinueDays(new Long(1L));
        } else {
            SigninHistory myhistory = (SigninHistory)bhlist.get(0);
            newhistory.setContinueDays(new Long(myhistory.getContinueDays() + 1L));
            newhistory.setIsContinue(true);
        }
        String annualMemberExpireDate = ship.getAnnualMemberExpireDate();
        long data = DateUtil.compareTime(annualMemberExpireDate, nowDay);
        boolean realYear = false;
        if (data >= 0L) {
            realYear = true;
        }
        Map<String, Long> map = BonusCache.getInstance().getBonusMap();
        Long value = map.get(ship.getLevelNum() + "_" + (realYear ? 1 : 0));
        newhistory.setBonus(value.intValue());
        this.baseDao.insert((Object)newhistory);
        if (isReplenish) {
            this.addBuQian(ship.getUserId(), nowTime, daytime, newhistory.getBonus(), gh.getGrowValue().intValue());
        }
        if (StringTools.isNotEmpty((String)(experienceDate = ship.getExperienceDate())) && DateUtil.compareTime(experienceDate, nowDay) >= 0L) {
            return;
        }
        ArrayList<Integer> vipgradelist = VipGradeProxy.getInstance().getVipGradeList();
        ArrayList<Long> growvaluelist = VipGradeProxy.getInstance().getGrowValueList();
        this.insert(gh);
        ship.setGrowthValue(ship.getGrowthValue() + gh.getGrowValue());
        ship.setLevelNum(this.getVipGrade(vipgradelist, growvaluelist, ship));
        this.baseDao.updateById((Object)ship);
        this.addPrivilege(realYear, ship.getUserId(), ship.getLevelNum(), daytime);
    }

    private void addBuQian(long userId, String nowTime, String dayTime, int bonus, int growValue) {
        BuQian buQian = new BuQian();
        buQian.setUserId(userId);
        buQian.setDayTime(dayTime);
        buQian.setSignTime(nowTime);
        buQian.setGrowValue(growValue);
        buQian.setBonus(bonus);
        buQian.setSignWay(2);
        this.baseDao.insert((Object)buQian);
    }

    private void updateSignPeopleCount(long count) {
        String querysql = "select * from jinzuan_commondata where seqid=1 for update";
        List signlist = this.baseDao.findBySql(CommonData.class, querysql, new ArrayList());
        if (signlist == null || signlist.size() == 0) {
            return;
        }
        CommonData signData = (CommonData)signlist.get(0);
        signData.setDataValue(count + 1L + "");
        this.baseDao.updateById((Object)signData);
    }

    private void addPrivilege(boolean realYear, long uid, int vipgrade, String daytime) throws Exception {
        Page page = new Page();
        Privilege query = new Privilege();
        query.setIsAnnual(realYear ? 1 : 0);
        query.setIsvalid(true);
        query.setLevelNum(vipgrade);
        List plist = this.baseDao.findByObject(Privilege.class, (Object)query, page);
        if (plist == null || plist.size() == 0) {
            return;
        }
        String month = daytime.substring(0, 7);
        PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
        queryinfo.setUserId(uid);
        queryinfo.setYearMonth(month);
        List prinfolist = this.baseDao.findByObject(PrivilegeReceiveInfo.class, (Object)queryinfo, page);
        for (Privilege p : plist) {
            int ptype = p.getPrivilegeType();
            boolean flag = false;
            for (PrivilegeReceiveInfo pri : prinfolist) {
                if (ptype != pri.getPrivilegeType()) continue;
                flag = true;
                if (p.getValue().longValue() == pri.getTotalValue().longValue()) break;
                pri.setAvailableValue(p.getValue() - (pri.getTotalValue() - pri.getAvailableValue()));
                pri.setTotalValue(p.getValue());
                this.baseDao.updateById((Object)pri);
                break;
            }
            if (flag) continue;
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(uid);
            info.setYearMonth(month);
            info.setPrivilegeType(p.getPrivilegeType());
            info.setRecordTime(daytime);
            info.setTotalValue(p.getValue());
            info.setAvailableValue(p.getValue());
            info.setIsvalid(true);
            info.setSimpleName(p.getSimpleName());
            this.baseDao.insert((Object)info);
        }
    }
}

