package com.xunlei.niux.data.jinzuan.bo;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveHistory;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;


public class PrivilegeReceiveInfoBoImpl implements PrivilegeReceiveInfoBo {

    private static final Page page = new Page();
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public void update(PrivilegeReceiveInfo info){
		 baseDao.updateById(info);
	}
	public void insert(PrivilegeReceiveInfo info) {
		baseDao.insert(info);
	}
	
	/**
	 * 金钻用户使用特权，减少剩余数量
	 */
	@Override
	public void addPrivilegeReceiveInfo(PrivilegeReceiveInfo info)
			throws XLRuntimeException, Exception {
		SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		int privilegeType = info.getPrivilegeType();
		long uid = info.getUserId();		
		long amount = info.getTotalValue();//使用数量
		String month = info.getYearMonth();//年月的特权
		StringBuffer sql = new StringBuffer("select * from jinzuan_privilegereceiveinfo where privilegeType=? and userId=? and yearMonth=? for update");

        List list = new ArrayList();
        list.add(privilegeType);
        list.add(uid);
        list.add(month);
		List<PrivilegeReceiveInfo> prilist = baseDao.executeQuery(PrivilegeReceiveInfo.class, sql.toString(), list);
		if(prilist == null||prilist.size()==0){
			throw new XLRuntimeException("您不存在该特权");
		}else{
			PrivilegeReceiveInfo pri = prilist.get(0);
			long availableValue = pri.getAvailableValue();//剩余可使用量
			if(availableValue-amount<0){
				throw new XLRuntimeException("您该项特权的剩余可使用数不足");
			}
			pri.setAvailableValue(availableValue-amount);
			baseDao.updateById(pri);
			
			PrivilegeReceiveHistory history = new PrivilegeReceiveHistory();
			history.setPrivilegeType(privilegeType);
			history.setRecordTime(sdfhms.format(new Date()));
			history.setUsedValue(amount);
			history.setUserId(uid);
			baseDao.insert(history);
		}		
	}
	@Override
	public void updatePrivilege(long userid,boolean flag) {
		 SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		 SimpleDateFormat monthhms = new SimpleDateFormat("yyyy-MM");
	     String sql = "select * from jinzuan_membership where memberExpireDate >= DATE_SUB(CURDATE(),INTERVAL 1 DAY) and  userId=? ";
        List paramList = new ArrayList();
        paramList.add(userid);
	     List<MemberShip> mslist = baseDao.executeQuery(MemberShip.class, sql, paramList);
	     Calendar cal = Calendar.getInstance();
	     String month = null;
	     if(flag){//是否需要提前分配下个月的特权
	    	 cal.add(Calendar.MONTH, 1);
	    	 month = monthhms.format(cal.getTime());
	     }else{
	    	 month = monthhms.format(new Date()); 
	     }	    
		 if(mslist != null&& mslist.size()>0){//如果是会员
			 MemberShip ship = mslist.get(0);
			Privilege query = new Privilege();
			query.setIsAnnual(ship.getIsAnnualMember());
			query.setIsvalid(true);//有效的特权
			query.setLevelNum(ship.getLevelNum());//金钻等级
			List<Privilege> plist =baseDao.findByObject(Privilege.class, query, new Page());
			
			String nowtime = sdfhms.format(new Date());
    		//String month = nowtime.split(" ")[0].substring(0,7);
    		PrivilegeReceiveInfo priquery = new PrivilegeReceiveInfo();
    		priquery.setUserId(userid);
    		priquery.setYearMonth(month);
    		List<PrivilegeReceiveInfo> list = baseDao.findByObject(PrivilegeReceiveInfo.class, priquery,page);
    		if(list != null&&list.size()>0)return;//如果本月已经分配过特权了，则不需要再分配
			for(Privilege priv:plist){
				PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        		info.setUserId(userid);       		
        		info.setYearMonth(month);
        		info.setPrivilegeType(priv.getPrivilegeType());
        		info.setRecordTime(nowtime);
        		info.setTotalValue(priv.getValue());
        		info.setAvailableValue(priv.getValue());
        		info.setIsvalid(true);//获得有效的特权
        		info.setSimpleName(priv.getSimpleName());
        		baseDao.insert(info);
			}
		 }
	}   
	
	
	public void addPrivilege(boolean realYear,long uid,int vipgrade,String daytime) throws Exception{
	    Page page = new Page();
		Privilege query = new Privilege();
		query.setIsAnnual(realYear?1:0);
		query.setIsvalid(true);//有效的特权
		query.setLevelNum(vipgrade);//金钻等级
		List<Privilege> plist =baseDao.findByObject(Privilege.class, query, page);
		if(plist ==null||plist.size()==0){//如果没有配置特权
			return ;
		}
		String month = daytime.substring(0,7);
		PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
		queryinfo.setUserId(uid);
		queryinfo.setYearMonth(month);
		List<PrivilegeReceiveInfo> prinfolist = baseDao.findByObject(PrivilegeReceiveInfo.class,queryinfo,page);		
		
        for(Privilege p:plist){
        	int ptype = p.getPrivilegeType().intValue();
        	boolean flag = false;
        	for(PrivilegeReceiveInfo pri:prinfolist){
        		if(ptype == pri.getPrivilegeType().intValue()){//如果有特权
        			flag = true;        		
        			break;
        		}
        	}
        	if(!flag){//如果之前没有特权，则需要增加
        		PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        		info.setUserId(uid);
        		info.setYearMonth(month);
        		info.setPrivilegeType(p.getPrivilegeType());
        		info.setRecordTime(daytime);
        		info.setTotalValue(p.getValue());
        		info.setAvailableValue(p.getValue());
        		info.setIsvalid(true);//获得有效的特权
        		info.setSimpleName(p.getSimpleName());
        		baseDao.insert(info);
        	}
        }		
	}
}
