package com.xunlei.niux.data.jinzuan.bo;


import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.dao.MemberShipDao;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.MemberDetail;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;


public class MemberShipBoImpl implements MemberShipBo{

	private BaseDao baseDao;
	private MemberShipDao memberShipDao;
	private static final Page page =  new Page();
	
    
	public MemberShipDao getMemberShipDao() {
		return memberShipDao;
	}
	public void setMemberShipDao(MemberShipDao memberShipDao) {
		this.memberShipDao = memberShipDao;
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void delete(boolean isForce,long userId) throws XLRuntimeException, Exception {
		deleteMemberShip(userId);
		deleteMemberDetail(isForce,userId);
		deletePrivilege(userId);
	}
    
	
	private void deleteMemberShip(long userId) throws XLRuntimeException, Exception{
		MemberShip query = new MemberShip();
		query.setUserId(userId);
		List<MemberShip> shiplist = baseDao.findByObject(MemberShip.class, query, page);
		if(shiplist == null||shiplist.size()==0){
			throw new XLRuntimeException("金钻会员基本信息为空");
		}
		MemberShip memberShip = shiplist.get(0);
		baseDao.deleteById(MemberShip.class, memberShip.getSeqId());
	}
	
	private void deleteMemberDetail(boolean isForce,long userId) throws XLRuntimeException, Exception{
		MemberDetail query = new MemberDetail();
		query.setUserId(userId);
		List<MemberDetail> shiplist = baseDao.findByObject(MemberDetail.class, query, page);
		if(shiplist == null||shiplist.size()==0){
			throw new XLRuntimeException("金钻会员详情信息为空");
		}
		if(!isForce&&shiplist.size()>=2){
			throw new XLRuntimeException("金钻会员详情超过1条记录");
		}
		for(MemberDetail memberDetail:shiplist){
			   baseDao.deleteById(MemberDetail.class, memberDetail.getSeqId());
		}
	}
	
	private void deletePrivilege(long userId) throws XLRuntimeException, Exception{
		PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
		query.setUserId(userId);
		String yearMonth = DateUtil.getNowDay().substring(0,7);
		query.setYearMonth(yearMonth);
		List<PrivilegeReceiveInfo> shiplist = baseDao.findByObject(PrivilegeReceiveInfo.class, query, page);
		if(shiplist == null||shiplist.size()==0){
			throw new XLRuntimeException("特权信息为空");
		}
		for(PrivilegeReceiveInfo pri:shiplist){
			baseDao.deleteById(PrivilegeReceiveInfo.class, pri.getSeqId());
		}		
	}
	@Override
	public List<MemberShip> queryMemberShip(long userid) {	
		return memberShipDao.queryMemberShip(userid);
	}
}
