package com.xunlei.niux.data.jinzuan.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.proxy.VipGradeProxy;
import com.xunlei.niux.data.jinzuan.util.BonusUtil;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


public class PayOrderBoImpl implements PayOrderBo {

	private static final int MONTHDAY = 31;
	private static final int YEARMONTH = 12;
	private static final int YEARDAYS = 365;
	private static final String sourceId = "100001";
	private static final int EXPERIENCEMAXDAY = 2*31;//体验会员同一个账号两个月内不能重复开通	
    private static final Page page = new Page();

    private static Map<Long,Integer> gradeMap;
    
    static{
    	if(gradeMap==null){
    		gradeMap  = new HashMap<Long,Integer>();
    		gradeMap.put(1L, -1);
    		gradeMap.put(3L, -2);
    		gradeMap.put(7L, -3);
    	}
    }
    
	
	private BaseDao baseDao;

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	
	public void update(PayOrder order) {
		baseDao.updateById(order);
	}

	public void insert(PayOrder order) throws SQLException{
		baseDao.insert(order);
	}

    private static Logger logger = LoggerFactory
            .getLogger(PayOrderBoImpl.class.getName());

	/**
	 * 退订订单
	 */
	public void cancelOrder(String orderId,long userId) throws XLRuntimeException,Exception{   
		    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			cancelMemberShip(orderId,userId,sdf);						
	}
	
	
	/**
	 * 收回会员过期时间和会员特权
	 * @throws Exception
	 */
	private void cancelMemberShip(String orderId,long userId,SimpleDateFormat sdf) throws XLRuntimeException, Exception{
		//获得会员基本信息
		long userid = userId;
		MemberShip queryship = new MemberShip();
		queryship.setUserId(userid);		
		List<MemberShip> shiplist  = baseDao.findByObject(MemberShip.class, queryship, page);
		if(shiplist==null||shiplist.size()==0){
			throw new XLRuntimeException("该订单的下单用户非金钻会员");
		}
		MemberShip ship = shiplist.get(0);
		
		String daytime = DateUtil.getNowDay();//当前日期
		boolean ismember = DateUtil.compareTime(ship.getMemberExpireDate(),daytime) >= 0 ? true : false;//当前普通会员状态
		if(!ismember){//如果已经不是会员了，就不需要回退
			throw new XLRuntimeException("该订单的下单用户已经不是金钻会员");
		}
		
		MemberDetail detailquery = new MemberDetail();
		detailquery.setUserId(userid);		
		Page dqpage = new Page();
		dqpage.addOrder("orderStartDate", OrderType.ESC);
		List<MemberDetail> mdlist = baseDao.findByObject(MemberDetail.class, detailquery, dqpage);
		
		MemberDetail nowmd = checkMemberDetail(mdlist,orderId);
		MemberDetail beforemd = null;
		for(MemberDetail md:mdlist){
	       	 if(md.getSeqId().longValue()<nowmd.getSeqId()){
	       		beforemd = md  ;
	       	 }
        }
		//更新会员基本信息
		updateMemberShip(ship,beforemd,nowmd);
		//删除会员详情信息
		deleteMemberDetail(nowmd);
		//重新计算特权信息		
		boolean isyear = DateUtil.compareTime(ship.getAnnualMemberExpireDate(),daytime) >= 0 ? true : false;//更新之后的年费状态	
		addPrivilege(isyear,false, userId, ship.getLevelNum().intValue(),sdf);
	}
	
	private void updateMemberShip(MemberShip ship,MemberDetail beforemd,MemberDetail nowmd) throws Exception{
		if(beforemd == null){//如果没有历史记录
			ship.setAnnualMemberExpireDate("");
			ship.setIsAnnualMember(0);
			ship.setMemberStatus(0);
			String beforeDay = DateUtil.getNewDay(DateUtil.getNowDay(), 1, false);
			ship.setMemberExpireDate(beforeDay);
		}else{//如果有历史记录
			int memberStatus = nowmd.getMemberStatus().intValue();
			if(memberStatus<2){//如果下单前不是年费状态
				String orderDay = nowmd.getOrderTime();//前一笔订单当时下订单的日期
				if(orderDay.length()>10){
					orderDay = orderDay.substring(0,10);
				}
				boolean isYear = isChangeYear(nowmd.getOrderEndDate(), orderDay);
				if(isYear){//如果下单的订单，下单后变为年费
					ship.setAnnualMemberExpireDate("");
					ship.setIsAnnualMember(0);
					String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum().intValue(), false);
					ship.setMemberExpireDate(memberExpireDate);
				}else{//如果下单的订单，下单后还是普通会员
					String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum().intValue(), false);
					ship.setMemberExpireDate(memberExpireDate);
				}
			}else{//如果下单前是年费状态
				String annualMemberExpireDate = DateUtil.getNewDay(ship.getAnnualMemberExpireDate(), nowmd.getDayNum().intValue(), false);
				ship.setAnnualMemberExpireDate(annualMemberExpireDate);
				String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum().intValue(), false);
				ship.setMemberExpireDate(memberExpireDate);
			}
		}		
		baseDao.updateById(ship);
	}
	
	private void deleteMemberDetail(MemberDetail nowmd){
		baseDao.deleteById(MemberDetail.class, nowmd.getSeqId());//删除第一个订单		
	}
	
	private MemberDetail checkMemberDetail(List<MemberDetail> mdlist,String orderId) throws XLRuntimeException{
		if(mdlist == null||mdlist.size()==0){
			throw new XLRuntimeException("该用户不存在任何订单");
		}
        long seqid = 0l;
        MemberDetail detail = null;
        for(MemberDetail md:mdlist){
        	 if(md.getOrderId().equals(orderId)){
        		 seqid = md.getSeqId().longValue();
        		 detail = md;
        	 }
        }
		if(seqid == 0){
			throw new XLRuntimeException("该订单不存在");
		}	
		for(MemberDetail md:mdlist){
	       	 if(md.getSeqId().longValue()>seqid){
	       		throw new XLRuntimeException("目前只允许退订最后一个订单");
	       	 }
       }
	   	return detail;
	}
	
	
	
	
	public void updatePrivilege(long userid,int levelNum,boolean beforeYear,int status){
		Page page = new Page();
		Privilege privilegequery = new Privilege();
		privilegequery.setIsAnnual(0);
		privilegequery.setIsvalid(true);//有效的特权
		privilegequery.setLevelNum(levelNum);//金钻等级
		List<Privilege> plist =baseDao.findByObject(Privilege.class, privilegequery, page);
		
		//收回相应的特权
		PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
		query.setUserId(userid);
		List<PrivilegeReceiveInfo> prilist  = baseDao.findByObject(PrivilegeReceiveInfo.class, query, page);
		switch(status){
		case 0://如果回收之后变成了非会员
			for(PrivilegeReceiveInfo pri: prilist){
					pri.setAvailableValue(0L);
					baseDao.updateById(pri);			
			}	 
			break;
		case 1://如果回收之后变成了普通会员
			if(beforeYear){//如果回收之前是年费会员，现在变成了普通会员
				for(Privilege p:plist){			
					for(PrivilegeReceiveInfo pri: prilist){
						if(p.getPrivilegeType().intValue()==pri.getPrivilegeType().intValue()){
							long usedValue = pri.getTotalValue()-pri.getAvailableValue();
							pri.setTotalValue(p.getValue());
							pri.setAvailableValue(pri.getTotalValue()-usedValue<=0?0:pri.getTotalValue()-usedValue);
							baseDao.updateById(pri);
						}					
					}	
				}				
			}				
			break;
		case 2://如果回收之后还是年费会员	
			break;
		}
	}
	
	/**
	 * 重置其他充值详情的时间
	 * @param mdlist
	 */
	private MemberDetail resetTime(List<MemberDetail> mdlist) throws Exception{
		MemberDetail detail = mdlist.get(0);		
		baseDao.deleteById(MemberDetail.class, detail.getSeqId());//删除第一个订单		
		if(mdlist.size()==1){//如果只有一个订单
			return null;
		}	
		for(int i=1;i<mdlist.size();i++){
			updateMemberDetail(i-1,mdlist.get(i-1),mdlist.get(i));
		}      
		return mdlist.get(mdlist.size()-1);//返回最后一次充值的订单详情
	}
	
	
	private void updateMemberDetail(int index,MemberDetail beforeDetail,MemberDetail nowDetail) throws Exception{
		SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
		int status = beforeDetail.getMemberStatus().intValue();//前一笔订单的状态
		String orderTime = beforeDetail.getOrderTime();//前一笔订单当时下订单的日期
		if(orderTime.length()>10){
			orderTime = orderTime.substring(0,10);
		}
		//String beforeDate = beforeDetail.getOrderStartDate();//前一笔订单的开始日期
		String endDate = beforeDetail.getOrderEndDate();//前一笔订单的结束日期
		if(status == 0){//如果之前非会员
			nowDetail.setOrderStartDate(beforeDetail.getOrderStartDate());
			String endTime = getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum(),Daysdf);
			nowDetail.setOrderEndDate(endTime);					
		}else if(status == 1){//如果之前是普通会员			
			if(index == 0){
				nowDetail.setOrderStartDate(beforeDetail.getOrderStartDate());
			}else{
				nowDetail.setOrderStartDate(beforeDetail.getOrderEndDate());
			}			
			String endTime = getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum(),Daysdf);
			nowDetail.setOrderEndDate(endTime);
		}else if(status == 2){//如果之前已经是年费会员
			nowDetail.setOrderStartDate(endDate);
			String endTime = getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum(),Daysdf);
			nowDetail.setOrderEndDate(endTime);
			//状态设置为年费会员
		}		
		nowDetail.setMemberStatus(status);
		baseDao.updateById(nowDetail);
	}
	
	/**
	 * 是否满足变成年费的条件
	 * @param memberExpireDate 会员时间
	 * @param daytime 当时充值的日期
	 * @return
	 * @throws Exception
	 */
	private boolean  isChangeYear(String memberExpireDate,String daytime) throws Exception{
		if(StringTools.isEmpty(memberExpireDate))return false;
		long totaldays = DateUtil.compareTime(memberExpireDate, daytime);
		if (totaldays - YEARDAYS* 24 * 60 * 60 >= 0) {// 如果满足包年的条件
			return true;
		}
		return false;
	}
	
	
	/**
	 * 体验会员
	 */
	public void experiencePayOrder(PayOrder order,String seqId)throws XLRuntimeException,Exception{
		try{
			 this.insert(order);
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
			MemberShip query = new MemberShip();
			query.setUserId(order.getUserId());
			List<MemberShip> mslist = baseDao.findByObject(MemberShip.class, query, page);
			MemberShip ship = null;
			if(!CollectionUtils.isEmpty(mslist)){//如果存在会员信息
				ship = mslist.get(0);
				String memberExpireDate = ship.getMemberExpireDate();//会员过期时间
				if(!StringTools.isEmpty(memberExpireDate)){//如果会员过期时间不为空，则不能开通体验会员
					throw new XLRuntimeException("正式会员不能开通体验会员");
				}
				String experienceDate = ship.getExperienceDate();//体验会员过期时间
				if(!StringUtils.isEmpty(experienceDate) && !checkTime(experienceDate,Daysdf)){
					throw new XLRuntimeException("体验会员"+EXPERIENCEMAXDAY+"天内不能连续开通");
				}				
			}
			
			// 新增会员详情表中的记录
			addExperienceMemberDetail(order,Daysdf);
			
			// 更新体验会员信息
			ship = updateExperienceMemberInfo(order, ship,sdf,Daysdf);
			
			//增加特权
			addPrivilege(false,false,order.getUserId(),ship.getLevelNum(),sdf);
		}catch(Exception e){
			e.printStackTrace();
			throw e;
		}
	}


	/**
	 * 更新用户的夺宝金钻信息
	 */
	@Override
	public void duobaoPayOrder(PayOrder order, String seqId)
			throws XLRuntimeException, Exception {
	    this.checkLimit(order, seqId);
        this.insert(order);//未完成

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
		MemberShip query = new MemberShip();
		query.setUserId(order.getUserId());
		List<MemberShip> mslist = baseDao.findByObject(MemberShip.class, query, page);
		MemberShip ship = null;
		if(!CollectionUtils.isEmpty(mslist)){//如果存在会员信息
			ship = mslist.get(0);
			String memberExpireDate = ship.getMemberExpireDate();//会员过期时间
			Date date = new Date();
			String daytime = Daysdf.format(date);
			if(!StringTools.isEmpty(memberExpireDate) && DateUtil.compareTime(daytime, memberExpireDate)<0){//不是正式会员，则不能开通体验会员
				throw new XLRuntimeException("正式会员不能开通夺宝会员");
			}
		}
		
		// 新增夺宝金钻会员详情表中的记录
		addDuobaoMemberDetail(order,Daysdf);
		
		// 更新夺宝金钻会员信息
		ship = updateDuobaoMemberInfo(order, ship,sdf,Daysdf);
		
		//增加夺宝金钻特权
		addPrivilegeDuobao(order.getUserId(),ship,sdf);
		
		//更新赠送订单状态为“已完成”
		PayOrder q = new PayOrder();
		q.setOrderId(order.getOrderId());
		List<PayOrder> myPayOrder = baseDao.findByObject(PayOrder.class, q, new Page());
		if (myPayOrder != null && myPayOrder.size() > 0) {
			q = myPayOrder.get(0);
			q.setOrderStatus(3);
			baseDao.updateById(q);
		}
	}

	/**
	 * 判断过期时间是否在两个月之前
	 * @param experienceDate
	 * @param Daysdf
	 * @return
	 */
	private boolean checkTime(String experienceDate,SimpleDateFormat Daysdf){
		String daytime = Daysdf.format(new Date());
		try{
			Date date1 = Daysdf.parse(daytime);
			Date date2 = Daysdf.parse(experienceDate);
			long data1 = date1.getTime();
			long data2 = date2.getTime();
			return ((data1 - data2) / (1000*60*60*24)>EXPERIENCEMAXDAY?true:false);
		}catch(Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	
	/**
	 * 更新用户的金钻信息
	 */
	@Override
	public void addPayOrder(PayOrder order,boolean isupdate,boolean isBuQi) {				
		try{
		   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		   SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
			//查询玩家是否首充
	        PayOrder queryPayOrder = new PayOrder();
	        queryPayOrder.setUserId(order.getUserId());
	        queryPayOrder.setOrderType(new Integer(1));//充值的订单
	        queryPayOrder.setOrderStatus(new Integer(3));//支付成功
	        Page page = new Page();
	        page.setPageNo(1);
	        page.setPageSize(1);
	        List<PayOrder> polist = baseDao.findByObject(PayOrder.class, queryPayOrder, page);
	        boolean isFirstPay = false;//是否是金钻首充
			if(polist==null||polist.size()==0){
				isFirstPay = true;				
			}
			boolean isYear = order.getTimeType().intValue()==3?true:false;//如果充值的是年费会员			
			if(isupdate){
				order.setOrderStatus(new Integer(3));// 更新订单状态为完成状态
				order.setFinishTime(sdf.format(new Date()));
				baseDao.updateById(order);
			}

			// 查询金钻会员信息
			MemberShip queryship = new MemberShip();
			queryship.setUserId(order.getUserId());
			List<MemberShip> shiplist  = baseDao.findByObject(MemberShip.class, queryship, new Page());
			MemberShip ship = null;
			boolean isExperience = false;//是否有效的体验会员
			boolean isDuobao = false;//是否有效的夺宝会员
			if(shiplist !=null&&shiplist.size()>0){
				ship = shiplist.get(0);			
				//判断是否有效的体验会员
				isDuobao = DateUtil.compareTime(ship.getDuobaoExpireDate(), Daysdf.format(new Date()))>=0?true:false;
				isExperience = DateUtil.compareTime(ship.getExperienceDate(), Daysdf.format(new Date()))>=0?true:isDuobao;//变成正式的时候夺宝和体验金钻的特权都清空
			}
			
			// 新增会员详情表中的记录
			addMemberDetail(order,ship,Daysdf);
			
			// 更新会员信息，如果之前不是金钻用户，会新增为金钻用户1
			ship = updateMemberInfo(order, ship,isBuQi, isYear,sdf,Daysdf);

            logger.info("jinzuanpay, judge is first pay, userId:" + order.getUserId() + " isFirstPay:" + isFirstPay + " orderType:" + order.getOrderType().intValue());
			//首充增加成长值
			if(isFirstPay&&order.getOrderType().intValue()==1){//如果是充值的才加成长值，赠送的不加成长值
				ship = firstPay(order.getTimeType(),order.getNumValue(),ship,order.getUserId(),sdf,Daysdf);
                //首次开通赠送200积分
                logger.info("jinzuanfirstpay, rechargebonusstart, userId:" + order.getUserId());
                BonusUtil.rechargeBonus(order.getUserId().toString(), "", 200, order.getOrderId(), Daysdf.format(new Date()), "jinzuanfirstpay");

                FirstPayBonusHistory firstPayBonusHistory = new FirstPayBonusHistory();
                firstPayBonusHistory.setUserId(order.getUserId());
                firstPayBonusHistory.setBonusChargeTime(sdf.format(new Date()));
                FacadeFactory.INSTANCE.getBaseSo().addObject(firstPayBonusHistory);
			}
			String annualMemberExpireDate =  ship.getAnnualMemberExpireDate();			
	        long data =  DateUtil.compareTime(annualMemberExpireDate, Daysdf.format(new Date()));
			boolean realYear = false;//真实的年费状态
			if(data >= 0){
				realYear = true;
			}
					
			//增加特权
			addPrivilege(realYear,isExperience,order.getUserId(),ship.getLevelNum(),sdf);
			
		}catch(Exception e){
			e.printStackTrace();			
		}
	}


    /**
	 * 成为会员之后，增加特权
	 * @param realYear
	 */
	private void addPrivilege(boolean realYear,boolean isExperience,long uid,int vipgrade,SimpleDateFormat sdf) throws Exception{
	    Page page = new Page();
		Privilege query = new Privilege();
		query.setIsAnnual(realYear?1:0);
		query.setIsvalid(true);//有效的特权
		query.setLevelNum(vipgrade);//金钻等级
		List<Privilege> plist =baseDao.findByObject(Privilege.class, query, page);
		if(plist ==null||plist.size()==0){//如果没有配置特权
			return ;
		}
		String nowtime = sdf.format(new Date());
		String month = nowtime.split(" ")[0].substring(0,7);
		PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
		queryinfo.setUserId(uid);
		queryinfo.setYearMonth(month);
		List<PrivilegeReceiveInfo> prinfolist = baseDao.findByObject(PrivilegeReceiveInfo.class,queryinfo,page);		
		
        for(Privilege p:plist){
        	int ptype = p.getPrivilegeType().intValue();
        	boolean flag = false;
        	for(PrivilegeReceiveInfo pri:prinfolist){
        		if(ptype == pri.getPrivilegeType().intValue()){//如果有特权
        			flag = true;
        			if(isExperience){//如果之前是有效的体验会员，则清掉之前使用的记录
        				pri.setAvailableValue(p.getValue());//可用数量
        			}else{
        				pri.setAvailableValue(p.getValue()-(pri.getTotalValue()-pri.getAvailableValue()));//可用数量
        			}       
        			pri.setTotalValue(p.getValue());        			
        			baseDao.updateById(pri);//更新特权值
        			break;
        		}
        	}
        	if(!flag){//如果之前没有特权，则需要增加
        		PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        		info.setUserId(uid);
        		info.setYearMonth(month);
        		info.setPrivilegeType(p.getPrivilegeType());
        		info.setRecordTime(sdf.format(new Date()));
        		info.setTotalValue(p.getValue());
        		info.setAvailableValue(p.getValue());
        		info.setIsvalid(true);//获得有效的特权
        		info.setSimpleName(p.getSimpleName());
        		baseDao.insert(info);
        	}
        }		
	}
	
	/**
	 * 成为会员之后，增加特权
	 */
	private void addPrivilegeDuobao(long uid,MemberShip ship,SimpleDateFormat sdf) throws Exception{
		Page page = new Page();
		Privilege query = new Privilege();
		query.setIsAnnual(0);
		query.setIsvalid(true);//有效的特权
		query.setLevelNum(1);//金钻等级
		List<Privilege> plist =baseDao.findByObject(Privilege.class, query, page);
		if(plist ==null||plist.size()==0){//如果没有配置特权
			return ;
		}
		
		Iterator<Privilege> iter = plist.iterator();
		for(;iter.hasNext();){
			Privilege pri = (Privilege)iter.next();
			if(pri.getPrivilegeType() == 1){//只保留夺宝金钻的特权：首冲礼包
				
			}
			else{
				iter.remove();
			}
		}
		
		String nowtime = ship.getDuobaoExpireDate();//sdf.format(new Date());//用夺宝截止时间对应月份的特权
		String month = nowtime.split(" ")[0].substring(0,7);
		PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
		queryinfo.setUserId(uid);
		queryinfo.setYearMonth(month);
		List<PrivilegeReceiveInfo> prinfolist = baseDao.findByObject(PrivilegeReceiveInfo.class,queryinfo,page);		
		
		for(Privilege p:plist){
			int ptype = p.getPrivilegeType().intValue();
			boolean flag = false;
			for(PrivilegeReceiveInfo pri:prinfolist){
        		if(ptype == pri.getPrivilegeType().intValue()){//如果有特权
        			flag = true;
        			pri.setAvailableValue(p.getValue()-(pri.getTotalValue()-pri.getAvailableValue()));//可用数量
        			pri.setTotalValue(p.getValue());        			
        			baseDao.updateById(pri);//更新特权值
        			break;
        		}
			}
			if(!flag){//如果之前没有特权，则需要增加
				//仅在生效时间覆盖的月份，每月两次特权
				PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
				info.setUserId(uid);
				info.setYearMonth(month);
				info.setPrivilegeType(p.getPrivilegeType());
				info.setRecordTime(sdf.format(new Date()));
				info.setTotalValue(p.getValue());
				info.setAvailableValue(p.getValue());
				info.setIsvalid(true);//获得有效的特权
				info.setSimpleName(p.getSimpleName());
				baseDao.insert(info);
					
			}
		}		
	}
	
	
	/**
	 * 增加夺宝会员详情
	 * @param order
	 * @param Daysdf
	 * @throws Exception
	 */
	private void addDuobaoMemberDetail(PayOrder order,SimpleDateFormat Daysdf) throws Exception {
		Date date = new Date();
		String daytime = Daysdf.format(date);
		MemberDetail detail = new MemberDetail();
		detail.setActNo(order.getActNo());
		detail.setOrderId(order.getOrderId());
		detail.setUserId(order.getUserId());
		detail.setOrderTime(order.getFinishTime());
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		detail.setDayNum(new Long(days).intValue());
		Page page = new Page();
		MemberDetail query = new MemberDetail();
		query.setUserId(order.getUserId());
		query.setDuobaoStatus(1);//只对夺宝金钻 
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("orderEndDate", OrderType.DESC);
		List<MemberDetail> mdlist = baseDao.findByObject(MemberDetail.class,query, page);
		if(mdlist == null||mdlist.size()==0){//如果之前没有记录
			detail.setOrderStartDate(daytime);
			String endtime = getExpireDay(daytime, days,Daysdf);
			detail.setOrderEndDate(endtime);
			detail.setMemberStatus(0);//下单前非会员
			detail.setDuobaoStatus(1);//是夺宝会员
		}else{
			MemberDetail md = mdlist.get(0);			
			String orderEndDate = md.getOrderEndDate();		  
		    detail.setMemberStatus(0);//下单前非会员
			detail.setDuobaoStatus(1);//是夺宝会员
			detail.setOrderStartDate(daytime);
			
			if(DateUtil.compareTime(daytime,orderEndDate)>0){//如果最大的过期日期小于当前日期
				detail.setOrderStartDate(daytime);
				String endtime = getExpireDay(daytime, days,Daysdf);
				detail.setOrderEndDate(endtime);
			}else{//顺延夺宝时间
				detail.setOrderStartDate(getExpireDay(orderEndDate,0,Daysdf));
				String endtime = getExpireDay(orderEndDate, days,Daysdf);
				detail.setOrderEndDate(endtime);
			}
		}
		baseDao.insert(detail);
	}
	
	
	/**
	 * 增加体验会员详情
	 * @param order
	 * @param Daysdf
	 * @throws Exception
	 */
	private void addExperienceMemberDetail(PayOrder order,SimpleDateFormat Daysdf) throws Exception {
		Date date = new Date();
		String daytime = Daysdf.format(date);
		MemberDetail detail = new MemberDetail();
		detail.setActNo(order.getActNo());
		detail.setOrderId(order.getOrderId());
		detail.setUserId(order.getUserId());
		detail.setOrderTime(order.getFinishTime());
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		detail.setDayNum(new Long(days).intValue());
		Page page = new Page();
		MemberDetail query = new MemberDetail();
		query.setUserId(order.getUserId());
		query.setDuobaoStatus(0);//到这里，非夺宝金钻即体验金钻 
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("orderEndDate", OrderType.DESC);
		List<MemberDetail> mdlist = baseDao.findByObject(MemberDetail.class,query, page);
		if(mdlist == null||mdlist.size()==0){//如果之前没有记录
			detail.setOrderStartDate(daytime);
			String endtime = getExpireDay(daytime, days,Daysdf);
			detail.setOrderEndDate(endtime);
			detail.setMemberStatus(0);//下单前非会员
		}else{
			MemberDetail md = mdlist.get(0);			
			String orderEndDate = md.getOrderEndDate();		  
			detail.setMemberStatus(0);//下单前非会员
			detail.setOrderStartDate(daytime);
			String endtime = getExpireDay(daytime, days,Daysdf);
			detail.setOrderEndDate(endtime);
			if(DateUtil.compareTime(daytime,orderEndDate)<=0){//如果最大的过期日期大于等于当前日期。基本上不存在这种情况
				md.setOrderEndDate(DateUtil.getYesterayDay());
				baseDao.updateById(md);//如果还有没有用完的天数，则去掉天数
			}
		}
		baseDao.insert(detail);
	}
	
	
	private void addMemberDetail(PayOrder order,MemberShip ship,SimpleDateFormat Daysdf) throws Exception {
		boolean beforeYearStatus = false;
		boolean beforeMemberStatus = false;
		if(ship != null){
			if(DateUtil.compareTime(ship.getAnnualMemberExpireDate(), Daysdf.format(new Date()))>0){//如果当时会员的状态是年费
				beforeYearStatus = true;
			}
			if(DateUtil.compareTime(ship.getMemberExpireDate(), Daysdf.format(new Date()))>0){//如果当时会员的状态是普通会员
				beforeMemberStatus = true;
			}
		}
		Date date = new Date();
		String daytime = Daysdf.format(date);
		MemberDetail detail = new MemberDetail();
		detail.setActNo(order.getActNo());
		detail.setOrderId(order.getOrderId());
		detail.setUserId(order.getUserId());
		detail.setOrderTime(order.getFinishTime());
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		detail.setDayNum(new Long(days).intValue());
		Page page = new Page();
		MemberDetail query = new MemberDetail();
		query.setUserId(order.getUserId());
		query.setDuobaoStatus(0);//到这里，非夺宝金钻即正式会员
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("orderEndDate", OrderType.DESC);
		List<MemberDetail> mdlist = baseDao.findByObject(MemberDetail.class,query, page);
		if(mdlist == null||mdlist.size()==0){//如果之前没有记录
			detail.setOrderStartDate(daytime);
			String endtime = getExpireDay(daytime, days,Daysdf);
			detail.setOrderEndDate(endtime);
			detail.setMemberStatus(0);//下单前非会员
		}else{
			MemberDetail md = mdlist.get(0);			
			String orderEndDate = md.getOrderEndDate();
		    int status = 0;
		    if(beforeYearStatus){
		    	status = 2;
		    }else{
		    	if(beforeMemberStatus){
		    		status = 1;
		    	}
		    }
		    detail.setMemberStatus(status);
			if(DateUtil.compareTime(daytime,orderEndDate)>0){//如果最大的过期日期小于当前日期
				detail.setOrderStartDate(daytime);
				String endtime = getExpireDay(daytime, days,Daysdf);
				detail.setOrderEndDate(endtime);
			}else{
				detail.setOrderStartDate(getExpireDay(orderEndDate,0,Daysdf));
				String endtime = getExpireDay(orderEndDate, days,Daysdf);
				detail.setOrderEndDate(endtime);
			}
		}
		baseDao.insert(detail);
	}

	
	
	
	/**
	 * 获得充值的天数
	 * @param timeType
	 * @param numValue
	 * @return
	 */
	private long getMemberDays(int timeType, long numValue) {
		long days = 0;
		switch (timeType) {
		case 1:// 如果是增加天数
			days = numValue;
			break;
		case 2:// 如果是增加月数
			days = numValue * MONTHDAY;
			break;
		case 3:// 如果是增加年数
			days = numValue * MONTHDAY * YEARMONTH;
			break;
		}
		return days;
	}

	private MemberShip updateDuobaoMemberInfo(PayOrder order, MemberShip ship
			,SimpleDateFormat sdf,SimpleDateFormat Daysdf) throws Exception {
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		String daytime = Daysdf.format(new Date());// 当前日期
		String nowtime = sdf.format(new Date());
		String expireTime = getExpireDay(days,Daysdf);		
		if (ship == null) {// 如果是首次成为夺宝会员
			ship = new MemberShip();
			ship.setUserId(order.getUserId());
			ship.setGrowthValue(new Long(0));
			ship.setLevelNum(0);
			ship.setRegisterTime(nowtime);			
			ship.setMemberStatus(new Integer(0));
			ship.setLastFeeTime("");// 上次续费时间
			ship.setIsYearPay(0);
			ship.setIsPay(0);
			ship.setAnnualMemberExpireDate("");
			ship.setMemberExpireDate("");
			ship.setExperienceDate("");//体验过期，才可以赠送
			ship.setExperienceStatus(0);
			ship.setLastExperienceTime("");	
			ship.setDuobaoExpireDate(expireTime);
			ship.setDuobaoStatus(1);
			ship.setLastDuobaoTime(daytime);
			baseDao.insert(ship);
		} else {
			if(ship.getDuobaoStatus() == 1 && DateUtil.compareTime(ship.getDuobaoExpireDate(), daytime)>=0){// 如果之前就是夺宝会员,则过期时间顺延；否则，过期时间为从当天开始的申请天数
				expireTime = getExpireDay(ship.getDuobaoExpireDate(), days,Daysdf);
			}
			ship.setDuobaoStatus(1);
			ship.setLastDuobaoTime(daytime);
			ship.setDuobaoExpireDate(expireTime);
			baseDao.updateById(ship);
		}
		return ship;
	}
	
	private MemberShip updateExperienceMemberInfo(PayOrder order, MemberShip ship
			,SimpleDateFormat sdf,SimpleDateFormat Daysdf) throws Exception {
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		String daytime = Daysdf.format(new Date());// 当前日期
		String nowtime = sdf.format(new Date());
		String expireTime = getExpireDay(days,Daysdf);			
		if (ship == null) {// 如果是首次成为体验会员
			ship = new MemberShip();
			ship.setUserId(order.getUserId());
			ship.setGrowthValue(new Long(0));
			ship.setLevelNum(gradeMap.get(order.getNumValue()));
			ship.setRegisterTime(nowtime);			
			ship.setMemberStatus(new Integer(0));
			ship.setLastFeeTime("");// 上次续费时间
			ship.setIsYearPay(0);
			ship.setIsPay(0);
			ship.setAnnualMemberExpireDate("");
			ship.setMemberExpireDate("");
			ship.setExperienceDate(expireTime);
			ship.setExperienceStatus(1);
			ship.setLastExperienceTime(daytime);
			baseDao.insert(ship);
		} else {// 如果之前就是体验会员
			ship.setLevelNum(gradeMap.get(order.getNumValue()));
			ship.setExperienceDate(expireTime);
			ship.setExperienceStatus(1);
			ship.setLastExperienceTime(daytime);
			baseDao.updateById(ship);
		}
		return ship;
	}
	
	
	/**
	 * 更新金钻会员信息
	 * 
	 * @param order
	 * @param ship
	 * @param isYear
	 * @throws ParseException
	 */
	private MemberShip updateMemberInfo(PayOrder order, MemberShip ship,boolean isBuQi,
			boolean isYear,SimpleDateFormat sdf,SimpleDateFormat Daysdf) throws Exception {
		long days = getMemberDays(order.getTimeType(), order.getNumValue());
		String daytime = Daysdf.format(new Date());// 当前日期
		String nowtime = sdf.format(new Date());
		if (ship == null) {// 如果是首次成为金钻用户
			ship = new MemberShip();
			ship.setUserId(order.getUserId());
			ship.setGrowthValue(new Long(0));
			ship.setLevelNum(1);//获取会员等级
			ship.setRegisterTime(nowtime);
			String expireTime = getExpireDay(days,Daysdf);
			if (isYear) {// 如果是包年
				ship.setIsAnnualMember(new Integer(1));
				ship.setMemberExpireDate(expireTime);
				ship.setAnnualMemberExpireDate(expireTime);
			} else {
				ship.setIsAnnualMember(new Integer(0));
				ship.setMemberExpireDate(expireTime);
				ship.setAnnualMemberExpireDate("");
			}
			ship.setMemberStatus(new Integer(1));
			ship.setLastFeeTime(nowtime);// 上次续费时间
			ship.setIsYearPay(0);
			ship.setExperienceStatus(0);
			if(order.getOrderType().intValue()==1){//判断是否有实际支付
				ship.setIsPay(1);
				if(order.getTimeType().intValue()==3){//如果有一次支付年费的
					ship.setIsYearPay(1);
				}
			}else{
				ship.setIsPay(0);
			}
			baseDao.insert(ship);
		} else {// 如果之前就是金钻会员
			String experienceDate = ship.getExperienceDate();
			if(!StringTools.isEmpty(experienceDate)){//如果开通过体验会员
				ship.setExperienceStatus(0);
				if(DateUtil.compareTime(experienceDate, daytime)>=0){
					ship.setExperienceDate(DateUtil.getYesterayDay());//设置体验会员过期日期为昨天，即可马上失效
				}
			}

			String duobaoExpireDate = ship.getDuobaoExpireDate();
			if(!StringTools.isEmpty(duobaoExpireDate)){//如果开通过体验会员
				ship.setDuobaoStatus(0);
				if(DateUtil.compareTime(duobaoExpireDate, daytime)>=0){
					ship.setDuobaoExpireDate(DateUtil.getYesterayDay());//设置夺宝会员过期日期为昨天，即可马上失效
				}
			}
			if(ship.getLevelNum().intValue()<=-1){//如果之前是体验金钻，需要修改等级
				ship.setLevelNum(1);
				ship.setGrowthValue(0L);
			}
			boolean isyear = DateUtil.compareTime(ship.getAnnualMemberExpireDate(),
					daytime) >= 0 ? true : false;
			if (isyear) {// 如果之前就是年费会员
				String annualMemberExpireDate = getExpireDay(
						ship.getAnnualMemberExpireDate(), days,Daysdf);
				String memberExpireDate = getExpireDay(
						ship.getMemberExpireDate(), days,Daysdf);
				ship.setAnnualMemberExpireDate(annualMemberExpireDate);
				ship.setMemberExpireDate(memberExpireDate);
				ship.setIsAnnualMember(new Integer(1));
			} else {// 如果之前不是年费会员
				boolean ismember = DateUtil.compareTime(ship.getMemberExpireDate(),
						daytime) >= 0 ? true : false;
				if (ismember) {// 如果之前是普通会员
					if (isYear) {// 如果开通了包年
						String annualMemberExpireDate = getExpireDay(daytime,
								days,Daysdf);
						String memberExpireDate = getExpireDay(
								ship.getMemberExpireDate(), days,Daysdf);
						ship.setAnnualMemberExpireDate(annualMemberExpireDate);
						ship.setMemberExpireDate(memberExpireDate);
						ship.setIsAnnualMember(new Integer(1));
					} else {// 如果没有开通包年
						String memberExpireDate = getExpireDay(
								ship.getMemberExpireDate(), days,Daysdf);
						long totaldays = DateUtil.compareTime(memberExpireDate, daytime);
						if(isBuQi){//如果是补齐的情况
							ship.setAnnualMemberExpireDate(memberExpireDate);
							ship.setMemberExpireDate(memberExpireDate);
							ship.setIsAnnualMember(new Integer(1));
						}else{
							if (totaldays - YEARDAYS* 24 * 60 * 60 >= 0) {// 如果满足包年的条件，则自动转换成包年
								ship.setAnnualMemberExpireDate(memberExpireDate);
								ship.setMemberExpireDate(memberExpireDate);
								ship.setIsAnnualMember(new Integer(1));
							} else {// 如果不满足包年的条件
								ship.setMemberExpireDate(memberExpireDate);
								ship.setIsAnnualMember(new Integer(0));
							}
						}
					}
				} else {// 如果之前是到期的普通会员，则按当前时间来算
					if (isYear) {// 如果开通了包年
						String annualMemberExpireDate = getExpireDay(daytime,
								days,Daysdf);
						ship.setAnnualMemberExpireDate(annualMemberExpireDate);
						ship.setMemberExpireDate(annualMemberExpireDate);
						ship.setIsAnnualMember(new Integer(1));
					} else {// 如果没有开通包年
						String annualMemberExpireDate = getExpireDay(daytime,
								days,Daysdf);
						ship.setMemberExpireDate(annualMemberExpireDate);
						ship.setIsAnnualMember(new Integer(0));
					}
				}
			}
			ship.setMemberStatus(new Integer(1));
			ship.setLastFeeTime(nowtime);// 上次续费时间
			if(StringTools.isEmpty(ship.getAnnualMemberExpireDate())){
				ship.setAnnualMemberExpireDate("");
			}
			if(ship.getIsPay().intValue()==0){//如果之前不是支付状态
				if(order.getOrderType().intValue()==1){//判断是否有实际支付
					ship.setIsPay(1);
				}else{
					ship.setIsPay(isPay(ship.getUserId()));
				}
			}			
			if(ship.getIsYearPay().intValue()==0){//如果之前不是年费付费状态
				if(order.getOrderType().intValue()==1){//如果是实际支付
					if(order.getTimeType().intValue()==3){//如果支付的是年费
						ship.setIsYearPay(1);
					}
				}
			}
			baseDao.updateById(ship);
		}
		
		return ship;
	}

	
	private int isPay(long userId){
		PayOrder query = new PayOrder();
		query.setUserId(userId);
		query.setOrderType(1);
		query.setOrderStatus(3);
		int count = baseDao.count(query);
		return count>=1?1:0;
	}


	/**
	 * 获得失效日期
	 * 
	 * @param daytime
	 * @param numValue
	 * @return
	 * @throws ParseException
	 */
	private String getExpireDay(String daytime, long numValue,SimpleDateFormat Daysdf)
			throws ParseException {
		Date date = Daysdf.parse(daytime);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_YEAR, new Long(numValue).intValue());
		return Daysdf.format(cal.getTime());
	}

	private MemberShip firstPay(int timeType, long values,MemberShip ship,long uid,SimpleDateFormat sdf,SimpleDateFormat Daysdf) throws Exception{
	            GrowHistory gh = new GrowHistory();
	    	    gh.setUserId(uid);
	    	    gh.setSourceId(sourceId);
	    	    gh.setGrowType(new Integer(2));
	    	    gh.setRecordTime(sdf.format(new Date()));
	    	    gh.setDayTime(Daysdf.format(new Date()));
	    	    if(timeType==2){//如果充值的是包月
	    	    	if(values >=1 && values < 3){
		        		gh.setGrowValue(new Long(10));
		        	}else if(values >= 3 && values < 6){
		        		gh.setGrowValue(new Long(30));
		        	}else if(values >= 6&& values < 12){
		        		gh.setGrowValue(new Long(50));
		        	}else if(values >= 12){
		        		gh.setGrowValue(new Long(100));
		        	}	        	
	    	    }else if(timeType==3){//如果充值的是包年
	    	    	gh.setGrowValue(new Long(100));
	    	    }else{//如果是日
	    	    	gh.setGrowValue(new Long(1));
	    	    }
	        	return addGrowHistory(gh,ship);//更新金钻信息	      
	}
	
	
	
	/**
	 * 获得失效日期
	 * @param numValue
	 * @return
	 */
	private String getExpireDay(long numValue,SimpleDateFormat Daysdf) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_YEAR, new Long(numValue).intValue());
		return Daysdf.format(cal.getTime());
	}

	/**
	 * 赠送金钻会员
	 */
	@Override
	public void presentPayOrder(PayOrder order,String seqId) throws XLRuntimeException,
			Exception {
	    this.checkLimit(order, seqId);
        this.insert(order);
        this.addPayOrder(order,false,false);
	}
	
	/**
	 * 检查数量是否超过限制
	 * @param order
	 * @param seqId
	 * @throws XLRuntimeException
	 * @throws Exception
	 */
	private void checkLimit(PayOrder order,String seqId) throws XLRuntimeException,Exception {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String sql = "select * from jinzuan_privatekey where seqId=? for update";
        List list = new ArrayList();
        list.add(seqId);
		List<PrivateKey> pklist = baseDao.findBySql(PrivateKey.class, sql, list);
		if(pklist==null||pklist.size()==0){
			throw new XLRuntimeException("业务编号不存在");
		}
		PrivateKey mykey = pklist.get(0);
		PresentLimit presentLimit = null;
		if(mykey.getKeyType().intValue()==2){//如果需要限制数量
			//每月总数量
			if(mykey.getLeftMonthNum().longValue()-1<0){
				throw new XLRuntimeException("超过了每月最大限额");
			}else{
				mykey.setLeftMonthNum(mykey.getLeftMonthNum().longValue()-1);
				baseDao.updateById(mykey);
			}
			String nowDay = DateUtil.getNowDay();
			//每人每日最大数量
			 sql = "select * from jinzuan_present_limit where userId=? and daytime=? for update";
            List paramList = new ArrayList();
            paramList.add(order.getUserId());
            paramList.add(nowDay);
			 List<PresentLimit> plist = baseDao.findBySql(PresentLimit.class, sql, paramList);
			 if(plist!=null&&plist.size()>0){
				 presentLimit = plist.get(0);
				 if(presentLimit.getLeftCount().longValue()-1<0){
					 throw new XLRuntimeException("超过了每人每日最大限额");
				 }else{
					 presentLimit.setLeftCount(presentLimit.getLeftCount().longValue()-1);
					 baseDao.updateById(presentLimit);
				 }
			 }else{
				 String nowtime = sdf.format(new Date());
				 PresentLimit limit = new PresentLimit();
				 limit.setUserId(order.getUserId());
				 limit.setOrderid(order.getOrderId());
				 limit.setDayTime(nowDay);
				 limit.setFirstTime(nowtime);
				 limit.setDailyCount(mykey.getOnePersonMaxNum());
				 limit.setLeftCount(mykey.getOnePersonMaxNum()-1);
				 limit.setLastTime(nowtime);
				 limit.setBizNo(mykey.getBizNo());
				 baseDao.insert(limit);
			 }
		}
	}
	
	/**
	 * 金钻用户的新金钻等级
	 * @param ship
	 * @throws Exception
	 */
	public int getVipGrade(List<Integer> vipGradeList,List<Long>growValueList, MemberShip ship){
		long growthValue = ship.getGrowthValue();
		int vipGrade = 1;
		for(int i=0;i<growValueList.size();i++){
			Long value = growValueList.get(i);
			if(growthValue>=value){
				 vipGrade = vipGradeList.get(i);
				 break;
			}
		}
		return vipGrade;
	}
	
	/**
	 * 增加成长值流水和用户的成长值，在同一个事务中
	 */
	public MemberShip addGrowHistory(GrowHistory gh, MemberShip ship) throws Exception{
		List<Integer> vipgradelist =  VipGradeProxy.getInstance().getVipGradeList();
		List<Long> growvaluelist =  VipGradeProxy.getInstance().getGrowValueList();
		baseDao.insert(gh);//增加成长值流水    	
    	ship.setGrowthValue((ship.getGrowthValue()==null?0:ship.getGrowthValue())+(gh.getGrowValue()==null?0:gh.getGrowValue()));
    	ship.setLevelNum(getVipGrade(vipgradelist,growvaluelist,ship));//更新金钻等级
    	String sql = "update jinzuan_membership set growthValue="+ship.getGrowthValue()+",levelNum="+ship.getLevelNum()+"  where  userId="+ship.getUserId();
    	baseDao.execute(sql, new ArrayList<Object>());//更新金钻用户的成长值   	
    	//baseDao.updateById(ship);
    	return ship;
	}
	
	/**
	 * 签到获得成长值
	 */
	public void signGrowHistory(GrowHistory gh, MemberShip ship,String ip,SimpleDateFormat sdf,SimpleDateFormat Daysdf) throws XLRuntimeException,Exception{
		// 更新签到记录			
		String sql = "select * from jinzuan_signin where userid=?  for update";//增加行锁
        List list = new ArrayList();
        list.add(ship.getUserId());
		List<Signin> signlist =baseDao.findBySql(Signin.class, sql, list);
		if(signlist==null||signlist.size()==0){
			Signin signin = new Signin();
			signin.setUserId(ship.getUserId());
			Date date = new Date();
			signin.setRecordTime(sdf.format(date));
			signin.setLastSignInDate(Daysdf.format(date));
			signin.setTotalSignInCount(new Long(1));
			baseDao.insert(signin);
		}else{
			Signin mysign = signlist.get(0);
			mysign.setLastSignInDate(Daysdf.format(new Date()));
			mysign.setTotalSignInCount(mysign.getTotalSignInCount()+1);
			baseDao.updateById(mysign);
		}
		
		SigninHistory history = new SigninHistory();
		history.setDayTime(Daysdf.format(new Date()));
		int count = baseDao.count(history);//今天已经签到多少人
		
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, -1);
		history.setDayTime(Daysdf.format(cal.getTime()));
		history.setUserId(ship.getUserId());
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		List<SigninHistory> bhlist = baseDao.findByObject(SigninHistory.class, history, page);
		
		SigninHistory newhistory = new SigninHistory();
		newhistory.setUserId(ship.getUserId());
		newhistory.setDayTime(Daysdf.format(new Date()));
		newhistory.setSignInTime(sdf.format(new Date()));
		newhistory.setIp(ip);
		newhistory.setSignIndex(new Long(count+1));
		if(bhlist == null||bhlist.size()==0){//如果前一天没有签到
			newhistory.setIsContinue(true);
			newhistory.setContinueDays(new Long(1));
		}else{//如果前一天有签到，表示有连续签到
			SigninHistory myhistory = bhlist.get(0);
			newhistory.setContinueDays(new Long(myhistory.getContinueDays()+1));
			newhistory.setIsContinue(true);
		}
		baseDao.insert(newhistory);//增加签到流水
				
		List<Integer> vipgradelist =  VipGradeProxy.getInstance().getVipGradeList();
		List<Long> growvaluelist =  VipGradeProxy.getInstance().getGrowValueList();
		baseDao.insert(gh);//增加成长值流水    	
    	ship.setGrowthValue(ship.getGrowthValue()+gh.getGrowValue());
    	ship.setLevelNum(getVipGrade(vipgradelist,growvaluelist,ship));//更新金钻等级
    	baseDao.updateById(ship);//更新金钻用户的成长值 
	}




}
