package com.xunlei.niux.data.jinzuan.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;


public class MemberShipDaoImpl  extends BaseDaoImpl implements MemberShipDao {
	
	private MemberShipDao memberShipDao;
	 	
	public MemberShipDao getMemberShipDao() {
		return memberShipDao;
	}

	public void setMemberShipDao(MemberShipDao memberShipDao) {
		this.memberShipDao = memberShipDao;
	}

	public List<MemberShip> queryMemberShip(long userid) {
	        String sql = "SELECT s2.* FROM jinzuan_membership_test s1 INNER JOIN jinzuan_membership s2\n";
	          sql += " ON s1.userid = s2.userid ";
        Object[] args;
	          if(userid !=0){
	        	  sql += " where s2.userid=? ";
                  args = new Object[]{userid};
	          }else {
                  args = new Object[]{};
              }

	        final List<MemberShip> shipsList = new ArrayList<MemberShip>();

	        getJdbcTemplate().query(sql, args, new RowCallbackHandler() {
	            @Override
	            public void processRow(ResultSet resultSet) throws SQLException {
	            	MemberShip ship = new MemberShip();
	            	ship.setSeqId(resultSet.getLong("seqId"));
	            	ship.setUserId(resultSet.getLong("userId"));
	                ship.setGrowthValue(resultSet.getLong("growthValue"));
	                ship.setLevelNum(resultSet.getInt("levelNum"));
	                ship.setMemberStatus(resultSet.getInt("memberStatus"));
	                ship.setIsAnnualMember(resultSet.getInt("isAnnualMember"));
	                ship.setRegisterTime(resultSet.getString("registerTime"));
	                ship.setLastFeeTime(resultSet.getString("lastFeeTime"));
	                ship.setAnnualMemberExpireDate(resultSet.getString("annualMemberExpireDate"));
	                ship.setMemberExpireDate(resultSet.getString("memberExpireDate"));
	                ship.setIsPay(resultSet.getInt("isPay"));
	                ship.setIsYearPay(resultSet.getInt("isYearPay"));
	                ship.setExperienceDate(resultSet.getString("experienceDate"));
	                ship.setExperienceStatus(resultSet.getInt("experienceStatus"));
	                ship.setDuobaoExpireDate(resultSet.getString("duobaoExpireDate"));
	                ship.setDuobaoStatus(resultSet.getInt("duobaoStatus"));
	                shipsList.add(ship);
	            }
	        });

	        return shipsList;
	    }

}
