/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuan.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.PayOrderBo;
import com.xunlei.niux.data.jinzuan.proxy.VipGradeProxy;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberDetail;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.PresentLimit;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.data.jinzuan.vo.Signin;
import com.xunlei.niux.data.jinzuan.vo.SigninHistory;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class PayOrderBoImpl
implements PayOrderBo {
    private static final int MONTHDAY = 31;
    private static final int YEARMONTH = 12;
    private static final int YEARDAYS = 365;
    private static final String sourceId = "100001";
    private static final int EXPERIENCEMAXDAY = 62;
    private static final Page page = new Page();
    private static Map<Long, Integer> gradeMap;
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void update(PayOrder order) {
        this.baseDao.updateById((Object)order);
    }

    @Override
    public void insert(PayOrder order) throws SQLException {
        this.baseDao.insert((Object)order);
    }

    @Override
    public void cancelOrder(String orderId, long userId) throws XLRuntimeException, Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.cancelMemberShip(orderId, userId, sdf);
    }

    private void cancelMemberShip(String orderId, long userId, SimpleDateFormat sdf) throws XLRuntimeException, Exception {
        boolean ismember;
        long userid = userId;
        MemberShip queryship = new MemberShip();
        queryship.setUserId(userid);
        List shiplist = this.baseDao.findByObject(MemberShip.class, (Object)queryship, page);
        if (shiplist == null || shiplist.size() == 0) {
            throw new XLRuntimeException("\u8be5\u8ba2\u5355\u7684\u4e0b\u5355\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
        }
        MemberShip ship = (MemberShip)shiplist.get(0);
        String daytime = DateUtil.getNowDay();
        boolean bl = ismember = DateUtil.compareTime(ship.getMemberExpireDate(), daytime) >= 0L;
        if (!ismember) {
            throw new XLRuntimeException("\u8be5\u8ba2\u5355\u7684\u4e0b\u5355\u7528\u6237\u5df2\u7ecf\u4e0d\u662f\u91d1\u94bb\u4f1a\u5458");
        }
        MemberDetail detailquery = new MemberDetail();
        detailquery.setUserId(userid);
        Page dqpage = new Page();
        dqpage.addOrder("orderStartDate", OrderType.ESC);
        List mdlist = this.baseDao.findByObject(MemberDetail.class, (Object)detailquery, dqpage);
        MemberDetail nowmd = this.checkMemberDetail(mdlist, orderId);
        MemberDetail beforemd = null;
        for (MemberDetail md : mdlist) {
            if (md.getSeqId() >= nowmd.getSeqId()) continue;
            beforemd = md;
        }
        this.updateMemberShip(ship, beforemd, nowmd);
        this.deleteMemberDetail(nowmd);
        boolean isyear = DateUtil.compareTime(ship.getAnnualMemberExpireDate(), daytime) >= 0L;
        this.addPrivilege(isyear, false, userId, ship.getLevelNum(), sdf);
    }

    private void updateMemberShip(MemberShip ship, MemberDetail beforemd, MemberDetail nowmd) throws Exception {
        if (beforemd == null) {
            ship.setAnnualMemberExpireDate("");
            ship.setIsAnnualMember(0);
            ship.setMemberStatus(0);
            String beforeDay = DateUtil.getNewDay(DateUtil.getNowDay(), 1, false);
            ship.setMemberExpireDate(beforeDay);
        } else {
            int memberStatus = nowmd.getMemberStatus();
            if (memberStatus < 2) {
                boolean isYear;
                String orderDay = nowmd.getOrderTime();
                if (orderDay.length() > 10) {
                    orderDay = orderDay.substring(0, 10);
                }
                if (isYear = this.isChangeYear(nowmd.getOrderEndDate(), orderDay)) {
                    ship.setAnnualMemberExpireDate("");
                    ship.setIsAnnualMember(0);
                    String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum(), false);
                    ship.setMemberExpireDate(memberExpireDate);
                } else {
                    String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum(), false);
                    ship.setMemberExpireDate(memberExpireDate);
                }
            } else {
                String annualMemberExpireDate = DateUtil.getNewDay(ship.getAnnualMemberExpireDate(), nowmd.getDayNum(), false);
                ship.setAnnualMemberExpireDate(annualMemberExpireDate);
                String memberExpireDate = DateUtil.getNewDay(ship.getMemberExpireDate(), nowmd.getDayNum(), false);
                ship.setMemberExpireDate(memberExpireDate);
            }
        }
        this.baseDao.updateById((Object)ship);
    }

    private void deleteMemberDetail(MemberDetail nowmd) {
        this.baseDao.deleteById(MemberDetail.class, (Number)nowmd.getSeqId());
    }

    private MemberDetail checkMemberDetail(List<MemberDetail> mdlist, String orderId) throws XLRuntimeException {
        if (mdlist == null || mdlist.size() == 0) {
            throw new XLRuntimeException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u4efb\u4f55\u8ba2\u5355");
        }
        long seqid = 0L;
        MemberDetail detail = null;
        for (MemberDetail md : mdlist) {
            if (!md.getOrderId().equals(orderId)) continue;
            seqid = md.getSeqId();
            detail = md;
        }
        if (seqid == 0L) {
            throw new XLRuntimeException("\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        for (MemberDetail md : mdlist) {
            if (md.getSeqId() <= seqid) continue;
            throw new XLRuntimeException("\u76ee\u524d\u53ea\u5141\u8bb8\u9000\u8ba2\u6700\u540e\u4e00\u4e2a\u8ba2\u5355");
        }
        return detail;
    }

    public void updatePrivilege(long userid, int levelNum, boolean beforeYear, int status) {
        Page page = new Page();
        Privilege privilegequery = new Privilege();
        privilegequery.setIsAnnual(0);
        privilegequery.setIsvalid(true);
        privilegequery.setLevelNum(levelNum);
        List plist = this.baseDao.findByObject(Privilege.class, (Object)privilegequery, page);
        PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
        query.setUserId(userid);
        List prilist = this.baseDao.findByObject(PrivilegeReceiveInfo.class, (Object)query, page);
        switch (status) {
            case 0: {
                for (PrivilegeReceiveInfo pri : prilist) {
                    pri.setAvailableValue(0L);
                    this.baseDao.updateById((Object)pri);
                }
                break;
            }
            case 1: {
                if (!beforeYear) break;
                for (Privilege p : plist) {
                    for (PrivilegeReceiveInfo pri : prilist) {
                        if (p.getPrivilegeType().intValue() != pri.getPrivilegeType().intValue()) continue;
                        long usedValue = pri.getTotalValue() - pri.getAvailableValue();
                        pri.setTotalValue(p.getValue());
                        pri.setAvailableValue(pri.getTotalValue() - usedValue <= 0L ? 0L : pri.getTotalValue() - usedValue);
                        this.baseDao.updateById((Object)pri);
                    }
                }
                break;
            }
        }
    }

    private MemberDetail resetTime(List<MemberDetail> mdlist) throws Exception {
        MemberDetail detail = mdlist.get(0);
        this.baseDao.deleteById(MemberDetail.class, (Number)detail.getSeqId());
        if (mdlist.size() == 1) {
            return null;
        }
        for (int i = 1; i < mdlist.size(); ++i) {
            this.updateMemberDetail(i - 1, mdlist.get(i - 1), mdlist.get(i));
        }
        return mdlist.get(mdlist.size() - 1);
    }

    private void updateMemberDetail(int index, MemberDetail beforeDetail, MemberDetail nowDetail) throws Exception {
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        int status = beforeDetail.getMemberStatus();
        String orderTime = beforeDetail.getOrderTime();
        if (orderTime.length() > 10) {
            orderTime = orderTime.substring(0, 10);
        }
        String endDate = beforeDetail.getOrderEndDate();
        if (status == 0) {
            nowDetail.setOrderStartDate(beforeDetail.getOrderStartDate());
            String endTime = this.getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum().intValue(), Daysdf);
            nowDetail.setOrderEndDate(endTime);
        } else if (status == 1) {
            if (index == 0) {
                nowDetail.setOrderStartDate(beforeDetail.getOrderStartDate());
            } else {
                nowDetail.setOrderStartDate(beforeDetail.getOrderEndDate());
            }
            String endTime = this.getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum().intValue(), Daysdf);
            nowDetail.setOrderEndDate(endTime);
        } else if (status == 2) {
            nowDetail.setOrderStartDate(endDate);
            String endTime = this.getExpireDay(nowDetail.getOrderStartDate(), nowDetail.getDayNum().intValue(), Daysdf);
            nowDetail.setOrderEndDate(endTime);
        }
        nowDetail.setMemberStatus(status);
        this.baseDao.updateById((Object)nowDetail);
    }

    private boolean isChangeYear(String memberExpireDate, String daytime) throws Exception {
        if (StringTools.isEmpty((String)memberExpireDate)) {
            return false;
        }
        long totaldays = DateUtil.compareTime(memberExpireDate, daytime);
        return totaldays - 31536000L >= 0L;
    }

    @Override
    public void experiencePayOrder(PayOrder order, String seqId) throws XLRuntimeException, Exception {
        try {
            this.insert(order);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
            MemberShip query = new MemberShip();
            query.setUserId(order.getUserId());
            List mslist = this.baseDao.findByObject(MemberShip.class, (Object)query, page);
            MemberShip ship = null;
            if (!CollectionUtils.isEmpty((Collection)mslist)) {
                ship = (MemberShip)mslist.get(0);
                String memberExpireDate = ship.getMemberExpireDate();
                if (!StringTools.isEmpty((String)memberExpireDate)) {
                    throw new XLRuntimeException("\u6b63\u5f0f\u4f1a\u5458\u4e0d\u80fd\u5f00\u901a\u4f53\u9a8c\u4f1a\u5458");
                }
                String experienceDate = ship.getExperienceDate();
                if (!this.checkTime(experienceDate, Daysdf)) {
                    throw new XLRuntimeException("\u4f53\u9a8c\u4f1a\u545862\u5929\u5185\u4e0d\u80fd\u8fde\u7eed\u5f00\u901a");
                }
            }
            this.addExperienceMemberDetail(order, Daysdf);
            ship = this.updateExperienceMemberInfo(order, ship, sdf, Daysdf);
            this.addPrivilege(false, false, order.getUserId(), ship.getLevelNum(), sdf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void duobaoPayOrder(PayOrder order, String seqId) throws XLRuntimeException, Exception {
        String memberExpireDate;
        this.checkLimit(order, seqId);
        this.insert(order);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        MemberShip query = new MemberShip();
        query.setUserId(order.getUserId());
        List mslist = this.baseDao.findByObject(MemberShip.class, (Object)query, page);
        MemberShip ship = null;
        if (!CollectionUtils.isEmpty((Collection)mslist) && !StringTools.isEmpty((String)(memberExpireDate = (ship = (MemberShip)mslist.get(0)).getMemberExpireDate()))) {
            throw new XLRuntimeException("\u6b63\u5f0f\u4f1a\u5458\u4e0d\u80fd\u5f00\u901a\u593a\u5b9d\u4f1a\u5458");
        }
        this.addDuobaoMemberDetail(order, Daysdf);
        ship = this.updateDuobaoMemberInfo(order, ship, sdf, Daysdf);
        this.addPrivilegeDuobao(order.getUserId(), ship, sdf);
        PayOrder q = new PayOrder();
        q.setOrderId(order.getOrderId());
        List myPayOrder = this.baseDao.findByObject(PayOrder.class, (Object)q, new Page());
        if (myPayOrder != null && myPayOrder.size() > 0) {
            q = (PayOrder)myPayOrder.get(0);
            q.setOrderStatus(3);
            this.baseDao.updateById((Object)q);
        }
    }

    private boolean checkTime(String experienceDate, SimpleDateFormat Daysdf) {
        String daytime = Daysdf.format(new Date());
        try {
            Date date1 = Daysdf.parse(daytime);
            Date date2 = Daysdf.parse(experienceDate);
            long data1 = date1.getTime();
            long data2 = date2.getTime();
            return (data1 - data2) / 86400000L > 62L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void addPayOrder(PayOrder order, boolean isupdate, boolean isBuQi) {
        try {
            boolean isYear;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
            PayOrder queryPayOrder = new PayOrder();
            queryPayOrder.setUserId(order.getUserId());
            queryPayOrder.setOrderType(new Integer(1));
            queryPayOrder.setOrderStatus(new Integer(3));
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(1);
            List polist = this.baseDao.findByObject(PayOrder.class, (Object)queryPayOrder, page);
            boolean isFirstPay = false;
            if (polist == null || polist.size() == 0) {
                isFirstPay = true;
            }
            boolean bl = isYear = order.getTimeType() == 3;
            if (isupdate) {
                order.setOrderStatus(new Integer(3));
                order.setFinishTime(sdf.format(new Date()));
                this.baseDao.updateById((Object)order);
            }
            MemberShip queryship = new MemberShip();
            queryship.setUserId(order.getUserId());
            List shiplist = this.baseDao.findByObject(MemberShip.class, (Object)queryship, new Page());
            MemberShip ship = null;
            boolean isExperience = false;
            boolean isDuobao = false;
            if (shiplist != null && shiplist.size() > 0) {
                ship = (MemberShip)shiplist.get(0);
                isDuobao = DateUtil.compareTime(ship.getDuobaoExpireDate(), Daysdf.format(new Date())) >= 0L;
                isExperience = DateUtil.compareTime(ship.getExperienceDate(), Daysdf.format(new Date())) >= 0L ? true : isDuobao;
            }
            this.addMemberDetail(order, ship, Daysdf);
            ship = this.updateMemberInfo(order, ship, isBuQi, isYear, sdf, Daysdf);
            if (isFirstPay && order.getOrderType() == 1) {
                ship = this.firstPay(order.getTimeType(), order.getNumValue(), ship, order.getUserId(), sdf, Daysdf);
            }
            String annualMemberExpireDate = ship.getAnnualMemberExpireDate();
            long data = DateUtil.compareTime(annualMemberExpireDate, Daysdf.format(new Date()));
            boolean realYear = false;
            if (data >= 0L) {
                realYear = true;
            }
            this.addPrivilege(realYear, isExperience, order.getUserId(), ship.getLevelNum(), sdf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addPrivilege(boolean realYear, boolean isExperience, long uid, int vipgrade, SimpleDateFormat sdf) throws Exception {
        Page page = new Page();
        Privilege query = new Privilege();
        query.setIsAnnual(realYear ? 1 : 0);
        query.setIsvalid(true);
        query.setLevelNum(vipgrade);
        List plist = this.baseDao.findByObject(Privilege.class, (Object)query, page);
        if (plist == null || plist.size() == 0) {
            return;
        }
        String nowtime = sdf.format(new Date());
        String month = nowtime.split(" ")[0].substring(0, 7);
        PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
        queryinfo.setUserId(uid);
        queryinfo.setYearMonth(month);
        List prinfolist = this.baseDao.findByObject(PrivilegeReceiveInfo.class, (Object)queryinfo, page);
        for (Privilege p : plist) {
            int ptype = p.getPrivilegeType();
            boolean flag = false;
            for (PrivilegeReceiveInfo pri : prinfolist) {
                if (ptype != pri.getPrivilegeType()) continue;
                flag = true;
                if (isExperience) {
                    pri.setAvailableValue(p.getValue());
                } else {
                    pri.setAvailableValue(p.getValue() - (pri.getTotalValue() - pri.getAvailableValue()));
                }
                pri.setTotalValue(p.getValue());
                this.baseDao.updateById((Object)pri);
                break;
            }
            if (flag) continue;
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(uid);
            info.setYearMonth(month);
            info.setPrivilegeType(p.getPrivilegeType());
            info.setRecordTime(sdf.format(new Date()));
            info.setTotalValue(p.getValue());
            info.setAvailableValue(p.getValue());
            info.setIsvalid(true);
            info.setSimpleName(p.getSimpleName());
            this.baseDao.insert((Object)info);
        }
    }

    private void addPrivilegeDuobao(long uid, MemberShip ship, SimpleDateFormat sdf) throws Exception {
        Page page = new Page();
        Privilege query = new Privilege();
        query.setIsAnnual(0);
        query.setIsvalid(true);
        query.setLevelNum(1);
        List plist = this.baseDao.findByObject(Privilege.class, (Object)query, page);
        if (plist == null || plist.size() == 0) {
            return;
        }
        Iterator iter = plist.iterator();
        while (iter.hasNext()) {
            Privilege pri = (Privilege)iter.next();
            if (pri.getPrivilegeType() == 1) continue;
            iter.remove();
        }
        String nowtime = ship.getDuobaoExpireDate();
        String month = nowtime.split(" ")[0].substring(0, 7);
        PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
        queryinfo.setUserId(uid);
        queryinfo.setYearMonth(month);
        List prinfolist = this.baseDao.findByObject(PrivilegeReceiveInfo.class, (Object)queryinfo, page);
        for (Privilege p : plist) {
            int ptype = p.getPrivilegeType();
            boolean flag = false;
            for (PrivilegeReceiveInfo pri : prinfolist) {
                if (ptype != pri.getPrivilegeType()) continue;
                flag = true;
                pri.setAvailableValue(p.getValue() - (pri.getTotalValue() - pri.getAvailableValue()));
                pri.setTotalValue(p.getValue());
                this.baseDao.updateById((Object)pri);
                break;
            }
            if (flag) continue;
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(uid);
            info.setYearMonth(month);
            info.setPrivilegeType(p.getPrivilegeType());
            info.setRecordTime(sdf.format(new Date()));
            info.setTotalValue(p.getValue());
            info.setAvailableValue(p.getValue());
            info.setIsvalid(true);
            info.setSimpleName(p.getSimpleName());
            this.baseDao.insert((Object)info);
        }
    }

    private void addDuobaoMemberDetail(PayOrder order, SimpleDateFormat Daysdf) throws Exception {
        Date date = new Date();
        String daytime = Daysdf.format(date);
        MemberDetail detail = new MemberDetail();
        detail.setActNo(order.getActNo());
        detail.setOrderId(order.getOrderId());
        detail.setUserId(order.getUserId());
        detail.setOrderTime(order.getFinishTime());
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        detail.setDayNum(new Long(days).intValue());
        Page page = new Page();
        MemberDetail query = new MemberDetail();
        query.setUserId(order.getUserId());
        query.setDuobaoStatus(1);
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("orderEndDate", OrderType.DESC);
        List mdlist = this.baseDao.findByObject(MemberDetail.class, (Object)query, page);
        if (mdlist == null || mdlist.size() == 0) {
            detail.setOrderStartDate(daytime);
            String endtime = this.getExpireDay(daytime, days, Daysdf);
            detail.setOrderEndDate(endtime);
            detail.setMemberStatus(0);
            detail.setDuobaoStatus(1);
        } else {
            MemberDetail md = (MemberDetail)mdlist.get(0);
            String orderEndDate = md.getOrderEndDate();
            detail.setMemberStatus(0);
            detail.setDuobaoStatus(1);
            detail.setOrderStartDate(daytime);
            if (DateUtil.compareTime(daytime, orderEndDate) > 0L) {
                detail.setOrderStartDate(daytime);
                String endtime = this.getExpireDay(daytime, days, Daysdf);
                detail.setOrderEndDate(endtime);
            } else {
                detail.setOrderStartDate(this.getExpireDay(orderEndDate, 0L, Daysdf));
                String endtime = this.getExpireDay(orderEndDate, days, Daysdf);
                detail.setOrderEndDate(endtime);
            }
        }
        this.baseDao.insert((Object)detail);
    }

    private void addExperienceMemberDetail(PayOrder order, SimpleDateFormat Daysdf) throws Exception {
        Date date = new Date();
        String daytime = Daysdf.format(date);
        MemberDetail detail = new MemberDetail();
        detail.setActNo(order.getActNo());
        detail.setOrderId(order.getOrderId());
        detail.setUserId(order.getUserId());
        detail.setOrderTime(order.getFinishTime());
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        detail.setDayNum(new Long(days).intValue());
        Page page = new Page();
        MemberDetail query = new MemberDetail();
        query.setUserId(order.getUserId());
        query.setDuobaoStatus(0);
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("orderEndDate", OrderType.DESC);
        List mdlist = this.baseDao.findByObject(MemberDetail.class, (Object)query, page);
        if (mdlist == null || mdlist.size() == 0) {
            detail.setOrderStartDate(daytime);
            String endtime = this.getExpireDay(daytime, days, Daysdf);
            detail.setOrderEndDate(endtime);
            detail.setMemberStatus(0);
        } else {
            MemberDetail md = (MemberDetail)mdlist.get(0);
            String orderEndDate = md.getOrderEndDate();
            detail.setMemberStatus(0);
            detail.setOrderStartDate(daytime);
            String endtime = this.getExpireDay(daytime, days, Daysdf);
            detail.setOrderEndDate(endtime);
            if (DateUtil.compareTime(daytime, orderEndDate) <= 0L) {
                md.setOrderEndDate(DateUtil.getYesterayDay());
                this.baseDao.updateById((Object)md);
            }
        }
        this.baseDao.insert((Object)detail);
    }

    private void addMemberDetail(PayOrder order, MemberShip ship, SimpleDateFormat Daysdf) throws Exception {
        boolean beforeYearStatus = false;
        boolean beforeMemberStatus = false;
        if (ship != null) {
            if (DateUtil.compareTime(ship.getAnnualMemberExpireDate(), Daysdf.format(new Date())) > 0L) {
                beforeYearStatus = true;
            }
            if (DateUtil.compareTime(ship.getMemberExpireDate(), Daysdf.format(new Date())) > 0L) {
                beforeMemberStatus = true;
            }
        }
        Date date = new Date();
        String daytime = Daysdf.format(date);
        MemberDetail detail = new MemberDetail();
        detail.setActNo(order.getActNo());
        detail.setOrderId(order.getOrderId());
        detail.setUserId(order.getUserId());
        detail.setOrderTime(order.getFinishTime());
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        detail.setDayNum(new Long(days).intValue());
        Page page = new Page();
        MemberDetail query = new MemberDetail();
        query.setUserId(order.getUserId());
        query.setDuobaoStatus(0);
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("orderEndDate", OrderType.DESC);
        List mdlist = this.baseDao.findByObject(MemberDetail.class, (Object)query, page);
        if (mdlist == null || mdlist.size() == 0) {
            detail.setOrderStartDate(daytime);
            String endtime = this.getExpireDay(daytime, days, Daysdf);
            detail.setOrderEndDate(endtime);
            detail.setMemberStatus(0);
        } else {
            MemberDetail md = (MemberDetail)mdlist.get(0);
            String orderEndDate = md.getOrderEndDate();
            int status = 0;
            if (beforeYearStatus) {
                status = 2;
            } else if (beforeMemberStatus) {
                status = 1;
            }
            detail.setMemberStatus(status);
            if (DateUtil.compareTime(daytime, orderEndDate) > 0L) {
                detail.setOrderStartDate(daytime);
                String endtime = this.getExpireDay(daytime, days, Daysdf);
                detail.setOrderEndDate(endtime);
            } else {
                detail.setOrderStartDate(this.getExpireDay(orderEndDate, 0L, Daysdf));
                String endtime = this.getExpireDay(orderEndDate, days, Daysdf);
                detail.setOrderEndDate(endtime);
            }
        }
        this.baseDao.insert((Object)detail);
    }

    private long getMemberDays(int timeType, long numValue) {
        long days = 0L;
        switch (timeType) {
            case 1: {
                days = numValue;
                break;
            }
            case 2: {
                days = numValue * 31L;
                break;
            }
            case 3: {
                days = numValue * 31L * 12L;
            }
        }
        return days;
    }

    private MemberShip updateDuobaoMemberInfo(PayOrder order, MemberShip ship, SimpleDateFormat sdf, SimpleDateFormat Daysdf) throws Exception {
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        String daytime = Daysdf.format(new Date());
        String nowtime = sdf.format(new Date());
        String expireTime = this.getExpireDay(days, Daysdf);
        if (ship == null) {
            ship = new MemberShip();
            ship.setUserId(order.getUserId());
            ship.setGrowthValue(new Long(0L));
            ship.setLevelNum(0);
            ship.setRegisterTime(nowtime);
            ship.setMemberStatus(new Integer(0));
            ship.setLastFeeTime("");
            ship.setIsYearPay(0);
            ship.setIsPay(0);
            ship.setAnnualMemberExpireDate("");
            ship.setMemberExpireDate("");
            ship.setExperienceDate(DateUtil.getYesterayDay());
            ship.setExperienceStatus(0);
            ship.setLastExperienceTime("");
            ship.setDuobaoExpireDate(expireTime);
            ship.setDuobaoStatus(1);
            ship.setLastDuobaoTime(daytime);
            this.baseDao.insert((Object)ship);
        } else {
            if (ship.getDuobaoStatus() == 1) {
                expireTime = this.getExpireDay(ship.getDuobaoExpireDate(), days, Daysdf);
            }
            ship.setDuobaoStatus(1);
            ship.setLastDuobaoTime(daytime);
            ship.setDuobaoExpireDate(expireTime);
            this.baseDao.updateById((Object)ship);
        }
        return ship;
    }

    private MemberShip updateExperienceMemberInfo(PayOrder order, MemberShip ship, SimpleDateFormat sdf, SimpleDateFormat Daysdf) throws Exception {
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        String daytime = Daysdf.format(new Date());
        String nowtime = sdf.format(new Date());
        String expireTime = this.getExpireDay(days, Daysdf);
        if (ship == null) {
            ship = new MemberShip();
            ship.setUserId(order.getUserId());
            ship.setGrowthValue(new Long(0L));
            ship.setLevelNum(gradeMap.get(order.getNumValue()));
            ship.setRegisterTime(nowtime);
            ship.setMemberStatus(new Integer(0));
            ship.setLastFeeTime("");
            ship.setIsYearPay(0);
            ship.setIsPay(0);
            ship.setAnnualMemberExpireDate("");
            ship.setMemberExpireDate("");
            ship.setExperienceDate(expireTime);
            ship.setExperienceStatus(1);
            ship.setLastExperienceTime(daytime);
            this.baseDao.insert((Object)ship);
        } else {
            ship.setLevelNum(gradeMap.get(order.getNumValue()));
            ship.setExperienceDate(expireTime);
            ship.setExperienceStatus(1);
            ship.setLastExperienceTime(daytime);
            this.baseDao.updateById((Object)ship);
        }
        return ship;
    }

    private MemberShip updateMemberInfo(PayOrder order, MemberShip ship, boolean isBuQi, boolean isYear, SimpleDateFormat sdf, SimpleDateFormat Daysdf) throws Exception {
        long days = this.getMemberDays(order.getTimeType(), order.getNumValue());
        String daytime = Daysdf.format(new Date());
        String nowtime = sdf.format(new Date());
        if (ship == null) {
            ship = new MemberShip();
            ship.setUserId(order.getUserId());
            ship.setGrowthValue(new Long(0L));
            ship.setLevelNum(1);
            ship.setRegisterTime(nowtime);
            String expireTime = this.getExpireDay(days, Daysdf);
            if (isYear) {
                ship.setIsAnnualMember(new Integer(1));
                ship.setMemberExpireDate(expireTime);
                ship.setAnnualMemberExpireDate(expireTime);
            } else {
                ship.setIsAnnualMember(new Integer(0));
                ship.setMemberExpireDate(expireTime);
                ship.setAnnualMemberExpireDate("");
            }
            ship.setMemberStatus(new Integer(1));
            ship.setLastFeeTime(nowtime);
            ship.setIsYearPay(0);
            ship.setExperienceStatus(0);
            if (order.getOrderType() == 1) {
                ship.setIsPay(1);
                if (order.getTimeType() == 3) {
                    ship.setIsYearPay(1);
                }
            } else {
                ship.setIsPay(0);
            }
            this.baseDao.insert((Object)ship);
        } else {
            boolean isyear;
            String duobaoExpireDate;
            String experienceDate = ship.getExperienceDate();
            if (!StringTools.isEmpty((String)experienceDate)) {
                ship.setExperienceStatus(0);
                if (DateUtil.compareTime(experienceDate, daytime) >= 0L) {
                    ship.setExperienceDate(DateUtil.getYesterayDay());
                }
            }
            if (!StringTools.isEmpty((String)(duobaoExpireDate = ship.getDuobaoExpireDate()))) {
                ship.setDuobaoStatus(0);
                if (DateUtil.compareTime(duobaoExpireDate, daytime) >= 0L) {
                    ship.setDuobaoExpireDate(DateUtil.getYesterayDay());
                }
            }
            if (ship.getLevelNum() <= -1) {
                ship.setLevelNum(1);
                ship.setGrowthValue(0L);
            }
            boolean bl = isyear = DateUtil.compareTime(ship.getAnnualMemberExpireDate(), daytime) >= 0L;
            if (isyear) {
                String annualMemberExpireDate = this.getExpireDay(ship.getAnnualMemberExpireDate(), days, Daysdf);
                String memberExpireDate = this.getExpireDay(ship.getMemberExpireDate(), days, Daysdf);
                ship.setAnnualMemberExpireDate(annualMemberExpireDate);
                ship.setMemberExpireDate(memberExpireDate);
                ship.setIsAnnualMember(new Integer(1));
            } else {
                boolean ismember;
                boolean bl2 = ismember = DateUtil.compareTime(ship.getMemberExpireDate(), daytime) >= 0L;
                if (ismember) {
                    if (isYear) {
                        String annualMemberExpireDate = this.getExpireDay(daytime, days, Daysdf);
                        String memberExpireDate = this.getExpireDay(ship.getMemberExpireDate(), days, Daysdf);
                        ship.setAnnualMemberExpireDate(annualMemberExpireDate);
                        ship.setMemberExpireDate(memberExpireDate);
                        ship.setIsAnnualMember(new Integer(1));
                    } else {
                        String memberExpireDate = this.getExpireDay(ship.getMemberExpireDate(), days, Daysdf);
                        long totaldays = DateUtil.compareTime(memberExpireDate, daytime);
                        if (isBuQi) {
                            ship.setAnnualMemberExpireDate(memberExpireDate);
                            ship.setMemberExpireDate(memberExpireDate);
                            ship.setIsAnnualMember(new Integer(1));
                        } else if (totaldays - 31536000L >= 0L) {
                            ship.setAnnualMemberExpireDate(memberExpireDate);
                            ship.setMemberExpireDate(memberExpireDate);
                            ship.setIsAnnualMember(new Integer(1));
                        } else {
                            ship.setMemberExpireDate(memberExpireDate);
                            ship.setIsAnnualMember(new Integer(0));
                        }
                    }
                } else if (isYear) {
                    String annualMemberExpireDate = this.getExpireDay(daytime, days, Daysdf);
                    ship.setAnnualMemberExpireDate(annualMemberExpireDate);
                    ship.setMemberExpireDate(annualMemberExpireDate);
                    ship.setIsAnnualMember(new Integer(1));
                } else {
                    String annualMemberExpireDate = this.getExpireDay(daytime, days, Daysdf);
                    ship.setMemberExpireDate(annualMemberExpireDate);
                    ship.setIsAnnualMember(new Integer(0));
                }
            }
            ship.setMemberStatus(new Integer(1));
            ship.setLastFeeTime(nowtime);
            if (StringTools.isEmpty((String)ship.getAnnualMemberExpireDate())) {
                ship.setAnnualMemberExpireDate("");
            }
            if (ship.getIsPay() == 0) {
                if (order.getOrderType() == 1) {
                    ship.setIsPay(1);
                } else {
                    ship.setIsPay(this.isPay(ship.getUserId()));
                }
            }
            if (ship.getIsYearPay() == 0 && order.getOrderType() == 1 && order.getTimeType() == 3) {
                ship.setIsYearPay(1);
            }
            this.baseDao.updateById((Object)ship);
        }
        return ship;
    }

    private int isPay(long userId) {
        PayOrder query = new PayOrder();
        query.setUserId(userId);
        query.setOrderType(1);
        query.setOrderStatus(3);
        int count = this.baseDao.count((Object)query);
        return count >= 1 ? 1 : 0;
    }

    private String getExpireDay(String daytime, long numValue, SimpleDateFormat Daysdf) throws ParseException {
        Date date = Daysdf.parse(daytime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, new Long(numValue).intValue());
        return Daysdf.format(cal.getTime());
    }

    private MemberShip firstPay(int timeType, long values, MemberShip ship, long uid, SimpleDateFormat sdf, SimpleDateFormat Daysdf) throws Exception {
        GrowHistory gh = new GrowHistory();
        gh.setUserId(uid);
        gh.setSourceId(sourceId);
        gh.setGrowType(new Integer(2));
        gh.setRecordTime(sdf.format(new Date()));
        gh.setDayTime(Daysdf.format(new Date()));
        if (timeType == 2) {
            if (values >= 1L && values < 3L) {
                gh.setGrowValue(new Long(10L));
            } else if (values >= 3L && values < 6L) {
                gh.setGrowValue(new Long(30L));
            } else if (values >= 6L && values < 12L) {
                gh.setGrowValue(new Long(50L));
            } else if (values >= 12L) {
                gh.setGrowValue(new Long(100L));
            }
        } else if (timeType == 3) {
            gh.setGrowValue(new Long(100L));
        } else {
            gh.setGrowValue(new Long(1L));
        }
        return this.addGrowHistory(gh, ship);
    }

    private String getExpireDay(long numValue, SimpleDateFormat Daysdf) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, new Long(numValue).intValue());
        return Daysdf.format(cal.getTime());
    }

    @Override
    public void presentPayOrder(PayOrder order, String seqId) throws XLRuntimeException, Exception {
        this.checkLimit(order, seqId);
        this.insert(order);
        this.addPayOrder(order, false, false);
    }

    private void checkLimit(PayOrder order, String seqId) throws XLRuntimeException, Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = "select * from jinzuan_privatekey where seqId=? for update";
        ArrayList<String> list = new ArrayList<String>();
        list.add(seqId);
        List pklist = this.baseDao.findBySql(PrivateKey.class, sql, list);
        if (pklist == null || pklist.size() == 0) {
            throw new XLRuntimeException("\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        PrivateKey mykey = (PrivateKey)pklist.get(0);
        PresentLimit presentLimit = null;
        if (mykey.getKeyType() == 2) {
            if (mykey.getLeftMonthNum() - 1L < 0L) {
                throw new XLRuntimeException("\u8d85\u8fc7\u4e86\u6bcf\u6708\u6700\u5927\u9650\u989d");
            }
            mykey.setLeftMonthNum(mykey.getLeftMonthNum() - 1L);
            this.baseDao.updateById((Object)mykey);
            String nowDay = DateUtil.getNowDay();
            sql = "select * from jinzuan_present_limit where userId=? and daytime=? for update";
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(order.getUserId());
            paramList.add(nowDay);
            List plist = this.baseDao.findBySql(PresentLimit.class, sql, paramList);
            if (plist != null && plist.size() > 0) {
                presentLimit = (PresentLimit)plist.get(0);
                if (presentLimit.getLeftCount() - 1L < 0L) {
                    throw new XLRuntimeException("\u8d85\u8fc7\u4e86\u6bcf\u4eba\u6bcf\u65e5\u6700\u5927\u9650\u989d");
                }
                presentLimit.setLeftCount(presentLimit.getLeftCount() - 1L);
                this.baseDao.updateById((Object)presentLimit);
            } else {
                String nowtime = sdf.format(new Date());
                PresentLimit limit = new PresentLimit();
                limit.setUserId(order.getUserId());
                limit.setOrderid(order.getOrderId());
                limit.setDayTime(nowDay);
                limit.setFirstTime(nowtime);
                limit.setDailyCount(mykey.getOnePersonMaxNum());
                limit.setLeftCount(mykey.getOnePersonMaxNum() - 1L);
                limit.setLastTime(nowtime);
                limit.setBizNo(mykey.getBizNo());
                this.baseDao.insert((Object)limit);
            }
        }
    }

    public int getVipGrade(List<Integer> vipGradeList, List<Long> growValueList, MemberShip ship) {
        long growthValue = ship.getGrowthValue();
        int vipGrade = 1;
        for (int i = 0; i < growValueList.size(); ++i) {
            Long value = growValueList.get(i);
            if (growthValue < value) continue;
            vipGrade = vipGradeList.get(i);
            break;
        }
        return vipGrade;
    }

    public MemberShip addGrowHistory(GrowHistory gh, MemberShip ship) throws Exception {
        ArrayList<Integer> vipgradelist = VipGradeProxy.getInstance().getVipGradeList();
        ArrayList<Long> growvaluelist = VipGradeProxy.getInstance().getGrowValueList();
        this.baseDao.insert((Object)gh);
        ship.setGrowthValue((ship.getGrowthValue() == null ? 0L : ship.getGrowthValue()) + (gh.getGrowValue() == null ? 0L : gh.getGrowValue()));
        ship.setLevelNum(this.getVipGrade(vipgradelist, growvaluelist, ship));
        String sql = "update jinzuan_membership set growthValue=" + ship.getGrowthValue() + ",levelNum=" + ship.getLevelNum() + "  where  userId=" + ship.getUserId();
        this.baseDao.execute(sql, new ArrayList());
        return ship;
    }

    public void signGrowHistory(GrowHistory gh, MemberShip ship, String ip, SimpleDateFormat sdf, SimpleDateFormat Daysdf) throws XLRuntimeException, Exception {
        String sql = "select * from jinzuan_signin where userid=?  for update";
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ship.getUserId());
        List signlist = this.baseDao.findBySql(Signin.class, sql, list);
        if (signlist == null || signlist.size() == 0) {
            Signin signin = new Signin();
            signin.setUserId(ship.getUserId());
            Date date = new Date();
            signin.setRecordTime(sdf.format(date));
            signin.setLastSignInDate(Daysdf.format(date));
            signin.setTotalSignInCount(new Long(1L));
            this.baseDao.insert((Object)signin);
        } else {
            Signin mysign = (Signin)signlist.get(0);
            mysign.setLastSignInDate(Daysdf.format(new Date()));
            mysign.setTotalSignInCount(mysign.getTotalSignInCount() + 1L);
            this.baseDao.updateById((Object)mysign);
        }
        SigninHistory history = new SigninHistory();
        history.setDayTime(Daysdf.format(new Date()));
        int count = this.baseDao.count((Object)history);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        history.setDayTime(Daysdf.format(cal.getTime()));
        history.setUserId(ship.getUserId());
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List bhlist = this.baseDao.findByObject(SigninHistory.class, (Object)history, page);
        SigninHistory newhistory = new SigninHistory();
        newhistory.setUserId(ship.getUserId());
        newhistory.setDayTime(Daysdf.format(new Date()));
        newhistory.setSignInTime(sdf.format(new Date()));
        newhistory.setIp(ip);
        newhistory.setSignIndex(new Long(count + 1));
        if (bhlist == null || bhlist.size() == 0) {
            newhistory.setIsContinue(true);
            newhistory.setContinueDays(new Long(1L));
        } else {
            SigninHistory myhistory = (SigninHistory)bhlist.get(0);
            newhistory.setContinueDays(new Long(myhistory.getContinueDays() + 1L));
            newhistory.setIsContinue(true);
        }
        this.baseDao.insert((Object)newhistory);
        ArrayList<Integer> vipgradelist = VipGradeProxy.getInstance().getVipGradeList();
        ArrayList<Long> growvaluelist = VipGradeProxy.getInstance().getGrowValueList();
        this.baseDao.insert((Object)gh);
        ship.setGrowthValue(ship.getGrowthValue() + gh.getGrowValue());
        ship.setLevelNum(this.getVipGrade(vipgradelist, growvaluelist, ship));
        this.baseDao.updateById((Object)ship);
    }

    static {
        if (gradeMap == null) {
            gradeMap = new HashMap<Long, Integer>();
            gradeMap.put(1L, -1);
            gradeMap.put(3L, -2);
            gradeMap.put(7L, -3);
        }
    }
}

