package com.xunlei.niux.data.jinzuan.proxy;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;

public class VipGradeProxy {
	private  ArrayList<Integer> vipGradeList = null;
	private  ArrayList<Long> growValueList = null;
	
	private static final VipGradeProxy instance = new VipGradeProxy();
	private VipGradeProxy(){
		init();
	}

	private void init(){
		if(vipGradeList == null){
			vipGradeList = new ArrayList<Integer>();
			growValueList = new ArrayList<Long>();
			Level query = new Level();
			Page page = new Page();
			page.addOrder("levelNum", OrderType.DESC);//按照等级逆序
			List<Level> levelist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
			for(Level mylevel:levelist){
				vipGradeList.add(mylevel.getLevelNum());
				growValueList.add(mylevel.getLevelNeedValue());
			}
		}		
	}
	public static VipGradeProxy getInstance(){
		return instance ;
	}
	
	public  ArrayList<Integer> getVipGradeList(){
		return vipGradeList;
	}
	
	public  ArrayList<Long> getGrowValueList(){
		return growValueList;
	}
}
