package com.xunlei.niux.data.jinzuan.bo;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveHistory;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;


public class PrivilegeReceiveInfoBoImpl implements PrivilegeReceiveInfoBo {

    private static final Page page = new Page();
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public void update(PrivilegeReceiveInfo info){
		 baseDao.updateById(info);
	}
	public void insert(PrivilegeReceiveInfo info) {
		baseDao.insert(info);
	}
	
	/**
	 * 金钻用户使用特权，减少剩余数量
	 */
	@Override
	public void addPrivilegeReceiveInfo(PrivilegeReceiveInfo info)
			throws XLRuntimeException, Exception {
		SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		int privilegeType = info.getPrivilegeType();
		long uid = info.getUserId();		
		long amount = info.getTotalValue();//使用数量
		String month = info.getYearMonth();//年月的特权
		StringBuffer sql = new StringBuffer("select * from jinzuan_privilegereceiveinfo where privilegeType=")
		.append(privilegeType).append("  and userId=").append(uid).append("  and  yearMonth='").append(month).append("'").append("   for update");	
		List<PrivilegeReceiveInfo> prilist = baseDao.executeQuery(PrivilegeReceiveInfo.class, sql.toString(), new ArrayList());
		if(prilist == null||prilist.size()==0){
			throw new XLRuntimeException("您不存在该特权");
		}else{
			PrivilegeReceiveInfo pri = prilist.get(0);
			long availableValue = pri.getAvailableValue();//剩余可使用量
			if(availableValue-amount<0){
				throw new XLRuntimeException("您该项特权的剩余可使用数不足");
			}
			pri.setAvailableValue(availableValue-amount);
			baseDao.updateById(pri);
			
			PrivilegeReceiveHistory history = new PrivilegeReceiveHistory();
			history.setPrivilegeType(privilegeType);
			history.setRecordTime(sdfhms.format(new Date()));
			history.setUsedValue(amount);
			history.setUserId(uid);
			baseDao.insert(history);
		}		
	}
	@Override
	public void updatePrivilege(long userid,boolean flag) {
		 SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		 SimpleDateFormat monthhms = new SimpleDateFormat("yyyy-MM");
	     String sql = "select * from jinzuan_membership where memberExpireDate >= DATE_SUB(CURDATE(),INTERVAL 1 DAY) and  userId="+userid;
	     List<MemberShip> mslist = baseDao.executeQuery(MemberShip.class, sql, new ArrayList());
	     Calendar cal = Calendar.getInstance();
	     String month = null;
	     if(flag){//是否需要提前分配下个月的特权
	    	 cal.add(Calendar.MONTH, 1);
	    	 month = monthhms.format(cal.getTime());
	     }else{
	    	 month = monthhms.format(new Date()); 
	     }	    
		 if(mslist != null&& mslist.size()>0){//如果是会员
			 MemberShip ship = mslist.get(0);
			Privilege query = new Privilege();
			query.setIsAnnual(ship.getIsAnnualMember());
			query.setIsvalid(true);//有效的特权
			query.setLevelNum(ship.getLevelNum());//金钻等级
			List<Privilege> plist =baseDao.findByObject(Privilege.class, query, new Page());
			
			String nowtime = sdfhms.format(new Date());
    		//String month = nowtime.split(" ")[0].substring(0,7);
    		PrivilegeReceiveInfo priquery = new PrivilegeReceiveInfo();
    		priquery.setUserId(userid);
    		priquery.setYearMonth(month);
    		List<PrivilegeReceiveInfo> list = baseDao.findByObject(PrivilegeReceiveInfo.class, priquery,page);
    		if(list != null&&list.size()>0)return;//如果本月已经分配过特权了，则不需要再分配
			for(Privilege priv:plist){
				PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        		info.setUserId(userid);       		
        		info.setYearMonth(month);
        		info.setPrivilegeType(priv.getPrivilegeType());
        		info.setRecordTime(nowtime);
        		info.setTotalValue(priv.getValue());
        		info.setAvailableValue(priv.getValue());
        		info.setIsvalid(true);//获得有效的特权
        		info.setSimpleName(priv.getSimpleName());
        		baseDao.insert(info);
			}
		 }
	}   
	
	
}
