package com.xunlei.niux.data.jinzuan.bo;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.proxy.BonusCache;
import com.xunlei.niux.data.jinzuan.proxy.VipGradeProxy;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.CommonData;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.data.jinzuan.vo.Signin;
import com.xunlei.niux.data.jinzuan.vo.SigninHistory;



public class GrowHistoryBoImpl implements GrowHistoryBo {

	
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public void update(GrowHistory history){
		 baseDao.updateById(history);
	}
	public void insert(GrowHistory history) {
		baseDao.insert(history);
	}
	
	/**
	 * 金钻用户的新金钻等级
	 * @param ship
	 * @throws Exception
	 */
	public int getVipGrade(List<Integer> vipGradeList,List<Long>growValueList, MemberShip ship){
		long growthValue = ship.getGrowthValue();
		int vipGrade = 1;
		for(int i=0;i<growValueList.size();i++){
			Long value = growValueList.get(i);
			if(growthValue>=value){
				 vipGrade = vipGradeList.get(i);
				 break;
			}
		}
		return vipGrade;
	}
	
	/**
	 * 增加成长值流水和用户的成长值，在同一个事务中
	 */
	@Override
	public void addGrowHistory(GrowHistory gh, MemberShip ship) throws Exception {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String nowDay =  sdf.format(new Date());
		List<Integer> vipgradelist =  VipGradeProxy.getInstance().getVipGradeList();
		List<Long> growvaluelist =  VipGradeProxy.getInstance().getGrowValueList();
		insert(gh);//增加成长值流水    	
    	ship.setGrowthValue((ship.getGrowthValue()==null?0:ship.getGrowthValue())+(gh.getGrowValue()==null?0:gh.getGrowValue()));
    	ship.setLevelNum(getVipGrade(vipgradelist,growvaluelist,ship));//更新金钻等级
    	String sql = "update jinzuan_membership set growthValue="+ship.getGrowthValue()+",levelNum="+ship.getLevelNum()+"  where  userId="+ship.getUserId();
    	baseDao.execute(sql, new ArrayList<Object>());//更新金钻用户的成长值   	
    	//重新计算特权信息
    	String annualMemberExpireDate =  ship.getAnnualMemberExpireDate();			
        long data =  DateUtil.compareTime(annualMemberExpireDate,nowDay);
		boolean realYear = false;//真实的年费状态
		if(data >= 0){
			realYear = true;
		}
		addPrivilege(realYear,ship.getUserId(),ship.getLevelNum(),nowDay);
	}
	
	
	/**
	 * 签到获得成长值
	 */
	public void signGrowHistory(GrowHistory gh, MemberShip ship,String ip,String daytime) throws XLRuntimeException,Exception{
		 SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		 String nowTime = sdfhms.format(new Date());
		 String nowDay = nowTime.split(" ")[0];
		// 更新签到记录			
		String sql = "select * from jinzuan_signin where userid='"+ship.getUserId()+"'  for update";//增加行锁 
		List<Signin> signlist =baseDao.findBySql(Signin.class, sql, new ArrayList());
		if(signlist==null||signlist.size()==0){
			Signin signin = new Signin();
			signin.setUserId(ship.getUserId());
			signin.setRecordTime(nowTime);
			signin.setLastSignInDate(nowDay);
			signin.setTotalSignInCount(new Long(1));
			baseDao.insert(signin);
		}else{
			Signin mysign = signlist.get(0);
			mysign.setLastSignInDate(nowDay);
			mysign.setTotalSignInCount(mysign.getTotalSignInCount()+1);
			baseDao.updateById(mysign);
		}
		
		SigninHistory history = new SigninHistory();
		history.setDayTime(nowDay);
		long count = baseDao.count(history);//今天已经签到多少人
		
		//更新签到总人数
		updateSignPeopleCount(count);
		
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, -1);
		history.setDayTime(nowDay);
		history.setUserId(ship.getUserId());
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		List<SigninHistory> bhlist = baseDao.findByObject(SigninHistory.class, history, page);
		
		SigninHistory newhistory = new SigninHistory();
		newhistory.setUserId(ship.getUserId());
		newhistory.setDayTime(nowDay);
		newhistory.setSignInTime(nowTime);
		newhistory.setIp(ip);
		newhistory.setSignIndex(new Long(count+1));
		if(bhlist == null||bhlist.size()==0){//如果前一天没有签到
			newhistory.setIsContinue(true);
			newhistory.setContinueDays(new Long(1));
		}else{//如果前一天有签到，表示有连续签到
			SigninHistory myhistory = bhlist.get(0);
			newhistory.setContinueDays(new Long(myhistory.getContinueDays()+1));
			newhistory.setIsContinue(true);
		}
		String annualMemberExpireDate =  ship.getAnnualMemberExpireDate();			
        long data =  DateUtil.compareTime(annualMemberExpireDate, nowDay);
		boolean realYear = false;//真实的年费状态
		if(data >= 0){
			realYear = true;
		}
		Map<String,Long> map = BonusCache.getInstance().getBonusMap();
		Long value = map.get(ship.getLevelNum()+"_"+(realYear?1:0));
		newhistory.setBonus(value.intValue());//本次签到获得的积分
		baseDao.insert(newhistory);//增加签到流水
		
		String experienceDate = ship.getExperienceDate();
		if(StringTools.isNotEmpty(experienceDate)){
			if(DateUtil.compareTime(experienceDate, nowDay)>0){//如果是体验会员
				if(DateUtil.compareTime(daytime, nowDay)<0){//如果是补签
					return; 
				}
			}
		}
		
		List<Integer> vipgradelist =  VipGradeProxy.getInstance().getVipGradeList();
		List<Long> growvaluelist =  VipGradeProxy.getInstance().getGrowValueList();
		insert(gh);//增加成长值流水    	
    	ship.setGrowthValue(ship.getGrowthValue()+gh.getGrowValue());
    	ship.setLevelNum(getVipGrade(vipgradelist,growvaluelist,ship));//更新金钻等级
    	baseDao.updateById(ship);//更新金钻用户的成长值 
    	
    	//重新计算特权信息    	
		addPrivilege(realYear,ship.getUserId(),ship.getLevelNum(),daytime);
	}
	
	private void updateSignPeopleCount(long count){
		String querysql = "select * from jinzuan_commondata where seqid=1 for update";
		List<CommonData> signlist =baseDao.findBySql(CommonData.class, querysql, new ArrayList());
		if(signlist==null||signlist.size()==0)return;
		CommonData signData = signlist.get(0);
		signData.setDataValue((count+1)+"");
		baseDao.updateById(signData);
	}
	
	
	/**
	 * 成为会员之后，增加特权
	 * @param realYear
	 */
	private void addPrivilege(boolean realYear,long uid,int vipgrade,String daytime) throws Exception{
	    Page page = new Page();
		Privilege query = new Privilege();
		query.setIsAnnual(realYear?1:0);
		query.setIsvalid(true);//有效的特权
		query.setLevelNum(vipgrade);//金钻等级
		List<Privilege> plist =baseDao.findByObject(Privilege.class, query, page);
		if(plist ==null||plist.size()==0){//如果没有配置特权
			return ;
		}
		String month = daytime.substring(0,7);
		PrivilegeReceiveInfo queryinfo = new PrivilegeReceiveInfo();
		queryinfo.setUserId(uid);
		queryinfo.setYearMonth(month);
		List<PrivilegeReceiveInfo> prinfolist = baseDao.findByObject(PrivilegeReceiveInfo.class,queryinfo,page);		
		
        for(Privilege p:plist){
        	int ptype = p.getPrivilegeType().intValue();
        	boolean flag = false;
        	for(PrivilegeReceiveInfo pri:prinfolist){
        		if(ptype == pri.getPrivilegeType().intValue()){//如果有特权
        			flag = true;
        			if(p.getValue().longValue()!=pri.getTotalValue().longValue()){
            			pri.setAvailableValue(p.getValue()-(pri.getTotalValue()-pri.getAvailableValue()));//可用数量
            			pri.setTotalValue(p.getValue());        			
            			baseDao.updateById(pri);//更新特权值
        			}
        			break;
        		}
        	}
        	if(!flag){//如果之前没有特权，则需要增加
        		PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        		info.setUserId(uid);
        		info.setYearMonth(month);
        		info.setPrivilegeType(p.getPrivilegeType());
        		info.setRecordTime(daytime);
        		info.setTotalValue(p.getValue());
        		info.setAvailableValue(p.getValue());
        		info.setIsvalid(true);//获得有效的特权
        		info.setSimpleName(p.getSimpleName());
        		baseDao.insert(info);
        	}
        }		
	}
	
}
