/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.util;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.constant.SqlLock;
import java.lang.reflect.Field;
import java.util.List;

public class SqlUtil {
    public static String getLockStr(SqlLock lock) {
        if (lock == null) {
            return "";
        }
        if (lock == SqlLock.UPDATE) {
            return " for update";
        }
        return "";
    }

    public static String createLimit(Page page) {
        if (page == null || !page.isPage()) {
            return "";
        }
        int start = (page.getPageNo() - 1) * page.getPageSize();
        return " limit " + start + "," + page.getPageSize();
    }

    public static String createOrder(Class<?> clazz, Page page) {
        if (page == null || !page.isOrder()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List list = page.getOrderList();
        for (Order order : list) {
            Field field = DaoUtil.getDeclaredField(clazz, (String)order.getOrderName());
            String columnName = DaoUtil.getColumnName((Field)field);
            sb.append(",").append(columnName);
            if (order.getType() == OrderType.DESC) {
                sb.append(" desc");
                continue;
            }
            sb.append(" asc");
        }
        String orderStr = sb.toString();
        if (orderStr.startsWith(",")) {
            orderStr = orderStr.substring(1);
        }
        if (orderStr.length() > 0) {
            orderStr = " order by " + orderStr;
        }
        return orderStr;
    }
}

