/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.util.SqlUtil;
import com.xunlei.niux.data.coin.vo.CoinLevel;
import com.xunlei.niux.data.coin.vo.UserCoin;
import java.util.ArrayList;
import java.util.List;

public class UserCoinDaoImpl
extends BaseDaoImpl
implements UserCoinDao {
    @Override
    public void update(UserCoin userCoin) {
        if (userCoin == null) {
            throw new RuntimeException("\u7528\u6237\u6b22\u4e50\u5238\u4e3a\u7a7a");
        }
        if (userCoin.getUserId() == null || "".equals(userCoin.getUserId())) {
            throw new RuntimeException("\u7528\u6237\u6b22\u4e50\u5238\u7684userId\u4e3a\u7a7a");
        }
        if (userCoin.getSeqId() == null || 0L >= userCoin.getSeqId()) {
            throw new RuntimeException("\u7528\u6237[" + userCoin.getUserId() + "]\u6b22\u4e50\u5238\u7684seqId\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.getTableName(userCoin.getUserId())).append(" set userName=?,rechargeSum=?,consumeSum=?,coinNum=?").append(",coinLevel=?,coinStatus=?,lastRechargeTime=?,lastConsumeTime=?,remark=?").append(" where seqId=? and userId=?");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userCoin.getUserName());
        paramList.add(userCoin.getRechargeSum());
        paramList.add(userCoin.getConsumeSum());
        paramList.add(userCoin.getCoinNum());
        paramList.add(userCoin.getCoinLevel());
        paramList.add(userCoin.getCoinStatus());
        paramList.add(userCoin.getLastRechargeTime());
        paramList.add(userCoin.getLastConsumeTime());
        paramList.add(userCoin.getRemark());
        paramList.add(userCoin.getSeqId());
        paramList.add(userCoin.getUserId());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public void insert(UserCoin userCoin) {
        if (userCoin == null) {
            throw new RuntimeException("\u7528\u6237\u6b22\u4e50\u5238\u4e3a\u7a7a");
        }
        if (userCoin == null || "".equals(userCoin)) {
            throw new RuntimeException("\u7528\u6237\u6b22\u4e50\u5238\u7684userId\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.getTableName(userCoin.getUserId())).append(" (userId,userName,rechargeSum,consumeSum,coinNum,coinLevel,coinStatus,lastRechargeTime,lastConsumeTime,remark)").append(" values(?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userCoin.getUserId());
        paramList.add(userCoin.getUserName());
        paramList.add(userCoin.getRechargeSum());
        paramList.add(userCoin.getConsumeSum());
        paramList.add(userCoin.getCoinNum());
        paramList.add(userCoin.getCoinLevel());
        paramList.add(userCoin.getCoinStatus());
        paramList.add(userCoin.getLastRechargeTime());
        paramList.add(userCoin.getLastConsumeTime());
        paramList.add(userCoin.getRemark());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public UserCoin find(String userId) {
        return this.find(userId, null);
    }

    @Override
    public UserCoin find(String userId, SqlLock lock) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userId=?").append(SqlUtil.getLockStr(lock));
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        List list = this.executeQuery(UserCoin.class, sb.toString(), paramList);
        return list == null || list.size() == 0 ? null : (UserCoin)list.get(0);
    }

    private String getTableName(String userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        long xunleiId = Long.valueOf(userId);
        return "usercoin_" + xunleiId % 50L;
    }

    @Override
    public List<CoinLevel> getCoinLevelUserNum(int userTableIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("select coinLevel seqId,coinLevel levelNum, coinLevel levelName,coinLevel levelIconUrl,coinLevel minCoinNum,count(*) sumUserNum from usercoin_").append(userTableIndex).append(" group by coinLevel");
        ArrayList paramList = new ArrayList();
        return this.executeQuery(CoinLevel.class, sb.toString(), paramList);
    }

    @Override
    public List<UserCoin> getTopCoinUser(int userTableIndex, int topNum) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *  from usercoin_").append(userTableIndex).append(" order by rechargeSum desc,lastRechargeTime asc");
        if (topNum > 0) {
            sb.append(" limit 0,").append(topNum);
        }
        ArrayList paramList = new ArrayList();
        return this.executeQuery(UserCoin.class, sb.toString(), paramList);
    }
}

