/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.bo;

import com.xunlei.niux.data.coin.bo.UserCoinBo;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.vo.CoinLevel;
import com.xunlei.niux.data.coin.vo.UserCoin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCoinBoImpl
implements UserCoinBo {
    @Autowired
    private UserCoinDao userCoinDao;

    @Override
    public UserCoin find(String userId) {
        return this.userCoinDao.find(userId);
    }

    @Override
    public void update(UserCoin userCoin) {
        this.userCoinDao.update(userCoin);
    }

    @Override
    public void insert(UserCoin userCoin) {
        this.userCoinDao.insert(userCoin);
    }

    @Override
    public List<UserCoin> getTopCoinUser(int topNum) {
        ArrayList<UserCoin> list = new ArrayList<UserCoin>();
        for (int i = 0; i < 50; ++i) {
            list.addAll(this.userCoinDao.getTopCoinUser(i, topNum));
        }
        return list;
    }

    @Override
    public List<UserCoin> getTableTopCoinUser(int tableindex, int topNum) {
        return this.userCoinDao.getTopCoinUser(tableindex, topNum);
    }

    @Override
    public Map<Integer, CoinLevel> getCoinLevelUserNum() {
        HashMap<Integer, CoinLevel> resultMap = new HashMap<Integer, CoinLevel>();
        for (int i = 0; i < 50; ++i) {
            List<CoinLevel> list = this.userCoinDao.getCoinLevelUserNum(i);
            if (list == null) continue;
            for (CoinLevel coinLevel : list) {
                CoinLevel rLevel = (CoinLevel)resultMap.get(coinLevel.getLevelNum());
                if (rLevel == null) {
                    rLevel = coinLevel;
                    resultMap.put(coinLevel.getLevelNum(), rLevel);
                    continue;
                }
                rLevel.setSumUserNum(rLevel.getSumUserNum() + coinLevel.getSumUserNum());
            }
        }
        return resultMap;
    }

    @Override
    public void update_freeze(String userId) {
        UserCoin userCoin = this.userCoinDao.find(userId, SqlLock.UPDATE);
        if (userCoin == null) {
            throw new RuntimeException("userID[" + userId + "]\u4e0d\u5b58\u5728");
        }
        if (userCoin.getCoinStatus() == 1) {
            return;
        }
        userCoin.setCoinStatus(1);
        this.userCoinDao.update(userCoin);
    }

    @Override
    public void update_unfreeze(String userId) {
        UserCoin userCoin = this.userCoinDao.find(userId, SqlLock.UPDATE);
        if (userCoin == null) {
            throw new RuntimeException("userID[" + userId + "]\u4e0d\u5b58\u5728");
        }
        if (userCoin.getCoinStatus() == 0) {
            return;
        }
        userCoin.setCoinStatus(0);
        this.userCoinDao.update(userCoin);
    }
}

