package com.xunlei.niux.data.coin.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.BizInfo;
@Service
public class BizInfoBoImpl implements BizInfoBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(BizInfo bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<BizInfo> find(BizInfo bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<BizInfo> find(BizInfo bizInfo, Page page) {
		return baseDao.findByObject(BizInfo.class, bizInfo, page);
	}
	public int count(BizInfo bizInfo) {
		return baseDao.count(bizInfo);
	}

	public BizInfo find(Long seqId) {
		return baseDao.findById(BizInfo.class, seqId);
	}

	public BizInfo find(String bizNo) {
		BizInfo bizInfo=new BizInfo();
		bizInfo.setBizNo(bizNo);
		List<BizInfo> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(BizInfo bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
