package com.xunlei.niux.data.coin.dao;

import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.vo.CoinTrans;

public interface CoinTransDao {
	void insert(CoinTrans coinTrans);
	List<CoinTrans> find(CoinTrans coinTrans,Page page);
	int count(String userId,CoinTrans coinTrans);
	
	List<CoinTrans> find(CoinTrans coinTrans,String actNoArr,Page page);
	int count(String userId,String actNoArr,CoinTrans coinTrans);
	
	List<CoinTrans> findDateSub(String userId, String queryTime, Page page);
	
	List<CoinTrans> findPeriod(String userId, String startTime, String endTime, Page page);
	
	List<CoinTrans> findPeriod(String userId, String startTime, String endTime, String transDirect, Page page);

	int countPeriod(String userId, String startTime, String endTime);
	
	int countPeriod(String userId, String startTime, String endTime, String transDirect);
	
	Integer getTodayCoin(String userId);

	/**
	 * 查询用户的有效（能够消费的）充值记录
	 * @param userId
	 * @param startTime
	 * @param endTime
	 * @param transDirect
	 * @param page
	 * @param lock
	 * @return
	 */
	List<CoinTrans> findPeriodexpireTime(String userId, String startTime, String endTime, String transDirect, Page page, SqlLock lock);
	
	/**
	 * 批量提交用户消费操作
	 * @param counsumeList 消费子订单
	 * @param rechargeList 消费充值订单
	 * @return 成功失败
	 */
	int[] commitAll(List<CoinTrans> insertList, List<CoinTrans> updateList);
	
}
