package com.xunlei.niux.data.coin.bo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.CoinLevel;
@Service
public class CoinLevelBoImpl implements CoinLevelBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;

	public List<CoinLevel> find(CoinLevel coinLevel, Page page) {
		return baseDao.findByObject(CoinLevel.class, coinLevel, page);
	}
	public void update(Map<Integer,CoinLevel> coinLevelMap){
		if(coinLevelMap==null){
			return;
		}
		Set<Integer> keySet=coinLevelMap.keySet();
		Iterator<Integer> it=keySet.iterator();
		while(it.hasNext()){
			int levelNum=it.next();
			CoinLevel coinLevel=coinLevelMap.get(levelNum);
			CoinLevel curLevel=find(levelNum);
			if(curLevel==null){
				continue;
			}
			curLevel.setSumUserNum(coinLevel.getSumUserNum());
			update(curLevel);
		}
	}
	
	public CoinLevel find(Integer levelNum){
		CoinLevel coinLevel=new CoinLevel();
		coinLevel.setLevelNum(levelNum);
		List<CoinLevel> list=find(coinLevel,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public void insert(CoinLevel coinLevel) {
		 baseDao.insert(coinLevel);
	}

	public void update(CoinLevel coinLevel) {
		baseDao.updateById(coinLevel);
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
