/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.CoinTransDao;
import com.xunlei.niux.data.coin.util.SqlUtil;
import com.xunlei.niux.data.coin.vo.CoinTrans;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoinTransDaoImpl
extends BaseDaoImpl
implements CoinTransDao {
    private static Logger logger = LoggerFactory.getLogger((String)CoinTransDaoImpl.class.getName());
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("^(-)?\\d\\s[A-Za-z_]+$");

    @Override
    public void insert(CoinTrans coinTrans) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.getTableName(coinTrans.getUserId())).append("(userId,userName,transDirect,transTime,transNum,transNo,remark,bizNo,transIp,balanceDate,actNo,gameId,leftNum,originTransNo,expireTime,transStatus)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(coinTrans.getUserId());
        paramList.add(coinTrans.getUserName());
        paramList.add(coinTrans.getTransDirect());
        paramList.add(coinTrans.getTransTime());
        paramList.add(coinTrans.getTransNum());
        paramList.add(coinTrans.getTransNo());
        paramList.add(coinTrans.getRemark());
        paramList.add(coinTrans.getBizNo());
        paramList.add(coinTrans.getTransIp());
        paramList.add(coinTrans.getBalanceDate());
        paramList.add(coinTrans.getActNo());
        paramList.add(coinTrans.getGameId());
        paramList.add(coinTrans.getLeftNum());
        paramList.add(coinTrans.getOriginTransNo());
        paramList.add(coinTrans.getExpireTime());
        paramList.add(coinTrans.getTransStatus());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public List<CoinTrans> find(CoinTrans coinTrans, Page page) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(coinTrans.getUserId())).append(DaoUtil.createWhere((Object)coinTrans, paramList)).append(SqlUtil.createOrder(CoinTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(CoinTrans.class, sb.toString(), paramList);
    }

    @Override
    public int count(String userId, CoinTrans coinTrans) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ").append(this.getTableName(userId)).append(DaoUtil.createWhere((Object)coinTrans, paramList));
        return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
    }

    @Override
    public List<CoinTrans> find(CoinTrans coinTrans, String actNoArr, Page page) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(coinTrans.getUserId())).append(DaoUtil.createWhere((Object)coinTrans, paramList)).append(" and actno in  (" + actNoArr + ")").append(SqlUtil.createOrder(CoinTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(CoinTrans.class, sb.toString(), paramList);
    }

    @Override
    public int count(String userId, String actNoArr, CoinTrans coinTrans) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ").append(this.getTableName(userId)).append(DaoUtil.createWhere((Object)coinTrans, paramList)).append(" and actno in  (" + actNoArr + ")");
        return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
    }

    private String getTableName(String userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        long xunleiId = Long.valueOf(userId);
        return "cointrans_" + xunleiId % 50L;
    }

    @Override
    public List<CoinTrans> findDateSub(String userId, String expr, Page page) {
        Matcher matcher;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        if (INTERVAL_PATTERN != null && !(matcher = INTERVAL_PATTERN.matcher(expr)).matches()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userid = ? ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL  " + expr + " ) ").append(SqlUtil.createOrder(CoinTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(CoinTrans.class, sb.toString(), paramList);
    }

    @Override
    public List<CoinTrans> findPeriod(String userId, String startTime, String endTime, Page page) {
        return this.findPeriod(userId, startTime, endTime, null, page);
    }

    @Override
    public List<CoinTrans> findPeriod(String userId, String startTime, String endTime, String transDirect, Page page) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userid = ? ");
        if (transDirect != null) {
            sb.append(" AND transDirect = ? ");
            paramList.add(transDirect);
        }
        sb.append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_FORMAT(?,'%Y-%m-%d') ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') <= DATE_FORMAT(?,'%Y-%m-%d') ").append(SqlUtil.createOrder(CoinTrans.class, page)).append(SqlUtil.createLimit(page));
        paramList.add(startTime);
        paramList.add(endTime);
        return this.executeQuery(CoinTrans.class, sb.toString(), paramList);
    }

    @Override
    public Integer getTodayCoin(String userId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select sum(transNum) from " + this.getTableName(userId));
        sb.append(" where transDirect=? and balanceDate=? and userId=?");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = simpleDateFormat.format(new Date());
        Object[] args = new Object[]{"2", dateStr, userId};
        Integer todayCoin = this.getJdbcTemplate().queryForInt(sb.toString(), args);
        return todayCoin;
    }

    @Override
    public int countPeriod(String userId, String startTime, String endTime) {
        return this.countPeriod(userId, startTime, endTime, null);
    }

    @Override
    public int countPeriod(String userId, String startTime, String endTime, String transDirect) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        StringBuilder sb = new StringBuilder();
        sb.append("select count(seqId) from ").append(this.getTableName(userId)).append(" where userid = ? ");
        if (transDirect != null) {
            sb.append(" AND transDirect = ? ");
            paramList.add(transDirect);
        }
        sb.append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_FORMAT(?,'%Y-%m-%d') ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') <= DATE_FORMAT(?,'%Y-%m-%d') ");
        paramList.add(startTime);
        paramList.add(endTime);
        return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
    }

    @Override
    public List<CoinTrans> findPeriodexpireTime(String userId, String startTime, String endTime, String transDirect, Page page, SqlLock lock) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userid = ? and leftNum != 0 and transStatus = 0 ");
        if (transDirect != null) {
            sb.append(" AND transDirect = ? ");
            paramList.add(transDirect);
        }
        sb.append(" AND DATE_FORMAT(expireTime,'%Y-%m-%d') >= DATE_FORMAT(?,'%Y-%m-%d') ").append(" AND DATE_FORMAT(expireTime,'%Y-%m-%d') <= DATE_FORMAT(?,'%Y-%m-%d') ").append(SqlUtil.createOrder(CoinTrans.class, page)).append(SqlUtil.createLimit(page)).append(SqlUtil.getLockStr(lock));
        paramList.add(startTime);
        paramList.add(endTime);
        return this.executeQuery(CoinTrans.class, sb.toString(), paramList);
    }

    @Override
    public int[] commitAll(List<CoinTrans> insertList, List<CoinTrans> updateList) {
        ArrayList<String> sqls = new ArrayList<String>();
        String[] sql = new String[insertList.size() + updateList.size()];
        StringBuilder sb = new StringBuilder();
        for (CoinTrans coinTrans : insertList) {
            sb.delete(0, sb.length());
            sb.append("insert into ").append(this.getTableName(coinTrans.getUserId())).append(" (userId,userName,transDirect,transTime,transNum,transNo,remark,bizNo,transIp,balanceDate,actNo,gameId,leftNum,originTransNo,expireTime,transStatus)").append(" values('" + coinTrans.getUserId() + "','" + coinTrans.getUserName() + "','" + coinTrans.getTransDirect() + "','" + coinTrans.getTransTime() + "'," + coinTrans.getTransNum() + ",'" + coinTrans.getTransNo() + "','" + coinTrans.getRemark() + "','" + coinTrans.getBizNo() + "','" + coinTrans.getTransIp() + "','" + coinTrans.getBalanceDate() + "','" + coinTrans.getActNo() + "','" + coinTrans.getGameId() + "'," + coinTrans.getLeftNum() + ",'" + coinTrans.getOriginTransNo() + "','" + coinTrans.getExpireTime() + "'," + coinTrans.getTransStatus() + ") ");
            sqls.add(sb.toString());
        }
        for (CoinTrans coinTrans : updateList) {
            sb.delete(0, sb.length());
            sb.append("update ").append(this.getTableName(coinTrans.getUserId())).append(" set leftNum = " + coinTrans.getLeftNum() + ",originTransNo = '" + coinTrans.getOriginTransNo() + "',expireTime = '" + coinTrans.getExpireTime() + "',transStatus = " + coinTrans.getTransStatus() + " where userId = '" + coinTrans.getUserId() + "' and transDirect = '" + coinTrans.getTransDirect() + "' and bizNo = '" + coinTrans.getBizNo() + "' and transNo = '" + coinTrans.getTransNo() + "'");
            sqls.add(sb.toString());
        }
        sqls.toArray(sql);
        logger.info("commitAll sqls:" + sqls);
        return this.getJdbcTemplate().batchUpdate(sql);
    }
}

