/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.bo.LotteryRecordBo;
import com.xunlei.niux.data.coin.dto.LotteryDataDTO;
import com.xunlei.niux.data.coin.vo.LotteryRecord;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LotteryRecordBoImpl
implements LotteryRecordBo {
    private static final String SQL_BEGIN = "SELECT a.seqId,a.status status,SUM(a.coin) AS coin,SUM(b.succsessCashMoney) AS succsessCashMoney,SUM(b.succsessVoucherMoney) AS succsessVoucherMoney,SUM(b.failCashMoney) AS failCashMoney, SUM(b.failVoucherMoney) AS failVoucherMoney,COUNT(status) AS count ,COUNT(DISTINCT a.cashNo) AS cashNum ,COUNT(DISTINCT a.voucherNo) AS voucherNum FROM lotteryrecord a LEFT OUTER JOIN lotteryinfo b ON a.coin=b.coin WHERE  1=1 ";
    private static final String SQL_END = " group by status ";
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    @Override
    public void insert(LotteryRecord bizInfo) {
        this.baseDao.insert((Object)bizInfo);
    }

    @Override
    public List<LotteryRecord> find(LotteryRecord bizInfo) {
        return this.find(bizInfo, new Page());
    }

    @Override
    public List<LotteryRecord> find(LotteryRecord bizInfo, Page page) {
        return this.baseDao.findByObject(LotteryRecord.class, (Object)bizInfo, page);
    }

    @Override
    public int count(LotteryRecord bizInfo) {
        return this.baseDao.count((Object)bizInfo);
    }

    @Override
    public LotteryRecord find(Long seqId) {
        return (LotteryRecord)this.baseDao.findById(LotteryRecord.class, (Number)seqId);
    }

    @Override
    public LotteryRecord find(String userId) {
        LotteryRecord bizInfo = new LotteryRecord();
        bizInfo.setUserId(userId);
        List<LotteryRecord> list = this.find(bizInfo);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public void update(LotteryRecord bizInfo) {
        this.baseDao.updateById((Object)bizInfo);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void deleteById(String seqId) {
        this.baseDao.deleteById(LotteryRecord.class, seqId);
    }

    @Override
    public LotteryRecord findByOrderId(String orderId) {
        LotteryRecord bizInfo = new LotteryRecord();
        bizInfo.setOrderId(orderId);
        List<LotteryRecord> list = this.find(bizInfo);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<LotteryDataDTO> summary(LotteryRecord lotteryRecord) {
        StringBuilder sb = new StringBuilder(SQL_BEGIN);
        ArrayList<Object> args = new ArrayList<Object>();
        if (lotteryRecord != null) {
            if (!StringUtils.isEmpty((String)lotteryRecord.getUserId())) {
                args.add(lotteryRecord.getUserId());
                sb.append(" and a.userId = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getActNo())) {
                args.add(lotteryRecord.getActNo());
                sb.append(" and a.actNo = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getAdvNo())) {
                args.add(lotteryRecord.getAdvNo());
                sb.append(" and a.advNo = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getStatus())) {
                args.add(lotteryRecord.getStatus());
                sb.append(" and a.status = ?");
            }
            if (lotteryRecord.getCoin() != null && lotteryRecord.getCoin() != 0) {
                args.add(lotteryRecord.getCoin());
                sb.append(" and a.coin = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getBizNo())) {
                args.add(lotteryRecord.getBizNo());
                sb.append(" and a.bizNo = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getGameId())) {
                args.add(lotteryRecord.getGameId());
                sb.append(" and a.gameId = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getServerId())) {
                args.add(lotteryRecord.getServerId());
                sb.append(" and a.serverId = ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getBeginTime())) {
                args.add(lotteryRecord.getBeginTime());
                sb.append(" and a.time >= ?");
            }
            if (!StringUtils.isEmpty((String)lotteryRecord.getEndTime())) {
                args.add(lotteryRecord.getEndTime());
                sb.append(" and a.time <= ?");
            }
            sb.append(SQL_END);
        }
        List data = this.baseDao.executeQuery(LotteryDataDTO.class, sb.toString(), args);
        return data;
    }
}

