/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.bo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.bo.CoinTransBo;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.CoinTransDao;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.exception.CoinRuntimeException;
import com.xunlei.niux.data.coin.vo.CoinTrans;
import com.xunlei.niux.data.coin.vo.UserCoin;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CoinTransBoImpl
implements CoinTransBo {
    private static Logger logger = LoggerFactory.getLogger((String)CoinTransBoImpl.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private CoinTransDao coinTransDao;
    @Autowired
    private UserCoinDao userCoinDao;

    @Override
    public CoinTrans find(String userId, long seqId) {
        CoinTrans coinTrans = new CoinTrans();
        coinTrans.setUserId(userId);
        coinTrans.setSeqId(seqId);
        List<CoinTrans> list = this.find(coinTrans, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<CoinTrans> find(CoinTrans coinTrans, Page page) {
        return this.coinTransDao.find(coinTrans, page);
    }

    @Override
    public int count(CoinTrans pTrans) {
        if (pTrans.getUserId() == null || "".equals(pTrans.getUserId())) {
            throw new RuntimeException("userid\u4e3a\u7a7a");
        }
        return this.coinTransDao.count(pTrans.getUserId(), pTrans);
    }

    @Override
    public List<CoinTrans> find(CoinTrans coinTrans, String actNoArr, Page page) {
        return this.coinTransDao.find(coinTrans, actNoArr, page);
    }

    @Override
    public int count(CoinTrans pTrans, String actNoArr) {
        if (pTrans.getUserId() == null || "".equals(pTrans.getUserId())) {
            throw new RuntimeException("userid\u4e3a\u7a7a");
        }
        return this.coinTransDao.count(pTrans.getUserId(), actNoArr, pTrans);
    }

    @Override
    public CoinTrans find(String userId, String bizNo, String transNo, String transDirect) {
        CoinTrans coinTrans = new CoinTrans();
        coinTrans.setUserId(userId);
        coinTrans.setBizNo(bizNo);
        coinTrans.setTransNo(transNo);
        coinTrans.setTransDirect(transDirect);
        List<CoinTrans> list = this.find(coinTrans, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public void insert(CoinTrans coinTrans) {
        if (coinTrans == null) {
            throw new CoinRuntimeException("1009", "\u6b22\u4e50\u5238\u4ea4\u6613\u4e3a\u7a7a");
        }
        this.checkCoinTransParam(coinTrans);
        if (this.find(coinTrans.getUserId(), coinTrans.getBizNo(), coinTrans.getTransNo(), coinTrans.getTransDirect()) != null) {
            throw new CoinRuntimeException("1001", "\u4e1a\u52a1\u53f7[" + coinTrans.getBizNo() + "]\u7684\u4ea4\u6613\u7f16\u53f7[" + coinTrans.getTransNo() + "]\u4ea4\u6613\u65b9\u5411[" + coinTrans.getTransDirect() + "]\u5df2\u5904\u7406");
        }
        coinTrans.setOriginTransNo(coinTrans.getTransNo());
        coinTrans.setLeftNum(coinTrans.getTransNum());
        coinTrans.setTransStatus(0);
        Calendar cal = Calendar.getInstance();
        coinTrans.setTransTime(sdf.format(cal.getTime()));
        cal.add(5, 60);
        coinTrans.setExpireTime(sdf.format(cal.getTime()));
        UserCoin userCoin = this.userCoinDao.find(coinTrans.getUserId(), SqlLock.UPDATE);
        userCoin = this.calUserCoin(userCoin, coinTrans);
        if ("1".equals(coinTrans.getTransDirect())) {
            this.dealOrderConsume(coinTrans);
        }
        if (userCoin.getSeqId() == null || userCoin.getSeqId() <= 0L) {
            this.userCoinDao.insert(userCoin);
        } else {
            this.userCoinDao.update(userCoin);
        }
        this.coinTransDao.insert(coinTrans);
    }

    private UserCoin calUserCoin(UserCoin userCoin, CoinTrans coinTrans) {
        if ("1".equals(coinTrans.getTransDirect())) {
            return this.calUserCoinConsume(userCoin, coinTrans);
        }
        if ("2".equals(coinTrans.getTransDirect())) {
            return this.calUserCoinRecharge(userCoin, coinTrans);
        }
        if ("3".equals(coinTrans.getTransDirect())) {
            return this.calUserCoinConsumeReturn(userCoin, coinTrans);
        }
        throw new CoinRuntimeException("1009", "\u6b22\u4e50\u5238\u4ea4\u6613\u7c7b\u578b[" + coinTrans.getTransDirect() + "]\u672a\u77e5");
    }

    private UserCoin calUserCoinRecharge(UserCoin userCoin, CoinTrans coinTrans) {
        if (userCoin == null) {
            userCoin = new UserCoin();
            userCoin.setUserId(coinTrans.getUserId());
            userCoin.setUserName(coinTrans.getUserName());
            userCoin.setCoinLevel(0);
            userCoin.setCoinNum(0);
            userCoin.setConsumeSum(0L);
            userCoin.setRechargeSum(0L);
            userCoin.setCoinStatus(0);
        }
        userCoin.setCoinNum(userCoin.getCoinNum() + coinTrans.getTransNum());
        userCoin.setRechargeSum(userCoin.getRechargeSum() + (long)coinTrans.getTransNum().intValue());
        userCoin.setLastRechargeTime(sdf.format(new Date()));
        userCoin.setCoinLevel(this.calUserCoinLevel(userCoin));
        if (userCoin.getCoinNum() < 0) {
            throw new CoinRuntimeException("1002", "\u7528\u6237[" + userCoin.getUserId() + "]\u6b22\u4e50\u5238\u6ea2\u51fa");
        }
        return userCoin;
    }

    private UserCoin calUserCoinConsumeReturn(UserCoin userCoin, CoinTrans coinTrans) {
        if (userCoin == null) {
            throw new CoinRuntimeException("1020", "\u6b22\u4e50\u5238\u4e0d\u5b58\u5728");
        }
        if (userCoin.getConsumeSum() - (long)coinTrans.getTransNum().intValue() < 0L) {
            throw new CoinRuntimeException("1021", "\u7528\u6237[" + userCoin.getUserId() + "]\u8fd4\u8fd8\u6b22\u4e50\u5238\u4e0d\u591f");
        }
        userCoin.setCoinNum(userCoin.getCoinNum() + coinTrans.getTransNum());
        userCoin.setConsumeSum(userCoin.getConsumeSum() - (long)coinTrans.getTransNum().intValue());
        if (userCoin.getCoinNum() < 0) {
            throw new CoinRuntimeException("1002", "\u7528\u6237[" + userCoin.getUserId() + "]\u6b22\u4e50\u5238\u6ea2\u51fa");
        }
        return userCoin;
    }

    private UserCoin calUserCoinConsume(UserCoin userCoin, CoinTrans coinTrans) {
        if (userCoin == null) {
            throw new CoinRuntimeException("1020", "\u6b22\u4e50\u5238\u4e0d\u5b58\u5728");
        }
        if (userCoin.getCoinStatus() > 0) {
            throw new CoinRuntimeException("1022", "\u7528\u6237[" + userCoin.getUserId() + "]\u6b22\u4e50\u5238\u88ab\u51bb\u7ed3");
        }
        if (userCoin.getCoinNum() - coinTrans.getTransNum() < 0) {
            throw new CoinRuntimeException("1021", "\u7528\u6237[" + userCoin.getUserId() + "]\u6b22\u4e50\u5238\u4e0d\u591f");
        }
        userCoin.setCoinNum(userCoin.getCoinNum() - coinTrans.getTransNum());
        userCoin.setConsumeSum(userCoin.getConsumeSum() + (long)coinTrans.getTransNum().intValue());
        if (userCoin.getConsumeSum() < 0L) {
            throw new CoinRuntimeException("1002", "\u7528\u6237[" + userCoin.getUserId() + "]\u6d88\u8d39\u6b22\u4e50\u5238\u6ea2\u51fa");
        }
        userCoin.setLastConsumeTime(sdf.format(new Date()));
        return userCoin;
    }

    private void dealOrderConsume(CoinTrans coinTrans) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = formater.format(new Date());
        String endTime = "2200-01-01 00:00:00";
        int count = coinTrans.getTransNum();
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(count);
        page.addOrder("expireTime", OrderType.ESC);
        List<CoinTrans> list = this.coinTransDao.findPeriodexpireTime(coinTrans.getUserId(), startTime, endTime, "2", page, SqlLock.UPDATE);
        ArrayList<CoinTrans> counsumeList = new ArrayList<CoinTrans>();
        ArrayList<CoinTrans> rechargeList = new ArrayList<CoinTrans>();
        int transSum = 0;
        int index = 0;
        for (CoinTrans ct : list) {
            if (ct.getLeftNum() <= 0) continue;
            ++index;
            if ((transSum += ct.getLeftNum().intValue()) >= coinTrans.getTransNum()) {
                int transNum = ct.getLeftNum() - (transSum - coinTrans.getTransNum());
                counsumeList.add(this.initConsumeTrans(coinTrans, ct.getTransNo(), transNum, index));
                int leftNum = ct.getLeftNum() - transNum;
                ct.setLeftNum(leftNum);
                rechargeList.add(ct);
                break;
            }
            counsumeList.add(this.initConsumeTrans(coinTrans, ct.getTransNo(), ct.getLeftNum(), index));
            ct.setLeftNum(0);
            rechargeList.add(ct);
        }
        if (transSum < coinTrans.getTransNum()) {
            logger.info("dealOrderConsume transSum is less than coinTrans.getTransNum()!coinTrans:" + coinTrans);
            throw new CoinRuntimeException("1044", "\u7528\u6237[" + coinTrans.getUserId() + "]\u6d88\u8d39\u6b22\u4e50\u5238\u51fa\u73b0\u8ba2\u5355\u5f02\u5e38\uff1a\u672a\u627e\u5230\u7528\u6237\u7684\u5145\u503c\u8ba2\u5355\u3002");
        }
        if (counsumeList.isEmpty() && rechargeList.isEmpty()) {
            logger.info("dealOrderConsume counsumeList and rechargeList is empty!coinTrans:" + coinTrans);
            throw new CoinRuntimeException("1044", "\u7528\u6237[" + coinTrans.getUserId() + "]\u6d88\u8d39\u6b22\u4e50\u5238\u51fa\u73b0\u8ba2\u5355\u5f02\u5e38\uff1a\u672a\u627e\u5230\u7528\u6237\u7684\u5145\u503c\u8ba2\u5355\u3002");
        }
        try {
            int[] result = this.coinTransDao.commitAll(counsumeList, rechargeList);
            counsumeList.addAll(rechargeList);
            int i = 0;
            for (int res : result) {
                ++i;
                if (res == 1) continue;
                CoinTrans obj = counsumeList.size() >= i + 1 ? (CoinTrans)counsumeList.get(i) : (CoinTrans)rechargeList.get(i - counsumeList.size());
                logger.info("commitAll result failed\uff1aCoinTrans=" + obj + ", result=" + res);
            }
        }
        catch (Exception e) {
            logger.info("commitAll Exception!coinTrans:" + coinTrans, (Throwable)e);
            throw new CoinRuntimeException("1045", "\u7528\u6237[" + coinTrans.getUserId() + "]\u6d88\u8d39\u6b22\u4e50\u5238\u51fa\u73b0\u8ba2\u5355\u5f02\u5e38\uff1a\u5904\u7406\u8ba2\u5355\u65f6\u51fa\u73b0\u6570\u636e\u5e93\u5f02\u5e38\u3002");
        }
    }

    private CoinTrans initConsumeTrans(CoinTrans fatherCoinTrans, String originTransNo, int transNum, int transIndex) {
        CoinTrans childCoinTrans = new CoinTrans();
        if (!"1".equals(fatherCoinTrans.getTransDirect())) {
            return childCoinTrans;
        }
        BeanUtils.copyProperties((Object)fatherCoinTrans, (Object)childCoinTrans);
        childCoinTrans.setSeqId(null);
        childCoinTrans.setTransNo(childCoinTrans.getTransNo() + "_" + transIndex);
        childCoinTrans.setOriginTransNo(originTransNo);
        childCoinTrans.setTransNum(transNum);
        childCoinTrans.setLeftNum(transNum);
        childCoinTrans.setTransDirect("4");
        return childCoinTrans;
    }

    public void checkCoinTransParam(CoinTrans coinTrans) {
        if (coinTrans.getTransNo() == null || "".equals(coinTrans.getTransNo())) {
            throw new CoinRuntimeException("1009", "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (coinTrans.getTransDirect() == null || "".equals(coinTrans.getTransDirect())) {
            throw new CoinRuntimeException("1009", "\u6b22\u4e50\u5238\u4ea4\u6613\u65b9\u5411\u4e3a\u7a7a");
        }
        if (coinTrans.getTransNum() <= 0) {
            throw new CoinRuntimeException("1009", "\u4ea4\u6613\u6b22\u4e50\u5238\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    private int calUserCoinLevel(UserCoin userCoin) {
        Long sumcoin = userCoin.getRechargeSum();
        if (sumcoin < 5L) {
            return 0;
        }
        if (sumcoin < 10L) {
            return 1;
        }
        if (sumcoin < 15L) {
            return 2;
        }
        if (sumcoin < 20L) {
            return 3;
        }
        if (sumcoin < 30L) {
            return 4;
        }
        if (sumcoin < 40L) {
            return 5;
        }
        if (sumcoin < 50L) {
            return 6;
        }
        if (sumcoin < 60L) {
            return 7;
        }
        if (sumcoin < 75L) {
            return 8;
        }
        if (sumcoin < 90L) {
            return 9;
        }
        for (int i = 10; i < 99; ++i) {
            if ((long)((i - 4) * (i - 4) * 3) <= sumcoin) continue;
            return i;
        }
        return 99;
    }

    public CoinTransDao getCoinTransDao() {
        return this.coinTransDao;
    }

    public void setCoinTransDao(CoinTransDao coinTransDao) {
        this.coinTransDao = coinTransDao;
    }

    public UserCoinDao getUserCoinDao() {
        return this.userCoinDao;
    }

    public void setUserCoinDao(UserCoinDao userCoinDao) {
        this.userCoinDao = userCoinDao;
    }

    @Override
    public List<CoinTrans> findDateSub(String userId, String expr, Page page) {
        return this.coinTransDao.findDateSub(userId, expr, page);
    }

    @Override
    public List<CoinTrans> findPeriod(String userId, String startTime, String endTime, Page page) {
        return this.coinTransDao.findPeriod(userId, startTime, endTime, null, page);
    }

    @Override
    public Integer getTodayCoin(String userId) {
        return this.coinTransDao.getTodayCoin(userId);
    }

    @Override
    public int countPeriod(String userId, String startTime, String endTime) {
        return this.countPeriod(userId, startTime, endTime, null);
    }

    @Override
    public List<CoinTrans> findPeriod(String userId, String startTime, String endTime, String transDirect, Page page) {
        return this.coinTransDao.findPeriod(userId, startTime, endTime, transDirect, page);
    }

    @Override
    public int countPeriod(String userId, String startTime, String endTime, String transDirect) {
        return this.coinTransDao.countPeriod(userId, startTime, endTime, transDirect);
    }
}

