/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.coin.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.bo.CoinLevelBo;
import com.xunlei.niux.data.coin.vo.CoinLevel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CoinLevelBoImpl
implements CoinLevelBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    @Override
    public List<CoinLevel> find(CoinLevel coinLevel, Page page) {
        return this.baseDao.findByObject(CoinLevel.class, (Object)coinLevel, page);
    }

    @Override
    public void update(Map<Integer, CoinLevel> coinLevelMap) {
        if (coinLevelMap == null) {
            return;
        }
        Set<Integer> keySet = coinLevelMap.keySet();
        for (int levelNum : keySet) {
            CoinLevel coinLevel = coinLevelMap.get(levelNum);
            CoinLevel curLevel = this.find(levelNum);
            if (curLevel == null) continue;
            curLevel.setSumUserNum(coinLevel.getSumUserNum());
            this.update(curLevel);
        }
    }

    @Override
    public CoinLevel find(Integer levelNum) {
        CoinLevel coinLevel = new CoinLevel();
        coinLevel.setLevelNum(levelNum);
        List<CoinLevel> list = this.find(coinLevel, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public void insert(CoinLevel coinLevel) {
        this.baseDao.insert((Object)coinLevel);
    }

    @Override
    public void update(CoinLevel coinLevel) {
        this.baseDao.updateById((Object)coinLevel);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

