package com.xunlei.niux.data.coin.dao;


import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.util.SqlUtil;
import com.xunlei.niux.data.coin.vo.CoinLevel;
import com.xunlei.niux.data.coin.vo.UserCoin;
public class UserCoinDaoImpl extends BaseDaoImpl implements UserCoinDao {
	public void update(UserCoin userCoin) {
		if(userCoin==null){
			throw new RuntimeException("用户欢乐券为空");
		}
		if(userCoin.getUserId()==null||"".equals(userCoin.getUserId())){
			throw new RuntimeException("用户欢乐券的userId为空");
		}
		if(userCoin.getSeqId()==null||0>=userCoin.getSeqId()){
			throw new RuntimeException("用户["+userCoin.getUserId()+"]欢乐券的seqId为空");
		}
		StringBuilder sb=new StringBuilder();
		sb.append("update ").append(getTableName(userCoin.getUserId()))
		  .append(" set userName=?,rechargeSum=?,consumeSum=?,coinNum=?")
		  .append(",coinLevel=?,coinStatus=?,lastRechargeTime=?,lastConsumeTime=?,remark=?")
		  .append(" where seqId=? and userId=?");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userCoin.getUserName());
		paramList.add(userCoin.getRechargeSum());
		paramList.add(userCoin.getConsumeSum());
		paramList.add(userCoin.getCoinNum());
		paramList.add(userCoin.getCoinLevel());
		paramList.add(userCoin.getCoinStatus());
		paramList.add(userCoin.getLastRechargeTime());
		paramList.add(userCoin.getLastConsumeTime());
		paramList.add(userCoin.getRemark());
		paramList.add(userCoin.getSeqId());
		paramList.add(userCoin.getUserId());
		this.execute(sb.toString(), paramList);
	}
	public void insert(UserCoin userCoin) {
		if(userCoin==null){
			throw new RuntimeException("用户欢乐券为空");
		}
		if(userCoin==null||"".equals(userCoin)){
			throw new RuntimeException("用户欢乐券的userId为空");
		}
		StringBuilder sb=new StringBuilder();
		sb.append("insert into ").append(getTableName(userCoin.getUserId()))
		  .append(" (userId,userName,rechargeSum,consumeSum,coinNum,coinLevel,coinStatus,lastRechargeTime,lastConsumeTime,remark)")
		  .append(" values(?,?,?,?,?,?,?,?,?,?)");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userCoin.getUserId());
		paramList.add(userCoin.getUserName());
		paramList.add(userCoin.getRechargeSum());
		paramList.add(userCoin.getConsumeSum());
		paramList.add(userCoin.getCoinNum());
		paramList.add(userCoin.getCoinLevel());
		paramList.add(userCoin.getCoinStatus());
		paramList.add(userCoin.getLastRechargeTime());
		paramList.add(userCoin.getLastConsumeTime());
		paramList.add(userCoin.getRemark());
		this.execute(sb.toString(), paramList);
	}
	public UserCoin find(String userId) {
		return find(userId,null);
	}

	public UserCoin find(String userId, SqlLock lock) {
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ").append(getTableName(userId))
		  .append(" where userId=?").append(SqlUtil.getLockStr(lock));
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		List<UserCoin> list=this.executeQuery(UserCoin.class, sb.toString(), paramList);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	/**
	 * 获取表名，按照hash值分50张分表
	 * @param userId
	 * @return
	 */
	private String getTableName(String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		long xunleiId=Long.valueOf(userId);
		return "usercoin_"+(xunleiId%50);
	}
	public List<CoinLevel> getCoinLevelUserNum(int userTableIndex){
		StringBuilder sb=new StringBuilder();
		sb.append("select coinLevel seqId,coinLevel levelNum, coinLevel levelName,coinLevel levelIconUrl,coinLevel minCoinNum,count(*) sumUserNum from usercoin_").append(userTableIndex)
		  .append(" group by coinLevel");
		List<Object> paramList=new ArrayList<Object>();
		return this.executeQuery(CoinLevel.class, sb.toString(), paramList);
	}
	public List<UserCoin> getTopCoinUser(int userTableIndex,int topNum){
		StringBuilder sb =new StringBuilder();
		sb.append("select *  from usercoin_").append(userTableIndex)
		  .append(" order by rechargeSum desc,lastRechargeTime asc");
		if(topNum>0){
			sb.append(" limit 0,").append(topNum);
		}
		List<Object> paramList=new ArrayList<Object>();
		return this.executeQuery(UserCoin.class, sb.toString(), paramList);
	}
}
