package com.xunlei.niux.data.coin.bo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.UserCoinSort;
@Service
public class UserCoinSortBoImpl implements UserCoinSortBo{
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Override
	public void execSql(String sql) {
		baseDao.execute(sql, new ArrayList<Object>());
	}
	public UserCoinSort findByUserId(String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		UserCoinSort ubs=new UserCoinSort();
		ubs.setUserId(userId);
		List<UserCoinSort> list=baseDao.findByObject(UserCoinSort.class, ubs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public UserCoinSort findByUserId(int sortNum){
		if(sortNum<=0){
			return null;
		}
		UserCoinSort ubs=new UserCoinSort();
		ubs.setSortNum(sortNum);
		List<UserCoinSort> list=baseDao.findByObject(UserCoinSort.class, ubs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<UserCoinSort> finds(UserCoinSort ubs,Page page){
		return baseDao.findByObject(UserCoinSort.class, ubs, page);
	}
	public int count(UserCoinSort ubs){
		return baseDao.count(ubs);
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
