package com.xunlei.niux.data.coin.bo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.vo.CoinLevel;
import com.xunlei.niux.data.coin.vo.UserCoin;
@Service
public class UserCoinBoImpl implements UserCoinBo {
	@Autowired
	private UserCoinDao userCoinDao;
	
	public UserCoin find(String userId) {
		return userCoinDao.find(userId);
	}
	public void update(UserCoin userCoin){
		userCoinDao.update(userCoin);
	}
	public void insert(UserCoin userCoin){
		userCoinDao.insert(userCoin);
	} 
	public List<UserCoin> getTopCoinUser(int topNum){
		List<UserCoin> list=new ArrayList<UserCoin>();
		for(int i=0;i<50;i++){
			list.addAll(userCoinDao.getTopCoinUser(i, topNum));
		}
		return list;
	}
	public List<UserCoin> getTableTopCoinUser(int tableindex,int topNum){
		return userCoinDao.getTopCoinUser(tableindex, topNum);
	}
	/**
	 * 
	 * @return
	 */
	public Map<Integer,CoinLevel> getCoinLevelUserNum(){
		Map<Integer,CoinLevel> resultMap=new HashMap<Integer,CoinLevel>();
		for(int i=0;i<50;i++){
			List<CoinLevel> list=userCoinDao.getCoinLevelUserNum(i);
			if(list==null){
				continue;
			}
			for(CoinLevel coinLevel:list){
				CoinLevel rLevel=resultMap.get(coinLevel.getLevelNum());
				if(rLevel==null){
					rLevel=coinLevel;
					resultMap.put(coinLevel.getLevelNum(), rLevel);
				}else{
					rLevel.setSumUserNum(rLevel.getSumUserNum()+coinLevel.getSumUserNum());
				}
			}
		}
		return resultMap;
	}
	/**
	 * 冻结账号
	 * @param userId
	 */
	public void update_freeze(String userId){
		UserCoin userCoin=userCoinDao.find(userId, SqlLock.UPDATE);
		if(userCoin==null){
			throw new RuntimeException("userID["+userId+"]不存在");
		}
		if(userCoin.getCoinStatus()==1){
			return;
		}
		userCoin.setCoinStatus(1);//冻结
		userCoinDao.update(userCoin);
	}
	/**
	 * 冻结账号
	 * @param userId
	 */
	public void update_unfreeze(String userId){
		UserCoin userCoin=userCoinDao.find(userId, SqlLock.UPDATE);
		if(userCoin==null){
			throw new RuntimeException("userID["+userId+"]不存在");
		}
		if(userCoin.getCoinStatus()==0){
			return;
		}
		userCoin.setCoinStatus(0);//解冻
		userCoinDao.update(userCoin);
	}
}
