package com.xunlei.niux.data.coin.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.LotteryRecord;
@Service
public class LotteryRecordBoImpl implements LotteryRecordBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(LotteryRecord bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<LotteryRecord> find(LotteryRecord bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<LotteryRecord> find(LotteryRecord bizInfo, Page page) {
		return baseDao.findByObject(LotteryRecord.class, bizInfo, page);
	}
	public int count(LotteryRecord bizInfo) {
		return baseDao.count(bizInfo);
	}

	public LotteryRecord find(Long seqId) {
		return baseDao.findById(LotteryRecord.class, seqId);
	}

	public LotteryRecord find(String userId) {
		LotteryRecord bizInfo=new LotteryRecord();
		bizInfo.setUserId(userId);
		List<LotteryRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(LotteryRecord bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(LotteryRecord.class, seqId);
	}
	@Override
	public LotteryRecord findByOrderId(String orderId) {
		LotteryRecord bizInfo=new LotteryRecord();
		bizInfo.setOrderId(orderId);
		List<LotteryRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

}
