package com.xunlei.niux.data.coin.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.LotteryInfoRecord;
@Service
public class LotteryInfoRecordBoImpl implements LotteryInfoRecordBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(LotteryInfoRecord bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<LotteryInfoRecord> find(LotteryInfoRecord bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<LotteryInfoRecord> find(LotteryInfoRecord bizInfo, Page page) {
		return baseDao.findByObject(LotteryInfoRecord.class, bizInfo, page);
	}
	public int count(LotteryInfoRecord bizInfo) {
		return baseDao.count(bizInfo);
	}

	public LotteryInfoRecord find(Long seqId) {
		return baseDao.findById(LotteryInfoRecord.class, seqId);
	}

	public LotteryInfoRecord find(Integer coin) {
		LotteryInfoRecord bizInfo=new LotteryInfoRecord();
		bizInfo.setCoin(coin);
		List<LotteryInfoRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(LotteryInfoRecord bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(LotteryInfoRecord.class, seqId);
	}

}
