package com.xunlei.niux.data.coin.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.LotteryInfo;
@Service
public class LotteryInfoBoImpl implements LotteryInfoBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(LotteryInfo bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<LotteryInfo> find(LotteryInfo bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<LotteryInfo> find(LotteryInfo bizInfo, Page page) {
		return baseDao.findByObject(LotteryInfo.class, bizInfo, page);
	}
	public int count(LotteryInfo bizInfo) {
		return baseDao.count(bizInfo);
	}

	public LotteryInfo find(Long seqId) {
		return baseDao.findById(LotteryInfo.class, seqId);
	}

	public LotteryInfo find(Integer coin) {
		LotteryInfo bizInfo=new LotteryInfo();
		bizInfo.setCoin(coin);
		List<LotteryInfo> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(LotteryInfo bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(LotteryInfo.class, seqId);
	}

}
