package com.xunlei.niux.data.coin.bo;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.constant.CoinConstant;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.CoinTransDao;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.exception.CoinErrorCode;
import com.xunlei.niux.data.coin.exception.CoinRuntimeException;
import com.xunlei.niux.data.coin.vo.CoinTrans;
import com.xunlei.niux.data.coin.vo.UserCoin;
@Service
public class CoinTransBoImpl implements CoinTransBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Autowired
	private CoinTransDao coinTransDao;
	@Autowired
	private UserCoinDao userCoinDao;
	
	public CoinTrans find(final String userId, final long seqId) {
		CoinTrans coinTrans=new CoinTrans();
		coinTrans.setUserId(userId);
		coinTrans.setSeqId(seqId);
		List<CoinTrans> list=find(coinTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<CoinTrans> find(final CoinTrans coinTrans,final Page page){
		return coinTransDao.find(coinTrans, page);
	}
	public int count(final CoinTrans pTrans){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return coinTransDao.count(pTrans.getUserId(), pTrans);
	}
	public List<CoinTrans> find(final CoinTrans coinTrans, final String actNoArr, final Page page){
		return coinTransDao.find(coinTrans, actNoArr, page);
	}
	public int count(final CoinTrans pTrans, final String actNoArr){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return coinTransDao.count(pTrans.getUserId(), actNoArr, pTrans);
	}
	public CoinTrans find(final String userId,final String bizNo,final String transNo,final String transDirect){
		CoinTrans coinTrans=new CoinTrans();
		coinTrans.setUserId(userId);
		coinTrans.setBizNo(bizNo);
		coinTrans.setTransNo(transNo);
		coinTrans.setTransDirect(transDirect);
		List<CoinTrans> list=find(coinTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	/**
	 * 插入欢乐券交易
	 */
	public void insert(final CoinTrans coinTrans) {
		if(coinTrans==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易为空");
		}
		//检查参数是否合法
		checkCoinTransParam(coinTrans);
		//判断业务编号和申请未编号是否已经插入
		if(find(coinTrans.getUserId(),coinTrans.getBizNo(),coinTrans.getTransNo(),coinTrans.getTransDirect())!=null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1001,"业务号["+coinTrans.getBizNo()
					+"]的交易编号["+coinTrans.getTransNo()+"]交易方向["+coinTrans.getTransDirect()+"]已处理");
		}
		//查询用户欢乐券信息，并且锁定
		UserCoin userCoin=userCoinDao.find(coinTrans.getUserId(), SqlLock.UPDATE);
		//计算欢乐券
		userCoin=calUserCoin(userCoin, coinTrans);
		if(userCoin.getSeqId()==null||userCoin.getSeqId()<=0){
			//插入数据
			userCoinDao.insert(userCoin);
		}else{
			//更新数据
			userCoinDao.update(userCoin);
		}
		//插入欢乐券交易记录
		coinTrans.setTransTime(sdf.format(new Date()));
		coinTransDao.insert(coinTrans);
	}
	/**
	 * 计算用户欢乐券transdirect=1:消费欢乐券；transdirect=2:充值欢乐券；
	 */
	private UserCoin calUserCoin(final UserCoin userCoin,final CoinTrans coinTrans){
		if(CoinConstant.COIN_TRANSDIRECT_CONSUME.equals(coinTrans.getTransDirect())){
			//消费欢乐券
			return calUserCoinConsume(userCoin, coinTrans);
		}else if(CoinConstant.COIN_TRANSDIRECT_RECHARGE.equals(coinTrans.getTransDirect())){
			//充值欢乐券
			return calUserCoinRecharge(userCoin, coinTrans);
		}else if(CoinConstant.COIN_TRANSDIRECT_CONSUMERETURN.equals(coinTrans.getTransDirect())){
			//消费欢乐券返还
			return calUserCoinConsumeReturn(userCoin, coinTrans);
		}
		else{
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易类型["+coinTrans.getTransDirect()+"]未知");
		}
	}
	/**
	 * 计算充值欢乐券
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinRecharge(UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			//第一次记录
			userCoin=new UserCoin();
			userCoin.setUserId(coinTrans.getUserId());
			userCoin.setUserName(coinTrans.getUserName());
			userCoin.setCoinLevel(0);
			userCoin.setCoinNum(0);
			userCoin.setConsumeSum(0L);
			userCoin.setRechargeSum(0L);
			userCoin.setCoinStatus(0);
		}
		userCoin.setCoinNum(userCoin.getCoinNum()+coinTrans.getTransNum());
		userCoin.setRechargeSum(userCoin.getRechargeSum()+coinTrans.getTransNum());
		userCoin.setLastRechargeTime(sdf.format(new Date()));
		userCoin.setCoinLevel(calUserCoinLevel(userCoin));
		if(userCoin.getCoinNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]欢乐券溢出");
		}
		return userCoin;
	}
	/**
	 * 用户消费欢乐券返还（退单）
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinConsumeReturn(final UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1020,"欢乐券不存在");
		}
		if(userCoin.getConsumeSum()-coinTrans.getTransNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1021,"用户["+userCoin.getUserId()+"]返还欢乐券不够");
		}
		userCoin.setCoinNum(userCoin.getCoinNum()+coinTrans.getTransNum());
		userCoin.setConsumeSum(userCoin.getConsumeSum()-coinTrans.getTransNum());
		if(userCoin.getCoinNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]欢乐券溢出");
		}
		return userCoin;
	}
	/**
	 * 计算消费欢乐券
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinConsume(final UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1020,"欢乐券不存在");
		}
		if(userCoin.getCoinStatus()>0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1022,"用户["+userCoin.getUserId()+"]欢乐券被冻结");
		}
		if(userCoin.getCoinNum()-coinTrans.getTransNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1021,"用户["+userCoin.getUserId()+"]欢乐券不够");
		}
		userCoin.setCoinNum(userCoin.getCoinNum()-coinTrans.getTransNum());
		userCoin.setConsumeSum(userCoin.getConsumeSum()+coinTrans.getTransNum());
		if(userCoin.getConsumeSum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]消费欢乐券溢出");
		}
		userCoin.setLastConsumeTime(sdf.format(new Date()));
		return userCoin;
	}
	public void checkCoinTransParam(final CoinTrans coinTrans){
		if(coinTrans.getTransNo()==null||"".equals(coinTrans.getTransNo())){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"交易编号为空");
		}
		if(coinTrans.getTransDirect()==null||"".equals(coinTrans.getTransDirect())){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易方向为空");
		}
		if(coinTrans.getTransNum()<=0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"交易欢乐券小于或等于0");
		}
	}
	/**
	 * 计算欢乐券等级
	 * @param userCoin
	 * @return
	 */
	private int calUserCoinLevel(final UserCoin userCoin){
		Long sumcoin=userCoin.getRechargeSum();
		if(sumcoin<5){
			return 0;
		}
		if(sumcoin<10){
			return 1;
		}
		if(sumcoin<15){
			return 2;
		}
		if(sumcoin<20){
			return 3;
		}
		if(sumcoin<30){
			return 4;
		}
		if(sumcoin<40){
			return 5;
		}
		if(sumcoin<50){
			return 6;
		}
		if(sumcoin<60){
			return 7;
		}
		if(sumcoin<75){
			return 8;
		}
		if(sumcoin<90){
			return 9;
		}
		for(int i=10;i<99;i++){
			if((i-4)*(i-4)*3>sumcoin){
				return i;
			}
		}
		return 99;
	}
	public CoinTransDao getCoinTransDao() {
		return coinTransDao;
	}
	public void setCoinTransDao(final CoinTransDao coinTransDao) {
		this.coinTransDao = coinTransDao;
	}
	public UserCoinDao getUserCoinDao() {
		return userCoinDao;
	}
	public void setUserCoinDao(final UserCoinDao userCoinDao) {
		this.userCoinDao = userCoinDao;
	}
	
	@Override
	public List<CoinTrans> findDateSub(final String userId, final String expr,
			final Page page) {
		return coinTransDao.findDateSub(userId, expr, page);
	}
	@Override
	public List<CoinTrans> findPeriod(final String userId, final String startTime,
			final String endTime, final Page page) {
		return coinTransDao.findPeriod(userId, startTime, endTime, null, page);
	}
	
	public Integer getTodayCoin(String userId){
		return coinTransDao.getTodayCoin(userId);
	}
	
	@Override
	public int countPeriod(String userId, String startTime, String endTime) {
		return countPeriod(userId, startTime, endTime, null);
	}
	
	@Override
	public List<CoinTrans> findPeriod(String userId, String startTime,
			String endTime, String transDirect, Page page) {
		return coinTransDao.findPeriod(userId, startTime, endTime, transDirect, page);
	}
	@Override
	public int countPeriod(String userId, String startTime, String endTime,
			String transDirect) {
		return coinTransDao.countPeriod(userId, startTime, endTime, transDirect);
	}
	
}
