package com.xunlei.niux.data.coin.bo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.constant.CoinConstant;
import com.xunlei.niux.data.coin.constant.SqlLock;
import com.xunlei.niux.data.coin.dao.CoinTransDao;
import com.xunlei.niux.data.coin.dao.UserCoinDao;
import com.xunlei.niux.data.coin.exception.CoinErrorCode;
import com.xunlei.niux.data.coin.exception.CoinRuntimeException;
import com.xunlei.niux.data.coin.vo.CoinTrans;
import com.xunlei.niux.data.coin.vo.UserCoin;
@Service
public class CoinTransBoImpl implements CoinTransBo {
	private static Logger logger = LoggerFactory.getLogger(CoinTransBoImpl.class.getName());
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Autowired
	private CoinTransDao coinTransDao;
	@Autowired
	private UserCoinDao userCoinDao;
	
	public CoinTrans find(final String userId, final long seqId) {
		CoinTrans coinTrans=new CoinTrans();
		coinTrans.setUserId(userId);
		coinTrans.setSeqId(seqId);
		List<CoinTrans> list=find(coinTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<CoinTrans> find(final CoinTrans coinTrans,final Page page){
		return coinTransDao.find(coinTrans, page);
	}
	public int count(final CoinTrans pTrans){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return coinTransDao.count(pTrans.getUserId(), pTrans);
	}
	public List<CoinTrans> find(final CoinTrans coinTrans, final String actNoArr, final Page page){
		return coinTransDao.find(coinTrans, actNoArr, page);
	}
	public int count(final CoinTrans pTrans, final String actNoArr){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return coinTransDao.count(pTrans.getUserId(), actNoArr, pTrans);
	}
	public CoinTrans find(final String userId,final String bizNo,final String transNo,final String transDirect){
		CoinTrans coinTrans=new CoinTrans();
		coinTrans.setUserId(userId);
		coinTrans.setBizNo(bizNo);
		coinTrans.setTransNo(transNo);
		coinTrans.setTransDirect(transDirect);
		List<CoinTrans> list=find(coinTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	
	/**
	 * 插入欢乐券交易
	 */
	public void insert(final CoinTrans coinTrans) {
		if(coinTrans==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易为空");
		}
		//检查参数是否合法
		checkCoinTransParam(coinTrans);
		//判断业务编号和申请未编号是否已经插入
		if(find(coinTrans.getUserId(),coinTrans.getBizNo(),coinTrans.getTransNo(),coinTrans.getTransDirect())!=null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1001,"业务号["+coinTrans.getBizNo()
					+"]的交易编号["+coinTrans.getTransNo()+"]交易方向["+coinTrans.getTransDirect()+"]已处理");
		}

		//插入欢乐券交易记录。父订单
		coinTrans.setOriginTransNo(coinTrans.getTransNo());//初始化
		coinTrans.setLeftNum(coinTrans.getTransNum());//初始化
		coinTrans.setTransStatus(0);//初始化,成功
		Calendar cal = Calendar.getInstance();
		coinTrans.setTransTime(sdf.format(cal.getTime()));
		cal.add(Calendar.DATE, 60);//欢乐券只有六十天有效期
		coinTrans.setExpireTime(sdf.format(cal.getTime()));
		
		//查询用户欢乐券信息，并且锁定
		UserCoin userCoin=userCoinDao.find(coinTrans.getUserId(), SqlLock.UPDATE);

		//计算欢乐券
		userCoin=calUserCoin(userCoin, coinTrans);
		
		//处理消费订单。为欢乐券增加有效期added。
		if("1".equals(coinTrans.getTransDirect())){
			dealOrderConsume(coinTrans);
		}
		
		if(userCoin.getSeqId()==null||userCoin.getSeqId()<=0){
			//插入数据
			userCoinDao.insert(userCoin);
		}else{
			//更新数据
			userCoinDao.update(userCoin);
		}
		
		coinTransDao.insert(coinTrans);
	}
	/**
	 * 计算用户欢乐券transdirect=1:消费欢乐券；transdirect=2:充值欢乐券；
	 */
	private UserCoin calUserCoin(final UserCoin userCoin,final CoinTrans coinTrans){
		if(CoinConstant.COIN_TRANSDIRECT_CONSUME.equals(coinTrans.getTransDirect())){
			//消费欢乐券
			return calUserCoinConsume(userCoin, coinTrans);
		}else if(CoinConstant.COIN_TRANSDIRECT_RECHARGE.equals(coinTrans.getTransDirect())){
			//充值欢乐券
			return calUserCoinRecharge(userCoin, coinTrans);
		}else if(CoinConstant.COIN_TRANSDIRECT_CONSUMERETURN.equals(coinTrans.getTransDirect())){
			//消费欢乐券返还
			return calUserCoinConsumeReturn(userCoin, coinTrans);
		}
		else{
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易类型["+coinTrans.getTransDirect()+"]未知");
		}
	}
	/**
	 * 计算充值欢乐券
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinRecharge(UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			//第一次记录
			userCoin=new UserCoin();
			userCoin.setUserId(coinTrans.getUserId());
			userCoin.setUserName(coinTrans.getUserName());
			userCoin.setCoinLevel(0);
			userCoin.setCoinNum(0);
			userCoin.setConsumeSum(0L);
			userCoin.setRechargeSum(0L);
			userCoin.setCoinStatus(0);
		}
		userCoin.setCoinNum(userCoin.getCoinNum()+coinTrans.getTransNum());
		userCoin.setRechargeSum(userCoin.getRechargeSum()+coinTrans.getTransNum());
		userCoin.setLastRechargeTime(sdf.format(new Date()));
		userCoin.setCoinLevel(calUserCoinLevel(userCoin));
		if(userCoin.getCoinNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]欢乐券溢出");
		}
		return userCoin;
	}
	/**
	 * 用户消费欢乐券返还（退单）
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinConsumeReturn(final UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1020,"欢乐券不存在");
		}
		if(userCoin.getConsumeSum()-coinTrans.getTransNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1021,"用户["+userCoin.getUserId()+"]返还欢乐券不够");
		}
		userCoin.setCoinNum(userCoin.getCoinNum()+coinTrans.getTransNum());
		userCoin.setConsumeSum(userCoin.getConsumeSum()-coinTrans.getTransNum());
		if(userCoin.getCoinNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]欢乐券溢出");
		}
		
		return userCoin;
	}
	/**
	 * 计算消费欢乐券
	 * @param userCoin
	 * @param coinTrans
	 * @return
	 */
	private UserCoin calUserCoinConsume(final UserCoin userCoin,final CoinTrans coinTrans){
		if(userCoin==null){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1020,"欢乐券不存在");
		}
		if(userCoin.getCoinStatus()>0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1022,"用户["+userCoin.getUserId()+"]欢乐券被冻结");
		}
		if(userCoin.getCoinNum()-coinTrans.getTransNum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1021,"用户["+userCoin.getUserId()+"]欢乐券不够");
		}
		userCoin.setCoinNum(userCoin.getCoinNum()-coinTrans.getTransNum());
		userCoin.setConsumeSum(userCoin.getConsumeSum()+coinTrans.getTransNum());
		if(userCoin.getConsumeSum()<0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1002,"用户["+userCoin.getUserId()+"]消费欢乐券溢出");
		}
		userCoin.setLastConsumeTime(sdf.format(new Date()));
		
		return userCoin;
	}
	
	/**
	 * 消费时，处理充值订单扣减和消费订单插入
	 * @param userCoin
	 * @param coinTrans 原始消费订单
	 */
	private void dealOrderConsume(final CoinTrans coinTrans){
		
		//找出符合条件的充值订单
		SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String startTime = formater.format(new Date());
		String endTime = "2200-01-01 00:00:00";
		
		int count = coinTrans.getTransNum();//找出足够的数量
		Page page = new Page();
		page.setPageNo(1);//一次性找出来
		page.setPageSize(count);
		page.addOrder("expireTime", OrderType.ESC);
		List<CoinTrans> list = coinTransDao.findPeriodexpireTime(coinTrans.getUserId(), startTime, endTime, "2", page, SqlLock.UPDATE);//待更新充值订单
		
		//处理充值订单的剩余数量扣减和消费子订单的生成
		List<CoinTrans> counsumeList = new ArrayList<CoinTrans>();//需要插入的消费订单
		List<CoinTrans> rechargeList = new ArrayList<CoinTrans>();//需要更新的充值订单
		int transSum = 0;
		int index = 0;
		for(CoinTrans ct : list){
			//已使用完
			if(ct.getLeftNum() <= 0){
				continue;
			}
			
			index++;
			
			transSum += ct.getLeftNum();
			
			//消费的最后一笔充值订单
			if(transSum >= coinTrans.getTransNum()){
				//生成消费订单
				int transNum = ct.getLeftNum() - (transSum - coinTrans.getTransNum());
				counsumeList.add(initConsumeTrans(coinTrans, ct.getTransNo(), transNum, index));
				
				//更新充值订单。leftNum不能为0。功能发布后，所有新充值订单的leftNum==transNum
				int leftNum = ct.getLeftNum() - transNum;
				ct.setLeftNum(leftNum);
				rechargeList.add(ct);
				
				break;
			}
			
			//生成消费订单
			counsumeList.add(initConsumeTrans(coinTrans, ct.getTransNo(), ct.getLeftNum(), index));
			
			//更新充值订单
			ct.setLeftNum(0);
			rechargeList.add(ct);
		}
		
		if(transSum < coinTrans.getTransNum()){
			logger.info("dealOrderConsume transSum is less than coinTrans.getTransNum()!coinTrans:"+coinTrans);
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1044,"用户["+coinTrans.getUserId()+"]消费欢乐券出现订单异常：未找到用户的充值订单。");
		}

		//批量提交，保证for update原子性，前提条件是JDBC支持批量提交。如果JDBC不支持批量提交，则可能有并发性问题。
		if(counsumeList.isEmpty() && rechargeList.isEmpty()){
			logger.info("dealOrderConsume counsumeList and rechargeList is empty!coinTrans:"+coinTrans);
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1044,"用户["+coinTrans.getUserId()+"]消费欢乐券出现订单异常：未找到用户的充值订单。");
		}
		
		
		try{
			int[] result = coinTransDao.commitAll(counsumeList, rechargeList);
			
			//打印日志
			counsumeList.addAll(rechargeList);
			int i = 0;
			for(int res : result){
				i++;
				//每条SQL影响行数一定是1才表示成功，不然打印失败。
				if(res != 1){
					CoinTrans obj = counsumeList.size() >= i + 1 ? counsumeList.get(i) : rechargeList.get(i - counsumeList.size());
					logger.info("commitAll result failed：CoinTrans=" + obj + ", result=" + res);
				}
			}
			
		}catch(Exception e){
			logger.info("commitAll Exception!coinTrans:"+coinTrans, e);
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1045,"用户["+coinTrans.getUserId()+"]消费欢乐券出现订单异常：处理订单时出现数据库异常。");
		}
	}

	/**
	 * 初始化订单
	 * @param fatherCoinTrans 父订单 对应带一个消费请求
	 * @param originTransNo 复订单号
	 * @param transNum 子订单消费欢乐券数
	 * @param transIndex transNo的序列号
	 * @return 生成的子订单
	 */
	private CoinTrans initConsumeTrans(CoinTrans fatherCoinTrans, String originTransNo, int transNum, int transIndex){
		
		CoinTrans childCoinTrans = new CoinTrans();
		
		if(!"1".equals(fatherCoinTrans.getTransDirect())){//费消费订单，直接退出
			return childCoinTrans;
		}
		
		//子订单类型跟父订单一致，子订单号跟父订单一致
		BeanUtils.copyProperties(fatherCoinTrans, childCoinTrans);
		childCoinTrans.setSeqId(null);//子订单是新的，要插入
		childCoinTrans.setTransNo(childCoinTrans.getTransNo()+"_"+transIndex);//消费躲避充值订单时报数据库异常
		childCoinTrans.setOriginTransNo(originTransNo);
		childCoinTrans.setTransNum(transNum);
		childCoinTrans.setLeftNum(transNum);
		childCoinTrans.setTransDirect("4");//消费子订单
		
		return childCoinTrans;
	}
	
	
	public void checkCoinTransParam(final CoinTrans coinTrans){
		if(coinTrans.getTransNo()==null||"".equals(coinTrans.getTransNo())){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"交易编号为空");
		}
		if(coinTrans.getTransDirect()==null||"".equals(coinTrans.getTransDirect())){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"欢乐券交易方向为空");
		}
		if(coinTrans.getTransNum()<=0){
			throw new CoinRuntimeException(CoinErrorCode.COIN_CODE_1009,"交易欢乐券小于或等于0");
		}
	}
	
	/**
	 * 计算欢乐券等级
	 * @param userCoin
	 * @return
	 */
	private int calUserCoinLevel(final UserCoin userCoin){
		Long sumcoin=userCoin.getRechargeSum();
		if(sumcoin<5){
			return 0;
		}
		if(sumcoin<10){
			return 1;
		}
		if(sumcoin<15){
			return 2;
		}
		if(sumcoin<20){
			return 3;
		}
		if(sumcoin<30){
			return 4;
		}
		if(sumcoin<40){
			return 5;
		}
		if(sumcoin<50){
			return 6;
		}
		if(sumcoin<60){
			return 7;
		}
		if(sumcoin<75){
			return 8;
		}
		if(sumcoin<90){
			return 9;
		}
		for(int i=10;i<99;i++){
			if((i-4)*(i-4)*3>sumcoin){
				return i;
			}
		}
		return 99;
	}
	public CoinTransDao getCoinTransDao() {
		return coinTransDao;
	}
	public void setCoinTransDao(final CoinTransDao coinTransDao) {
		this.coinTransDao = coinTransDao;
	}
	public UserCoinDao getUserCoinDao() {
		return userCoinDao;
	}
	public void setUserCoinDao(final UserCoinDao userCoinDao) {
		this.userCoinDao = userCoinDao;
	}
	
	@Override
	public List<CoinTrans> findDateSub(final String userId, final String expr,
			final Page page) {
		return coinTransDao.findDateSub(userId, expr, page);
	}
	@Override
	public List<CoinTrans> findPeriod(final String userId, final String startTime,
			final String endTime, final Page page) {
		return coinTransDao.findPeriod(userId, startTime, endTime, null, page);
	}
	
	public Integer getTodayCoin(String userId){
		return coinTransDao.getTodayCoin(userId);
	}
	
	@Override
	public int countPeriod(String userId, String startTime, String endTime) {
		return countPeriod(userId, startTime, endTime, null);
	}
	
	@Override
	public List<CoinTrans> findPeriod(String userId, String startTime,
			String endTime, String transDirect, Page page) {
		return coinTransDao.findPeriod(userId, startTime, endTime, transDirect, page);
	}
	@Override
	public int countPeriod(String userId, String startTime, String endTime,
			String transDirect) {
		return coinTransDao.countPeriod(userId, startTime, endTime, transDirect);
	}
	
}
