package com.xunlei.niux.data.coin.bo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.dto.LotteryDataDTO;
import com.xunlei.niux.data.coin.vo.LotteryRecord;
@Service
public class LotteryRecordBoImpl implements LotteryRecordBo {
	private static final String SQL_BEGIN = "SELECT a.seqId,a.status status,SUM(a.coin) AS coin," +
			"SUM(b.succsessCashMoney) AS succsessCashMoney," +
			"SUM(b.succsessVoucherMoney) AS succsessVoucherMoney," +
			"SUM(b.failCashMoney) AS failCashMoney, " +
			"SUM(b.failVoucherMoney) AS failVoucherMoney," +
			"COUNT(status) AS count ," +
			"COUNT(DISTINCT a.cashNo) AS cashNum ," +
			"COUNT(DISTINCT a.voucherNo) AS voucherNum " +
			"FROM lotteryrecord a LEFT OUTER JOIN lotteryinfo b ON a.coin=b.coin " +
			"WHERE  1=1 ";
	private static final String SQL_END = " group by status ";
	
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(LotteryRecord bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<LotteryRecord> find(LotteryRecord bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<LotteryRecord> find(LotteryRecord bizInfo, Page page) {
		return baseDao.findByObject(LotteryRecord.class, bizInfo, page);
	}
	public int count(LotteryRecord bizInfo) {
		return baseDao.count(bizInfo);
	}

	public LotteryRecord find(Long seqId) {
		return baseDao.findById(LotteryRecord.class, seqId);
	}

	public LotteryRecord find(String userId) {
		LotteryRecord bizInfo=new LotteryRecord();
		bizInfo.setUserId(userId);
		List<LotteryRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(LotteryRecord bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(LotteryRecord.class, seqId);
	}
	@Override
	public LotteryRecord findByOrderId(String orderId) {
		LotteryRecord bizInfo=new LotteryRecord();
		bizInfo.setOrderId(orderId);
		List<LotteryRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}


	@Override
	public List<LotteryDataDTO> summary(LotteryRecord lotteryRecord) {
		StringBuilder sb = new StringBuilder(SQL_BEGIN);
		List<Object> args = new ArrayList<Object>();
		if(lotteryRecord != null){
			if(!StringUtils.isEmpty(lotteryRecord.getUserId())){
				args.add(lotteryRecord.getUserId());
				sb.append(" and a.userId = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getActNo())){
				args.add(lotteryRecord.getActNo());
				sb.append(" and a.actNo = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getAdvNo())){
				args.add(lotteryRecord.getAdvNo());
				sb.append(" and a.advNo = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getStatus())){
				args.add(lotteryRecord.getStatus());
				sb.append(" and a.status = ?");
			}
			
			if(lotteryRecord.getCoin() != null && lotteryRecord.getCoin() != 0){
				args.add(lotteryRecord.getCoin());
				sb.append(" and a.coin = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getBizNo())){
				args.add(lotteryRecord.getBizNo());
				sb.append(" and a.bizNo = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getGameId())){
				args.add(lotteryRecord.getGameId());
				sb.append(" and a.gameId = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getServerId())){
				args.add(lotteryRecord.getServerId());
				sb.append(" and a.serverId = ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getBeginTime())){
				args.add(lotteryRecord.getBeginTime());
				sb.append(" and a.time >= ?");
			}
			
			if(!StringUtils.isEmpty(lotteryRecord.getEndTime())){
				args.add(lotteryRecord.getEndTime());
				sb.append(" and a.time <= ?");
			}
			
			sb.append(SQL_END);
		}
		
		List<LotteryDataDTO> data = baseDao.executeQuery(LotteryDataDTO.class, sb.toString(), args);
		return data;
	}
}
