package com.xunlei.niux.data.coin.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.coin.vo.CoinExchangeRecord;
import com.xunlei.niux.data.coin.vo.LotteryRecord;
@Service
public class CoinExchangeRecordBoImpl implements CoinExchangeRecordBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(CoinExchangeRecord bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<CoinExchangeRecord> find(CoinExchangeRecord bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<CoinExchangeRecord> find(CoinExchangeRecord bizInfo, Page page) {
		return baseDao.findByObject(CoinExchangeRecord.class, bizInfo, page);
	}
	public int count(CoinExchangeRecord bizInfo) {
		return baseDao.count(bizInfo);
	}

	public CoinExchangeRecord find(Long seqId) {
		return baseDao.findById(CoinExchangeRecord.class, seqId);
	}

	public CoinExchangeRecord find(String userId) {
		CoinExchangeRecord bizInfo=new CoinExchangeRecord();
		bizInfo.setUserId(userId);
		List<CoinExchangeRecord> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(CoinExchangeRecord bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(LotteryRecord.class, seqId);
	}

}
