package com.xunlei.niux.data.clientgame.util.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;


/**
 * @ClassName: AbstractHttpRequest 
 * @Description: 椋庢帶鏈嶅姟鎿嶄綔璇锋眰锟�
 * @author Zhansong Wei 
 * @date Mar 19, 2012 5:07:33 PM
 *
 */
public abstract class AbstractHttpRequest implements IRequest{
//	private static Logger logger = Logger.getLogger(AbstractHttpRequest.class);
	
	public String execute(String url){
		String resp = getRequest(url);
		return dealResult(resp);
	}
	
	
	protected String getRequest(String path){
		System.out.println("request url:"+path);
		StringBuilder builder = new StringBuilder();
		try{
			URL url = new URL(path);
			HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
			int state = 0;
			httpURLConnection.setRequestProperty("user-agent", "mozilla/4.0 (compatible;x11;Linux i686)");
			httpURLConnection.setRequestProperty("Connection", "close");
			httpURLConnection.setConnectTimeout(30000);
			httpURLConnection.setReadTimeout(30000);
			httpURLConnection.connect();	
			state = httpURLConnection.getResponseCode();
			System.out.println("state:"+state);
			InputStream in = httpURLConnection.getInputStream();
		
			BufferedReader br = new BufferedReader(new InputStreamReader(in,"utf-8"));
			
			String line = null;
			while ((line=br.readLine())!=null) {
				builder.append(line);
			}
			
			in.close();
		}catch (Exception e) {
			System.out.println("Exception:"+e.getMessage());
			System.err.println(e.getMessage());	
		}

		System.out.println("result:"+builder);
		return builder==null?null:builder.toString();
	}
	
	protected boolean isNotEmpty(String str) {
		if(str==null || "".endsWith(str)){
			return false;
		}
		return true;
	}
	protected abstract String dealResult(String resp);
}
