package com.xunlei.niux.data.clientgame.util;

import java.util.HashMap;
import java.util.Map;

import com.xunlei.niux.data.clientgame.vo.DsConfig;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

public class DataSourceUtil {

	public static Map<String,String> DATASOURCENAMEMAP;
	public static Map<String,DsConfig> DATASOURCEMAP; //充值数据源
	
	public static Map<String,String> PAYDBNAMEMAP;  //支付数据库 在不同数据源里的数据库名
	
	public static String REPAY_KEY;
	public static String REPAY_URL;
	
	static {
		init();
	}
	
	private static void init(){
		String datasources = EnvPropertyUtil.loadProperty("gamepay","datasources");
		String dsArr[] = datasources.split(",");
		DATASOURCENAMEMAP = new HashMap<String,String>();
		DATASOURCEMAP = new HashMap<String,DsConfig>();
		PAYDBNAMEMAP = new HashMap<String,String>();
		for(String ds:dsArr){
			String dsname = EnvPropertyUtil.loadProperty("gamepay","dbname_"+ds);
			DsConfig dsConfig = new DsConfig();
			dsConfig.setDburl(EnvPropertyUtil.loadProperty("gamepay","dburl_"+ds));
			dsConfig.setDbusr(EnvPropertyUtil.loadProperty("gamepay","dbusr_"+ds));
			dsConfig.setDbpwd(EnvPropertyUtil.loadProperty("gamepay","dbpwd_"+ds));
			String paydbname=EnvPropertyUtil.loadProperty("gamepay","paydbname_"+ds);
			DATASOURCENAMEMAP.put(ds, dsname);
			DATASOURCEMAP.put(ds, dsConfig);
			PAYDBNAMEMAP.put(ds,paydbname);
		}
		REPAY_KEY = EnvPropertyUtil.loadProperty("gamepay","repay_key");
		REPAY_URL = EnvPropertyUtil.loadProperty("gamepay","repay_url");
	}
	
	public static void main(String args[]){
		for(String key:DATASOURCENAMEMAP.keySet()){
			System.out.println(DATASOURCENAMEMAP.get(key));
		}
		for(String key:DATASOURCEMAP.keySet()){
			DsConfig dsConfig = DATASOURCEMAP.get(key);
			System.out.println(key);
			System.out.println(dsConfig.getDbusr());
			System.out.println(dsConfig.getDburl());
			System.out.println(dsConfig.getDbpwd());
		}
		
	}
}

