package com.xunlei.niux.data.clientgame.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;


public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/clientgame/xml/tomcatjndi.xml","com/xunlei/niux/data/clientgame/xml/applicationContext.xml"}).getBean("Facade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/clientgame/xml/jdbc.xml","com/xunlei/niux/data/clientgame/xml/applicationContext.xml"}).getBean("Facade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/clientgame/xml/springjndi.xml","com/xunlei/niux/data/clientgame/xml/applicationContext.xml"}).getBean("Facade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
