package com.xunlei.niux.data.clientgame.dao;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.clientgame.vo.PayDetailOKHistory;

public class PayDetailOKHistoryDaoImpl extends BaseDaoImpl implements IPayDetailOKHistoryDao {

	private static Logger log = Logger.getLogger(PayDetailOKHistoryDaoImpl.class);
	
	@Override
	public Sheet<PayDetailOKHistory> query(PayDetailOKHistory data,PagedFliper fliper) {
		List<Object> paramList=new ArrayList<Object>();

		String sql = "select * from paydetailokhistory ";
		String rowsql = "select count(1) from paydetailokhistory";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		
		if(StringUtils.isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid=?");
			paramList.add(data.getGameid());
		}
		
		if(StringUtils.isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType=?");
			paramList.add(data.getChargetype());
		}
		
		if(StringUtils.isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo=?");
			paramList.add(data.getBankno());
		}
		
		if(StringUtils.isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName=?");
			paramList.add(data.getFromusername());
		}
		
		if(StringUtils.isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid=?");
			paramList.add(data.getFrominneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName=?");
			paramList.add(data.getTousername());
		}
		
		if(StringUtils.isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid=?");
			paramList.add(data.getToinneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid=?");
			paramList.add(data.getServerid());
		}
		
		if(StringUtils.isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName=?");
			paramList.add(data.getServername());
		}
		
		if(StringUtils.isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId=?");
			paramList.add(data.getRoleid());
		}
		
		if(StringUtils.isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName=?");
			paramList.add(data.getRolename());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId=?");
			paramList.add(data.getOrderid());
		}
		
//		if(StringUtils.isNotEmpty(data.getReferfrom())){
//			wheresql.append(" And Referfrom=?");
//		paramList.add(data.getReferfrom());
//		}
		if(StringUtils.isNotEmpty(data.getFromOrderTime())){
			String fromOrderTime = data.getFromOrderTime() + " 00:00:00";
			wheresql.append(" And OrderTime>=?");
			paramList.add(fromOrderTime);
		}
		
		if(StringUtils.isNotEmpty(data.getToOrderTime())){
			String toOrderTime = data.getToOrderTime() + " 23:59:59";
			wheresql.append(" And OrderTime<=?");
			paramList.add(toOrderTime);
		}
		
		rowsql += wheresql.toString();
		log.info("rowsql:"+rowsql);
		int rowcount = this.getJdbcTemplate().queryForInt(rowsql, paramList.toArray());
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		sql += wheresql.toString();
		
		if (fliper != null) {
			if(StringUtils.isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<PayDetailOKHistory>(rowcount,this.executeQuery(PayDetailOKHistory.class, sql, paramList));
	}

}
